/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.info;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.TreeMap;
import org.flywaydb.core.api.MigrationInfo;
import org.flywaydb.core.api.MigrationInfoService;
import org.flywaydb.core.api.MigrationState;
import org.flywaydb.core.api.MigrationType;
import org.flywaydb.core.api.MigrationVersion;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.resolver.Context;
import org.flywaydb.core.api.resolver.MigrationResolver;
import org.flywaydb.core.api.resolver.ResolvedMigration;
import org.flywaydb.core.internal.info.AppliedMigrationAttributes;
import org.flywaydb.core.internal.info.MigrationInfoContext;
import org.flywaydb.core.internal.info.MigrationInfoImpl;
import org.flywaydb.core.internal.schemahistory.AppliedMigration;
import org.flywaydb.core.internal.schemahistory.SchemaHistory;
import org.flywaydb.core.internal.util.Pair;

public class MigrationInfoServiceImpl
implements MigrationInfoService {
    private final MigrationResolver migrationResolver;
    private final Context context;
    private final SchemaHistory schemaHistory;
    private MigrationVersion target;
    private boolean outOfOrder;
    private final boolean pending;
    private final boolean missing;
    private final boolean ignored;
    private final boolean future;
    private List<MigrationInfoImpl> migrationInfos;

    public MigrationInfoServiceImpl(MigrationResolver migrationResolver, SchemaHistory schemaHistory, final Configuration configuration, MigrationVersion target, boolean outOfOrder, boolean pending, boolean missing, boolean ignored, boolean future) {
        this.migrationResolver = migrationResolver;
        this.schemaHistory = schemaHistory;
        this.context = new Context(){

            @Override
            public Configuration getConfiguration() {
                return configuration;
            }
        };
        this.target = target;
        this.outOfOrder = outOfOrder;
        this.pending = pending;
        this.missing = missing;
        this.ignored = ignored;
        this.future = future;
    }

    public void refresh() {
        Object version;
        Collection<ResolvedMigration> resolvedMigrations = this.migrationResolver.resolveMigrations(this.context);
        List<AppliedMigration> appliedMigrations = this.schemaHistory.allAppliedMigrations();
        MigrationInfoContext context = new MigrationInfoContext();
        context.outOfOrder = this.outOfOrder;
        context.pending = this.pending;
        context.missing = this.missing;
        context.ignored = this.ignored;
        context.future = this.future;
        context.target = this.target;
        TreeMap resolvedVersioned = new TreeMap();
        TreeMap<String, ResolvedMigration> resolvedRepeatable = new TreeMap<String, ResolvedMigration>();
        for (ResolvedMigration resolvedMigration : resolvedMigrations) {
            MigrationVersion version2 = resolvedMigration.getVersion();
            if (version2 != null) {
                if (version2.compareTo(context.lastResolved) > 0) {
                    context.lastResolved = version2;
                }
                resolvedVersioned.put(Pair.of(version2, false), resolvedMigration);
                continue;
            }
            resolvedRepeatable.put(resolvedMigration.getDescription(), resolvedMigration);
        }
        ArrayList<Pair<AppliedMigration, AppliedMigrationAttributes>> appliedVersioned = new ArrayList<Pair<AppliedMigration, AppliedMigrationAttributes>>();
        ArrayList<AppliedMigration> appliedRepeatable = new ArrayList<AppliedMigration>();
        for (AppliedMigration appliedMigration : appliedMigrations) {
            version = appliedMigration.getVersion();
            if (version == null) {
                appliedRepeatable.add(appliedMigration);
                continue;
            }
            if (appliedMigration.getType() == MigrationType.SCHEMA) {
                context.schema = version;
            }
            if (appliedMigration.getType() == MigrationType.BASELINE) {
                context.baseline = version;
            }
            appliedVersioned.add(Pair.of(appliedMigration, new AppliedMigrationAttributes()));
        }
        for (Pair pair : appliedVersioned) {
            version = ((AppliedMigration)pair.getLeft()).getVersion();
            if (version == null) continue;
            if (((MigrationVersion)version).compareTo(context.lastApplied) > 0) {
                context.lastApplied = version;
                continue;
            }
            ((AppliedMigrationAttributes)pair.getRight()).outOfOrder = true;
        }
        if (MigrationVersion.CURRENT == this.target) {
            context.target = context.lastApplied;
        }
        ArrayList<MigrationInfoImpl> migrationInfos1 = new ArrayList<MigrationInfoImpl>();
        HashSet hashSet = new HashSet(resolvedVersioned.values());
        for (Pair pair : appliedVersioned) {
            ResolvedMigration resolvedMigration = (ResolvedMigration)resolvedVersioned.get(Pair.of(((AppliedMigration)pair.getLeft()).getVersion(), ((AppliedMigration)pair.getLeft()).getType().isUndo()));
            if (resolvedMigration != null) {
                hashSet.remove(resolvedMigration);
            }
            migrationInfos1.add(new MigrationInfoImpl(resolvedMigration, (AppliedMigration)pair.getLeft(), context, ((AppliedMigrationAttributes)pair.getRight()).outOfOrder));
        }
        for (ResolvedMigration resolvedMigration : hashSet) {
            migrationInfos1.add(new MigrationInfoImpl(resolvedMigration, null, context, false));
        }
        for (AppliedMigration appliedMigration : appliedRepeatable) {
            if (context.latestRepeatableRuns.containsKey(appliedMigration.getDescription()) && appliedMigration.getInstalledRank() <= context.latestRepeatableRuns.get(appliedMigration.getDescription())) continue;
            context.latestRepeatableRuns.put(appliedMigration.getDescription(), appliedMigration.getInstalledRank());
        }
        HashSet pendingResolvedRepeatable = new HashSet(resolvedRepeatable.values());
        for (AppliedMigration appliedRepeatableMigration : appliedRepeatable) {
            ResolvedMigration resolvedMigration = (ResolvedMigration)resolvedRepeatable.get(appliedRepeatableMigration.getDescription());
            int latestRank = context.latestRepeatableRuns.get(appliedRepeatableMigration.getDescription());
            if (resolvedMigration != null && appliedRepeatableMigration.getInstalledRank() == latestRank && Objects.equals(appliedRepeatableMigration.getChecksum(), resolvedMigration.getChecksum())) {
                pendingResolvedRepeatable.remove(resolvedMigration);
            }
            migrationInfos1.add(new MigrationInfoImpl(resolvedMigration, appliedRepeatableMigration, context, false));
        }
        for (ResolvedMigration prr : pendingResolvedRepeatable) {
            migrationInfos1.add(new MigrationInfoImpl(prr, null, context, false));
        }
        Collections.sort(migrationInfos1);
        this.migrationInfos = migrationInfos1;
    }

    @Override
    public MigrationInfo[] all() {
        return this.migrationInfos.toArray(new MigrationInfo[0]);
    }

    @Override
    public MigrationInfo current() {
        MigrationInfoImpl current = null;
        for (MigrationInfoImpl migrationInfo : this.migrationInfos) {
            if (!migrationInfo.getState().isApplied() || migrationInfo.getVersion() == null || current != null && migrationInfo.getVersion().compareTo(current.getVersion()) <= 0) continue;
            current = migrationInfo;
        }
        if (current != null) {
            return current;
        }
        for (int i = this.migrationInfos.size() - 1; i >= 0; --i) {
            MigrationInfoImpl migrationInfo;
            migrationInfo = this.migrationInfos.get(i);
            if (!migrationInfo.getState().isApplied()) continue;
            return migrationInfo;
        }
        return null;
    }

    public MigrationInfoImpl[] pending() {
        ArrayList<MigrationInfoImpl> pendingMigrations = new ArrayList<MigrationInfoImpl>();
        for (MigrationInfoImpl migrationInfo : this.migrationInfos) {
            if (MigrationState.PENDING != migrationInfo.getState()) continue;
            pendingMigrations.add(migrationInfo);
        }
        return pendingMigrations.toArray(new MigrationInfoImpl[0]);
    }

    public MigrationInfoImpl[] applied() {
        ArrayList<MigrationInfoImpl> appliedMigrations = new ArrayList<MigrationInfoImpl>();
        for (MigrationInfoImpl migrationInfo : this.migrationInfos) {
            if (!migrationInfo.getState().isApplied()) continue;
            appliedMigrations.add(migrationInfo);
        }
        return appliedMigrations.toArray(new MigrationInfoImpl[0]);
    }

    public MigrationInfo[] resolved() {
        ArrayList<MigrationInfo> resolvedMigrations = new ArrayList<MigrationInfo>();
        for (MigrationInfo migrationInfo : this.migrationInfos) {
            if (!migrationInfo.getState().isResolved()) continue;
            resolvedMigrations.add(migrationInfo);
        }
        return resolvedMigrations.toArray(new MigrationInfo[0]);
    }

    public MigrationInfo[] failed() {
        ArrayList<MigrationInfo> failedMigrations = new ArrayList<MigrationInfo>();
        for (MigrationInfo migrationInfo : this.migrationInfos) {
            if (!migrationInfo.getState().isFailed()) continue;
            failedMigrations.add(migrationInfo);
        }
        return failedMigrations.toArray(new MigrationInfo[0]);
    }

    public MigrationInfo[] future() {
        ArrayList<MigrationInfo> futureMigrations = new ArrayList<MigrationInfo>();
        for (MigrationInfo migrationInfo : this.migrationInfos) {
            if (migrationInfo.getState() != MigrationState.FUTURE_SUCCESS && migrationInfo.getState() != MigrationState.FUTURE_FAILED) continue;
            futureMigrations.add(migrationInfo);
        }
        return futureMigrations.toArray(new MigrationInfo[0]);
    }

    public MigrationInfo[] outOfOrder() {
        ArrayList<MigrationInfo> outOfOrderMigrations = new ArrayList<MigrationInfo>();
        for (MigrationInfo migrationInfo : this.migrationInfos) {
            if (migrationInfo.getState() != MigrationState.OUT_OF_ORDER) continue;
            outOfOrderMigrations.add(migrationInfo);
        }
        return outOfOrderMigrations.toArray(new MigrationInfo[0]);
    }

    public String validate() {
        StringBuilder builder = new StringBuilder();
        boolean hasFailures = false;
        for (MigrationInfoImpl migrationInfo : this.migrationInfos) {
            String message = migrationInfo.validate();
            if (message == null) continue;
            if (!hasFailures) {
                builder.append("\n");
            }
            builder.append(message + "\n");
            hasFailures = true;
        }
        return hasFailures ? builder.toString() : null;
    }
}

