/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.resolver;

import java.util.Objects;
import org.flywaydb.core.api.MigrationType;
import org.flywaydb.core.api.MigrationVersion;
import org.flywaydb.core.api.executor.MigrationExecutor;
import org.flywaydb.core.api.resolver.ResolvedMigration;

public class ResolvedMigrationImpl
implements ResolvedMigration {
    private final MigrationVersion version;
    private final String description;
    private final String script;
    private final Integer checksum;
    private final MigrationType type;
    private final String physicalLocation;
    private final MigrationExecutor executor;

    public ResolvedMigrationImpl(MigrationVersion version, String description, String script, Integer checksum, MigrationType type, String physicalLocation, MigrationExecutor executor) {
        this.version = version;
        this.description = description;
        this.script = script;
        this.checksum = checksum;
        this.type = type;
        this.physicalLocation = physicalLocation;
        this.executor = executor;
    }

    @Override
    public MigrationVersion getVersion() {
        return this.version;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getScript() {
        return this.script;
    }

    @Override
    public Integer getChecksum() {
        return this.checksum;
    }

    @Override
    public MigrationType getType() {
        return this.type;
    }

    @Override
    public String getPhysicalLocation() {
        return this.physicalLocation;
    }

    @Override
    public MigrationExecutor getExecutor() {
        return this.executor;
    }

    public int compareTo(ResolvedMigrationImpl o) {
        return this.version.compareTo(o.version);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResolvedMigrationImpl migration = (ResolvedMigrationImpl)o;
        if (this.checksum != null ? !this.checksum.equals(migration.checksum) : migration.checksum != null) {
            return false;
        }
        if (this.description != null ? !this.description.equals(migration.description) : migration.description != null) {
            return false;
        }
        if (this.script != null ? !this.script.equals(migration.script) : migration.script != null) {
            return false;
        }
        if (this.type != migration.type) {
            return false;
        }
        return Objects.equals(this.version, migration.version);
    }

    public int hashCode() {
        int result = this.version != null ? this.version.hashCode() : 0;
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 31 * result + (this.script != null ? this.script.hashCode() : 0);
        result = 31 * result + (this.checksum != null ? this.checksum.hashCode() : 0);
        result = 31 * result + this.type.hashCode();
        return result;
    }

    public String toString() {
        return "ResolvedMigrationImpl{version=" + this.version + ", description='" + this.description + '\'' + ", script='" + this.script + '\'' + ", checksum=" + this.checksum + ", type=" + (Object)((Object)this.type) + ", physicalLocation='" + this.physicalLocation + '\'' + ", executor=" + this.executor + '}';
    }

    public void validate() {
    }
}

