/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.parser;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.internal.database.base.Connection;
import org.flywaydb.core.internal.database.base.Database;
import org.flywaydb.core.internal.database.base.Schema;

public class ParsingContext {
    private static final Log LOG = LogFactory.getLog(ParsingContext.class);
    private static final String DEFAULT_SCHEMA_PLACEHOLDER = "flyway:defaultSchema";
    private static final String USER_PLACEHOLDER = "flyway:user";
    private static final String DATABASE_PLACEHOLDER = "flyway:database";
    private Map<String, String> placeholders = new HashMap<String, String>();

    public Map<String, String> getPlaceholders() {
        return this.placeholders;
    }

    public void populate(Database database) {
        Schema schema = this.getDefaultSchema(database);
        String catalog = this.getCatalog(database);
        String currentUser = this.getUser(database);
        if (schema != null) {
            this.placeholders.put(DEFAULT_SCHEMA_PLACEHOLDER, schema.getName());
        }
        if (catalog != null) {
            this.placeholders.put(DATABASE_PLACEHOLDER, catalog);
        }
        this.placeholders.put(USER_PLACEHOLDER, currentUser);
    }

    private String getCatalog(Database database) {
        try {
            return ((Connection)database.getMainConnection()).getJdbcConnection().getCatalog();
        }
        catch (SQLException e) {
            LOG.debug("Could not get database name for flyway:database placeholder.");
            return null;
        }
    }

    private Schema getDefaultSchema(Database database) {
        try {
            return ((Connection)database.getMainConnection()).getCurrentSchema();
        }
        catch (FlywayException e) {
            LOG.debug("Could not get schema for flyway:defaultSchema placeholder.");
            return null;
        }
    }

    private String getUser(Database database) {
        try {
            return database.getCurrentUser();
        }
        catch (FlywayException e) {
            LOG.debug("Could not get user for flyway:user placeholder.");
            return null;
        }
    }
}

