/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.database.postgresql;

import java.sql.SQLException;
import java.util.List;
import java.util.concurrent.Callable;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.internal.exception.FlywaySqlException;
import org.flywaydb.core.internal.jdbc.JdbcTemplate;
import org.flywaydb.core.internal.strategy.RetryStrategy;

public class PostgreSQLAdvisoryLockTemplate {
    private static final Log LOG = LogFactory.getLog(PostgreSQLAdvisoryLockTemplate.class);
    private static final long LOCK_MAGIC_NUM = 77431708279161L;
    private final JdbcTemplate jdbcTemplate;
    private final long lockNum;

    PostgreSQLAdvisoryLockTemplate(JdbcTemplate jdbcTemplate, int discriminator) {
        this.jdbcTemplate = jdbcTemplate;
        this.lockNum = 77431708279161L + (long)discriminator;
    }

    public <T> T execute(Callable<T> callable) {
        RuntimeException rethrow = null;
        try {
            this.lock();
            T t = callable.call();
            return t;
        }
        catch (SQLException e) {
            throw new FlywaySqlException("Unable to acquire PostgreSQL advisory lock", e);
        }
        catch (Exception e) {
            rethrow = e instanceof RuntimeException ? (RuntimeException)e : new FlywayException(e);
            throw rethrow;
        }
        finally {
            this.unlock(rethrow);
        }
    }

    private void lock() throws SQLException {
        RetryStrategy strategy = new RetryStrategy();
        strategy.doWithRetries(this::tryLock, "Interrupted while attempting to acquire PostgreSQL advisory lock", "Number of retries exceeded while attempting to acquire PostgreSQL advisory lock. Configure the number of retries with the 'lockRetryCount' configuration option: https://flywaydb.org/documentation/configuration/parameters/lockRetryCount");
    }

    private boolean tryLock() throws SQLException {
        List<Boolean> results = this.jdbcTemplate.query("SELECT pg_try_advisory_lock(" + this.lockNum + ")", rs -> rs.getBoolean("pg_try_advisory_lock"), new Object[0]);
        return results.size() == 1 && results.get(0) != false;
    }

    private void unlock(RuntimeException rethrow) throws FlywaySqlException {
        try {
            boolean unlocked = this.jdbcTemplate.queryForBoolean("SELECT pg_advisory_unlock(" + this.lockNum + ")", new String[0]);
            if (!unlocked) {
                if (rethrow == null) {
                    throw new FlywayException("Unable to release PostgreSQL advisory lock");
                }
                LOG.error("Unable to release PostgreSQL advisory lock");
            }
        }
        catch (SQLException e) {
            if (rethrow == null) {
                throw new FlywaySqlException("Unable to release PostgreSQL advisory lock", e);
            }
            LOG.error("Unable to release PostgreSQL advisory lock", e);
        }
    }
}

