/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.plugin;

import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.extensibility.Plugin;

public class PluginRegister {
    private static final Log LOG = LogFactory.getLog(PluginRegister.class);
    private static final ClassLoader CLASS_LOADER = new PluginRegister().getClass().getClassLoader();
    public static final List<Plugin> REGISTERED_PLUGINS = new ArrayList<Plugin>();
    private static boolean hasRegisteredPlugins = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerPlugins() {
        List<Plugin> list = REGISTERED_PLUGINS;
        synchronized (list) {
            if (hasRegisteredPlugins) {
                return;
            }
            for (Plugin plugin : ServiceLoader.load(Plugin.class, CLASS_LOADER)) {
                REGISTERED_PLUGINS.add(plugin);
            }
            hasRegisteredPlugins = true;
        }
    }

    private static List<Plugin> getPlugins() {
        if (!hasRegisteredPlugins) {
            PluginRegister.registerPlugins();
        }
        return REGISTERED_PLUGINS;
    }

    public static <T extends Plugin> List<T> getPlugins(Class<T> clazz) {
        return PluginRegister.getPlugins().stream().filter(clazz::isInstance).collect(Collectors.toList());
    }

    public static <T extends Plugin> T getPlugin(Class<T> clazz) {
        return (T)((Plugin)PluginRegister.getPlugins().stream().filter(p -> p.getClass().getCanonicalName().equals(clazz.getCanonicalName())).findFirst().orElse(null));
    }

    private PluginRegister() {
    }
}

