/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileWriter;
import org.flywaydb.core.api.FlywayException;

public class JsonUtils {
    public static String jsonToFile(String folder, String filename, String json) {
        return JsonUtils.jsonToFile(folder, filename, JsonParser.parseString((String)json).getAsJsonObject());
    }

    public static String jsonToFile(String folder, String filename, Object json) {
        String string;
        Gson gson = new GsonBuilder().serializeNulls().setPrettyPrinting().create();
        String fullFilename = folder + File.separator + filename + ".json";
        FileWriter fileWriter = new FileWriter(fullFilename);
        try {
            gson.toJson(json, (Appendable)fileWriter);
            string = fullFilename;
        }
        catch (Throwable throwable) {
            try {
                try {
                    fileWriter.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new FlywayException("Unable to write JSON to file: " + e.getMessage());
            }
        }
        fileWriter.close();
        return string;
    }

    public static Object parseJsonArray(String json) {
        return JsonParser.parseString((String)json).getAsJsonArray();
    }

    private JsonUtils() {
    }
}

