/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.database.cockroachdb;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.flywaydb.core.internal.database.base.Schema;
import org.flywaydb.core.internal.database.base.Table;
import org.flywaydb.core.internal.database.cockroachdb.CockroachDBDatabase;
import org.flywaydb.core.internal.database.cockroachdb.CockroachDBRetryingStrategy;
import org.flywaydb.core.internal.database.cockroachdb.CockroachDBTable;
import org.flywaydb.core.internal.jdbc.JdbcTemplate;

public class CockroachDBSchema
extends Schema<CockroachDBDatabase, CockroachDBTable> {
    final boolean cockroachDB1;
    final boolean hasSchemaSupport;

    public CockroachDBSchema(JdbcTemplate jdbcTemplate, CockroachDBDatabase database, String name) {
        super(jdbcTemplate, database, name);
        this.cockroachDB1 = !database.getVersion().isAtLeast("2");
        this.hasSchemaSupport = database.supportsSchemas();
    }

    @Override
    protected boolean doExists() throws SQLException {
        return new CockroachDBRetryingStrategy().execute(this::doExistsOnce);
    }

    private boolean doExistsOnce() throws SQLException {
        if (this.hasSchemaSupport) {
            return this.jdbcTemplate.queryForBoolean("SELECT EXISTS ( SELECT 1 FROM information_schema.schemata WHERE schema_name=? )", this.name);
        }
        return this.jdbcTemplate.queryForBoolean("SELECT EXISTS ( SELECT 1 FROM pg_database WHERE datname=? )", this.name);
    }

    @Override
    protected boolean doEmpty() throws SQLException {
        return new CockroachDBRetryingStrategy().execute(this::doEmptyOnce);
    }

    private boolean doEmptyOnce() throws SQLException {
        if (this.cockroachDB1) {
            return !this.jdbcTemplate.queryForBoolean("SELECT EXISTS (  SELECT 1  FROM information_schema.tables  WHERE table_schema=?  AND table_type='BASE TABLE')", this.name);
        }
        if (!this.hasSchemaSupport) {
            return !this.jdbcTemplate.queryForBoolean("SELECT EXISTS (  SELECT 1  FROM information_schema.tables   WHERE table_catalog=?  AND table_schema='public'  AND table_type='BASE TABLE' UNION ALL  SELECT 1  FROM information_schema.sequences   WHERE sequence_catalog=?  AND sequence_schema='public')", this.name, this.name);
        }
        return !this.jdbcTemplate.queryForBoolean("SELECT EXISTS (  SELECT 1  FROM information_schema.tables   WHERE table_schema=?  AND table_type='BASE TABLE' UNION ALL  SELECT 1  FROM information_schema.sequences   WHERE sequence_schema=?)", this.name, this.name);
    }

    @Override
    protected void doCreate() throws SQLException {
        new CockroachDBRetryingStrategy().execute(() -> {
            this.doCreateOnce();
            return null;
        });
    }

    protected void doCreateOnce() throws SQLException {
        if (this.hasSchemaSupport) {
            this.jdbcTemplate.execute("CREATE SCHEMA IF NOT EXISTS " + ((CockroachDBDatabase)this.database).quote(this.name), new Object[0]);
        } else {
            this.jdbcTemplate.execute("CREATE DATABASE IF NOT EXISTS " + ((CockroachDBDatabase)this.database).quote(this.name), new Object[0]);
        }
    }

    @Override
    protected void doDrop() throws SQLException {
        new CockroachDBRetryingStrategy().execute(() -> {
            this.doDropOnce();
            return null;
        });
    }

    protected void doDropOnce() throws SQLException {
        if (this.hasSchemaSupport) {
            this.jdbcTemplate.execute("DROP SCHEMA IF EXISTS " + ((CockroachDBDatabase)this.database).quote(this.name) + " CASCADE", new Object[0]);
        } else {
            this.jdbcTemplate.execute("DROP DATABASE IF EXISTS " + ((CockroachDBDatabase)this.database).quote(this.name), new Object[0]);
        }
    }

    @Override
    protected void doClean() throws SQLException {
        new CockroachDBRetryingStrategy().execute(() -> {
            this.doCleanOnce();
            return null;
        });
    }

    protected void doCleanOnce() throws SQLException {
        for (String statement : this.generateDropStatementsForViews()) {
            this.jdbcTemplate.execute(statement, new Object[0]);
        }
        for (CockroachDBTable table : (CockroachDBTable[])this.allTables()) {
            table.drop();
        }
        for (String statement : this.generateDropStatementsForSequences()) {
            this.jdbcTemplate.execute(statement, new Object[0]);
        }
    }

    private List<String> generateDropStatementsForViews() throws SQLException {
        List<String> names = this.hasSchemaSupport ? this.jdbcTemplate.queryForStringList("SELECT table_name FROM information_schema.views WHERE table_schema=?", this.name) : this.jdbcTemplate.queryForStringList("SELECT table_name FROM information_schema.views WHERE table_catalog=? AND table_schema='public'", this.name);
        ArrayList<String> statements = new ArrayList<String>();
        for (String name : names) {
            statements.add("DROP VIEW IF EXISTS " + ((CockroachDBDatabase)this.database).quote(this.name, name) + " CASCADE");
        }
        return statements;
    }

    private List<String> generateDropStatementsForSequences() throws SQLException {
        List<String> names = this.hasSchemaSupport ? this.jdbcTemplate.queryForStringList("SELECT sequence_name FROM information_schema.sequences WHERE sequence_schema=?", this.name) : this.jdbcTemplate.queryForStringList("SELECT sequence_name FROM information_schema.sequences WHERE sequence_catalog=? AND sequence_schema='public'", this.name);
        ArrayList<String> statements = new ArrayList<String>();
        for (String name : names) {
            statements.add("DROP SEQUENCE IF EXISTS " + ((CockroachDBDatabase)this.database).quote(this.name, name) + " CASCADE");
        }
        return statements;
    }

    protected CockroachDBTable[] doAllTables() throws SQLException {
        String query = this.cockroachDB1 || this.hasSchemaSupport ? "SELECT table_name FROM information_schema.tables WHERE table_schema=? AND table_type='BASE TABLE'" : "SELECT table_name FROM information_schema.tables WHERE table_catalog=? AND table_schema='public' AND table_type='BASE TABLE'";
        List<String> tableNames = this.jdbcTemplate.queryForStringList(query, this.name);
        CockroachDBTable[] tables = new CockroachDBTable[tableNames.size()];
        for (int i = 0; i < tableNames.size(); ++i) {
            tables[i] = new CockroachDBTable(this.jdbcTemplate, (CockroachDBDatabase)this.database, this, tableNames.get(i));
        }
        return tables;
    }

    @Override
    public Table getTable(String tableName) {
        return new CockroachDBTable(this.jdbcTemplate, (CockroachDBDatabase)this.database, this, tableName);
    }
}

