/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.esc.api;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.fuin.esc.api.CommonEvent;
import org.fuin.objects4j.common.Immutable;
import org.fuin.objects4j.common.Nullable;

@Immutable
public final class StreamEventsSlice {
    private final long fromEventNumber;
    private final long nextEventNumber;
    private final boolean endOfStream;
    private final List<CommonEvent> events;

    public StreamEventsSlice(long fromEventNumber, @Nullable List<CommonEvent> events, long nextEventNumber, boolean endOfStream) {
        this.fromEventNumber = fromEventNumber;
        this.events = events == null || events.size() == 0 ? new ArrayList<CommonEvent>() : new ArrayList<CommonEvent>(events);
        this.nextEventNumber = nextEventNumber;
        this.endOfStream = endOfStream;
    }

    public long getFromEventNumber() {
        return this.fromEventNumber;
    }

    @NotNull
    public List<CommonEvent> getEvents() {
        return Collections.unmodifiableList(this.events);
    }

    public long getNextEventNumber() {
        return this.nextEventNumber;
    }

    public boolean isEndOfStream() {
        return this.endOfStream;
    }

    public final int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.endOfStream ? 1231 : 1237);
        result = 31 * result + (int)(this.fromEventNumber ^ this.fromEventNumber >>> 32);
        result = 31 * result + (int)(this.nextEventNumber ^ this.nextEventNumber >>> 32);
        result = 31 * result + (this.events == null ? 0 : Arrays.hashCode(this.events.toArray()));
        return result;
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StreamEventsSlice)) {
            return false;
        }
        StreamEventsSlice other = (StreamEventsSlice)obj;
        if (this.endOfStream != other.endOfStream) {
            return false;
        }
        if (this.fromEventNumber != other.fromEventNumber) {
            return false;
        }
        if (this.nextEventNumber != other.nextEventNumber) {
            return false;
        }
        if (this.events == null) {
            if (other.events != null) {
                return false;
            }
        } else {
            if (other.events == null) {
                return false;
            }
            if (!Arrays.equals(this.events.toArray(), other.events.toArray())) {
                return false;
            }
        }
        return true;
    }

    @NotNull
    public final String toDebugString() {
        return new ToStringBuilder((Object)this).append("fromEventNumber", this.fromEventNumber).append("nextEventNumber", this.nextEventNumber).append("endOfStream", this.endOfStream).append("events", this.events).toString();
    }

    public final String toString() {
        return new ToStringBuilder((Object)this).append("fromEventNumber", this.fromEventNumber).append("nextEventNumber", this.nextEventNumber).append("endOfStream", this.endOfStream).append("events.size", this.events.size()).toString();
    }
}

