/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.objects4j.ui;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.validation.constraints.NotNull;
import org.fuin.objects4j.common.Contract;
import org.fuin.objects4j.common.Immutable;
import org.fuin.objects4j.common.Nullable;
import org.fuin.objects4j.ui.AnnotationAnalyzer;
import org.fuin.objects4j.ui.FieldTextInfo;
import org.fuin.objects4j.ui.FontSize;
import org.fuin.objects4j.ui.Label;
import org.fuin.objects4j.ui.ShortLabel;
import org.fuin.objects4j.ui.TableColumn;
import org.fuin.objects4j.ui.Tooltip;

@Immutable
public final class TableColumnInfo
implements Comparable<TableColumnInfo> {
    private final Field field;
    private final String text;
    private final String shortText;
    private final String tooltip;
    private final FontSize width;
    private final int pos;
    private final String getter;

    public TableColumnInfo(@NotNull Field field, String text, String shortText, int pos, @NotNull FontSize width, @NotNull String getter) {
        this(field, text, shortText, null, pos, width, getter);
    }

    public TableColumnInfo(@NotNull Field field, @Nullable String text, @Nullable String shortText, @Nullable String tooltip, int pos, @NotNull FontSize width, @NotNull String getter) {
        Contract.requireArgNotNull("field", field);
        Contract.requireArgNotNull("width", width);
        Contract.requireArgNotNull("getter", getter);
        this.field = field;
        this.text = text;
        this.shortText = shortText;
        this.tooltip = tooltip;
        this.pos = pos;
        this.width = width;
        this.getter = getter;
    }

    public final Field getField() {
        return this.field;
    }

    public final String getText() {
        return this.text;
    }

    public final String getShortText() {
        return this.shortText;
    }

    public final String getTooltip() {
        return this.tooltip;
    }

    public final FontSize getWidth() {
        return this.width;
    }

    public final int getPos() {
        return this.pos;
    }

    public final String getGetter() {
        return this.getter;
    }

    @Override
    public final int compareTo(TableColumnInfo theOther) {
        if (this.pos > theOther.pos) {
            return 1;
        }
        if (this.pos < theOther.pos) {
            return -1;
        }
        return 0;
    }

    public final int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.field.hashCode();
        return result;
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TableColumnInfo other = (TableColumnInfo)obj;
        return this.field.equals(other.field);
    }

    public static List<TableColumnInfo> create(@NotNull Class<?> clasz, @NotNull Locale locale) {
        Contract.requireArgNotNull("clasz", clasz);
        Contract.requireArgNotNull("locale", locale);
        ArrayList<TableColumnInfo> list = new ArrayList<TableColumnInfo>();
        Field[] fields = clasz.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            TableColumnInfo tableColumnInfo = TableColumnInfo.create(fields[i], locale);
            if (tableColumnInfo == null) continue;
            list.add(tableColumnInfo);
        }
        Collections.sort(list);
        return list;
    }

    public static TableColumnInfo create(@NotNull Field field, @NotNull Locale locale) {
        Contract.requireArgNotNull("field", field);
        Contract.requireArgNotNull("locale", locale);
        TableColumn tableColumn = field.getAnnotation(TableColumn.class);
        if (tableColumn == null) {
            return null;
        }
        AnnotationAnalyzer analyzer = new AnnotationAnalyzer();
        FieldTextInfo labelInfo = analyzer.createFieldInfo(field, locale, Label.class);
        FieldTextInfo shortLabelInfo = analyzer.createFieldInfo(field, locale, ShortLabel.class);
        FieldTextInfo tooltipInfo = analyzer.createFieldInfo(field, locale, Tooltip.class);
        int pos = tableColumn.pos();
        FontSize fontSize = new FontSize(tableColumn.width(), tableColumn.unit());
        String getter = TableColumnInfo.getGetter(tableColumn, field.getName());
        String labelText = labelInfo == null ? null : labelInfo.getTextOrField();
        String shortLabelText = shortLabelInfo == null ? null : shortLabelInfo.getText();
        String tooltipText = tooltipInfo == null ? null : tooltipInfo.getText();
        return new TableColumnInfo(field, labelText, shortLabelText, tooltipText, pos, fontSize, getter);
    }

    private static String getGetter(TableColumn tableColumn, String fieldName) {
        if (tableColumn.getter().equals("")) {
            return "get" + TableColumnInfo.firstCharUpper(fieldName);
        }
        return tableColumn.getter();
    }

    private static String firstCharUpper(String str) {
        if (str == null) {
            return null;
        }
        if (str.length() == 0) {
            return str;
        }
        if (str.length() == 1) {
            return "" + Character.toUpperCase(str.charAt(0));
        }
        return Character.toUpperCase(str.charAt(0)) + str.substring(1);
    }
}

