/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.objects4j.vo;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Currency;
import javax.validation.constraints.NotNull;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.fuin.objects4j.common.Contract;
import org.fuin.objects4j.common.Immutable;
import org.fuin.objects4j.ui.Label;
import org.fuin.objects4j.ui.ShortLabel;
import org.fuin.objects4j.vo.CurrencyAmountConverter;
import org.fuin.objects4j.vo.CurrencyAmountStr;
import org.fuin.objects4j.vo.ValueObjectWithBaseType;

@ShortLabel(value="Amount")
@Label(value="Amount of currency")
@XmlJavaTypeAdapter(value=CurrencyAmountConverter.class)
@Immutable
public final class CurrencyAmount
implements ValueObjectWithBaseType<String>,
Comparable<CurrencyAmount>,
Serializable {
    private static final long serialVersionUID = 1000L;
    @NotNull
    private BigDecimal amount;
    @NotNull
    private Currency currency;
    private transient String stringCache;

    protected CurrencyAmount() {
    }

    public CurrencyAmount(@NotNull BigDecimal amount, @NotNull Currency currency) {
        Contract.requireArgNotNull("amount", amount);
        Contract.requireArgNotNull("currency", currency);
        this.amount = amount;
        this.currency = currency;
    }

    public CurrencyAmount(@NotNull String amount, @NotNull Currency currency) {
        this(CurrencyAmount.strToAmount(amount), currency);
    }

    public CurrencyAmount(@NotNull String amount, @NotNull String currencyCode) {
        this(CurrencyAmount.strToAmount(amount), Currency.getInstance(currencyCode));
    }

    public final int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.amount.hashCode();
        result = 31 * result + this.currency.hashCode();
        return result;
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CurrencyAmount other = (CurrencyAmount)obj;
        if (!this.amount.equals(other.amount)) {
            return false;
        }
        return this.currency.getCurrencyCode().equals(other.currency.getCurrencyCode());
    }

    @Override
    public final int compareTo(CurrencyAmount other) {
        String otherCode;
        String thisCode = this.currency.getCurrencyCode();
        int c = thisCode.compareTo(otherCode = other.currency.getCurrencyCode());
        if (c > 0) {
            return c;
        }
        if (c < 0) {
            return c;
        }
        c = this.amount.compareTo(other.amount);
        if (c > 0) {
            return c;
        }
        if (c < 0) {
            return c;
        }
        return 0;
    }

    @NotNull
    public final BigDecimal getAmount() {
        return this.amount;
    }

    @NotNull
    public final Currency getCurrency() {
        return this.currency;
    }

    @Override
    public final Class<String> getBaseType() {
        return String.class;
    }

    @Override
    public final String asBaseType() {
        if (this.stringCache == null) {
            this.stringCache = CurrencyAmount.amountToStr(this.amount) + " " + this.currency.getCurrencyCode();
        }
        return this.stringCache;
    }

    public final String toString() {
        return this.asBaseType();
    }

    public static String amountToStr(BigDecimal amount) {
        if (amount == null) {
            return null;
        }
        BigInteger unscaled = amount.unscaledValue();
        if (unscaled.equals(BigInteger.ZERO)) {
            return "0." + CurrencyAmount.repeat(amount.scale(), '0');
        }
        String unscaledStr = unscaled.toString();
        if (amount.scale() == 0) {
            return unscaledStr;
        }
        int p = unscaledStr.length() - amount.scale();
        if (p == 0) {
            return "0." + unscaledStr;
        }
        return unscaledStr.substring(0, p) + "." + unscaledStr.substring(p);
    }

    public static BigDecimal strToAmount(@CurrencyAmountStr String amount) {
        Object unscaledStr;
        int scale;
        if (amount == null) {
            return null;
        }
        int dot = amount.indexOf(46);
        if (dot == -1) {
            scale = 0;
            unscaledStr = amount;
        } else {
            scale = amount.length() - dot - 1;
            unscaledStr = amount.substring(0, dot) + amount.substring(dot + 1);
        }
        BigInteger unscaled = new BigInteger((String)unscaledStr);
        return new BigDecimal(unscaled, scale);
    }

    private static String repeat(int count, char ch) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < count; ++i) {
            sb.append(ch);
        }
        return sb.toString();
    }
}

