/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.objects4j.vo;

import java.io.Serializable;
import java.time.DayOfWeek;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.fuin.objects4j.common.ConstraintViolationException;
import org.fuin.objects4j.common.Contract;
import org.fuin.objects4j.common.Immutable;
import org.fuin.objects4j.common.Nullable;
import org.fuin.objects4j.ui.Label;
import org.fuin.objects4j.ui.Prompt;
import org.fuin.objects4j.ui.ShortLabel;
import org.fuin.objects4j.ui.Tooltip;
import org.fuin.objects4j.vo.AsStringCapable;
import org.fuin.objects4j.vo.DayOfTheWeekConverter;
import org.fuin.objects4j.vo.DayOfTheWeekStr;
import org.fuin.objects4j.vo.ValueObjectWithBaseType;

@ShortLabel(value="DOW")
@Label(value="Days of the week")
@Tooltip(value="The days of the week 'Mon'-'Sun'(from Monday to Sunday) plus 'PH' (Public Holiday)")
@Prompt(value="Fri")
@XmlJavaTypeAdapter(value=DayOfTheWeekConverter.class)
@Immutable
public final class DayOfTheWeek
implements ValueObjectWithBaseType<String>,
Comparable<DayOfTheWeek>,
Serializable,
AsStringCapable {
    private static final long serialVersionUID = 1000L;
    public static final DayOfTheWeek MON = new DayOfTheWeek(1, "MON");
    public static final DayOfTheWeek TUE = new DayOfTheWeek(2, "TUE");
    public static final DayOfTheWeek WED = new DayOfTheWeek(3, "WED");
    public static final DayOfTheWeek THU = new DayOfTheWeek(4, "THU");
    public static final DayOfTheWeek FRI = new DayOfTheWeek(5, "FRI");
    public static final DayOfTheWeek SAT = new DayOfTheWeek(6, "SAT");
    public static final DayOfTheWeek SUN = new DayOfTheWeek(7, "SUN");
    public static final DayOfTheWeek PH = new DayOfTheWeek(8, "PH");
    private static final DayOfTheWeek[] ALL = new DayOfTheWeek[]{MON, TUE, WED, THU, FRI, SAT, SUN, PH};
    private final int id;
    private final String value;

    private DayOfTheWeek(int id, @NotNull @DayOfTheWeekStr String dayOfTheWeek) {
        this.id = id;
        this.value = dayOfTheWeek.toUpperCase();
    }

    @Override
    @NotEmpty
    public String asBaseType() {
        return this.value;
    }

    public boolean follows(@NotNull DayOfTheWeek other) {
        Contract.requireArgNotNull("other", other);
        if (this == PH || other == PH) {
            return false;
        }
        return this.id == other.id + 1;
    }

    public boolean after(@NotNull DayOfTheWeek other) {
        Contract.requireArgNotNull("other", other);
        return this.id > other.id;
    }

    public DayOfTheWeek next() {
        if (this == PH) {
            return null;
        }
        int nextId = this.id + 1;
        if (nextId == DayOfTheWeek.PH.id) {
            return MON;
        }
        for (DayOfTheWeek dow : ALL) {
            if (dow.id != nextId) continue;
            return dow;
        }
        throw new IllegalStateException("Wasn't able to find next day for: " + this);
    }

    public DayOfTheWeek previous() {
        if (this == PH) {
            return null;
        }
        int nextId = this.id - 1;
        for (DayOfTheWeek dow : ALL) {
            if (dow.id != nextId) continue;
            return dow;
        }
        return SUN;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.id;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DayOfTheWeek other = (DayOfTheWeek)obj;
        return this.id == other.id;
    }

    public final int length() {
        return this.asBaseType().length();
    }

    @Override
    public int compareTo(DayOfTheWeek other) {
        if (this.id > other.id) {
            return 1;
        }
        if (this.id < other.id) {
            return -1;
        }
        return 0;
    }

    @Override
    public final Class<String> getBaseType() {
        return String.class;
    }

    @Override
    public final String asString() {
        return this.asBaseType();
    }

    public final DayOfWeek toDayOfWeek() {
        if (this == PH) {
            throw new UnsupportedOperationException("Cannot convert public holiday into java time instance");
        }
        return DayOfWeek.of(this.id);
    }

    public String toString() {
        return this.value;
    }

    public static boolean isValid(@Nullable String dayOfTheWeek) {
        if (dayOfTheWeek == null) {
            return true;
        }
        for (DayOfTheWeek dow : ALL) {
            if (!dow.value.equalsIgnoreCase(dayOfTheWeek)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static DayOfTheWeek valueOf(@Nullable String str) {
        if (str == null) {
            return null;
        }
        for (DayOfTheWeek dow : ALL) {
            if (!dow.value.equalsIgnoreCase(str)) continue;
            return dow;
        }
        throw new IllegalArgumentException("Unknown day of week: '" + str + "'");
    }

    @Nullable
    public static DayOfTheWeek valueOf(@Nullable DayOfWeek dayOfWeek) {
        if (dayOfWeek == null) {
            return null;
        }
        int value = dayOfWeek.getValue();
        for (DayOfTheWeek dow : ALL) {
            if (value != dow.id) continue;
            return dow;
        }
        throw new IllegalArgumentException("Unknown day week: " + dayOfWeek);
    }

    public static void requireArgValid(@NotNull String name, @NotNull String value) throws ConstraintViolationException {
        if (!DayOfTheWeek.isValid(value)) {
            throw new ConstraintViolationException("The argument '" + name + "' does not represent a valid day of the week like 'Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat', 'Sun' or 'PH': '" + value + "'");
        }
    }

    public static List<DayOfTheWeek> getAll() {
        ArrayList<DayOfTheWeek> days = new ArrayList<DayOfTheWeek>();
        for (DayOfTheWeek day : ALL) {
            days.add(day);
        }
        return Collections.unmodifiableList(days);
    }

    public static List<DayOfTheWeek> getPart(@NotNull DayOfTheWeek from, @NotNull DayOfTheWeek to) {
        ArrayList<DayOfTheWeek> days = new ArrayList<DayOfTheWeek>();
        for (DayOfTheWeek day : ALL) {
            if (day.id < from.id || day.id > to.id) continue;
            days.add(day);
        }
        return Collections.unmodifiableList(days);
    }
}

