/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.objects4j.vo;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.fuin.objects4j.common.ConstraintViolationException;
import org.fuin.objects4j.common.Contract;
import org.fuin.objects4j.common.Immutable;
import org.fuin.objects4j.common.Nullable;
import org.fuin.objects4j.ui.Prompt;
import org.fuin.objects4j.vo.AsStringCapable;
import org.fuin.objects4j.vo.DayOfTheWeek;
import org.fuin.objects4j.vo.DayOpeningHoursConverter;
import org.fuin.objects4j.vo.DayOpeningHoursStr;
import org.fuin.objects4j.vo.HourRange;
import org.fuin.objects4j.vo.HourRanges;
import org.fuin.objects4j.vo.ValueObjectWithBaseType;

@Prompt(value="Mon 09:00-12:00+13:00-17:00")
@XmlJavaTypeAdapter(value=DayOpeningHoursConverter.class)
@Immutable
public final class DayOpeningHours
implements ValueObjectWithBaseType<String>,
Comparable<DayOpeningHours>,
Serializable,
AsStringCapable {
    private static final long serialVersionUID = 1000L;
    @NotNull
    private DayOfTheWeek dayOfTheWeek;
    @NotNull
    private HourRanges hourRanges;

    protected DayOpeningHours() {
    }

    public DayOpeningHours(@NotNull @DayOpeningHoursStr String dayOpeningHours) {
        Contract.requireArgNotEmpty("dayOpeningHours", dayOpeningHours);
        DayOpeningHours.requireArgValid("dayOpeningHours", dayOpeningHours);
        int p = dayOpeningHours.indexOf(32);
        this.dayOfTheWeek = DayOfTheWeek.valueOf(dayOpeningHours.substring(0, p));
        this.hourRanges = new HourRanges(dayOpeningHours.substring(p + 1));
    }

    public DayOpeningHours(@NotNull DayOfTheWeek dayOfTheWeek, @NotNull HourRanges hourRanges) {
        Contract.requireArgNotNull("dayOfTheWeek", dayOfTheWeek);
        Contract.requireArgNotNull("hourRanges", hourRanges);
        this.dayOfTheWeek = dayOfTheWeek;
        this.hourRanges = hourRanges;
    }

    @Override
    public final int compareTo(DayOpeningHours other) {
        return this.dayOfTheWeek.compareTo(other.dayOfTheWeek);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.dayOfTheWeek == null ? 0 : this.dayOfTheWeek.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DayOpeningHours other = (DayOpeningHours)obj;
        return !(this.dayOfTheWeek == null ? other.dayOfTheWeek != null : !this.dayOfTheWeek.equals(other.dayOfTheWeek));
    }

    @Override
    @NotEmpty
    public String asBaseType() {
        return this.dayOfTheWeek + " " + this.hourRanges;
    }

    @Override
    public final Class<String> getBaseType() {
        return String.class;
    }

    @Override
    public final String asString() {
        return this.asBaseType();
    }

    public final String toString() {
        return this.asBaseType();
    }

    public final DayOfTheWeek getDayOfTheWeek() {
        return this.dayOfTheWeek;
    }

    public final HourRanges getHourRanges() {
        return this.hourRanges;
    }

    public final List<DayOpeningHours> normalize() {
        List<HourRanges> ranges = this.hourRanges.normalize();
        ArrayList<DayOpeningHours> list = new ArrayList<DayOpeningHours>();
        list.add(new DayOpeningHours(this.dayOfTheWeek, ranges.get(0)));
        if (ranges.size() > 1) {
            list.add(new DayOpeningHours(this.dayOfTheWeek.next(), ranges.get(1)));
        }
        return list;
    }

    public boolean isNormalized() {
        return this.hourRanges.isNormalized();
    }

    public final List<Change> diff(DayOpeningHours toOther) {
        Contract.requireArgNotNull("toOther", toOther);
        if (this.dayOfTheWeek != toOther.dayOfTheWeek) {
            throw new ConstraintViolationException("Expected same day (" + this.dayOfTheWeek + ") for argument 'toOther', but was: " + toOther.dayOfTheWeek);
        }
        List<DayOpeningHours> fromDays = this.normalize();
        List<DayOpeningHours> toDays = toOther.normalize();
        ArrayList<Change> changes = new ArrayList<Change>();
        if (fromDays.size() == 1) {
            if (toDays.size() == 1) {
                DayOpeningHours from = fromDays.get(0);
                DayOpeningHours to = toDays.get(0);
                changes.addAll(DayOpeningHours.changes(this.dayOfTheWeek, from.hourRanges, to.hourRanges));
            } else {
                DayOpeningHours from = fromDays.get(0);
                DayOpeningHours to1 = toDays.get(0);
                DayOpeningHours to2 = toDays.get(1);
                changes.addAll(DayOpeningHours.changes(this.dayOfTheWeek, from.hourRanges, to1.hourRanges));
                changes.addAll(DayOpeningHours.changes(HourRanges.ChangeType.ADDED, to2.dayOfTheWeek, to2.hourRanges));
            }
        } else if (toDays.size() == 1) {
            DayOpeningHours from1 = fromDays.get(0);
            DayOpeningHours from2 = fromDays.get(1);
            DayOpeningHours to = toDays.get(0);
            changes.addAll(DayOpeningHours.changes(this.dayOfTheWeek, from1.hourRanges, to.hourRanges));
            changes.addAll(DayOpeningHours.changes(HourRanges.ChangeType.REMOVED, from2.dayOfTheWeek, from2.hourRanges));
        } else {
            DayOpeningHours from1 = fromDays.get(0);
            DayOpeningHours from2 = fromDays.get(1);
            DayOpeningHours to1 = toDays.get(0);
            DayOpeningHours to2 = toDays.get(1);
            changes.addAll(DayOpeningHours.changes(from1.dayOfTheWeek, from1.hourRanges, to1.hourRanges));
            changes.addAll(DayOpeningHours.changes(from2.dayOfTheWeek, from2.hourRanges, to2.hourRanges));
        }
        return changes;
    }

    public final boolean overlaps(@NotNull DayOpeningHours other) {
        Contract.requireArgNotNull("other", other);
        return this.hourRanges.overlaps(other.hourRanges);
    }

    @NotNull
    public final DayOpeningHours add(@NotNull HourRanges other) {
        Contract.requireArgNotNull("other", other);
        HourRanges added = this.hourRanges.add(other);
        return new DayOpeningHours(this.dayOfTheWeek, added);
    }

    @NotNull
    public final DayOpeningHours add(@NotNull DayOpeningHours other) {
        Contract.requireArgNotNull("other", other);
        return this.add(other.hourRanges);
    }

    @Nullable
    public final DayOpeningHours remove(@NotNull HourRanges other) {
        Contract.requireArgNotNull("other", other);
        HourRanges removed = this.hourRanges.remove(other);
        if (removed == null) {
            return null;
        }
        return new DayOpeningHours(this.dayOfTheWeek, removed);
    }

    @Nullable
    public final DayOpeningHours remove(@NotNull DayOpeningHours other) {
        Contract.requireArgNotNull("other", other);
        return this.remove(other.hourRanges);
    }

    public List<Change> asRemovedChanges() {
        ArrayList<Change> changes = new ArrayList<Change>();
        for (HourRange hr : this.hourRanges) {
            changes.add(new Change(HourRanges.ChangeType.REMOVED, this.dayOfTheWeek, hr));
        }
        return changes;
    }

    public List<Change> asAddedChanges() {
        ArrayList<Change> changes = new ArrayList<Change>();
        for (HourRange hr : this.hourRanges) {
            changes.add(new Change(HourRanges.ChangeType.ADDED, this.dayOfTheWeek, hr));
        }
        return changes;
    }

    public boolean openAt(@NotNull HourRange range) {
        Contract.requireArgNotNull("range", range);
        return this.hourRanges.openAt(range);
    }

    public boolean openAt(@NotNull DayOpeningHours other) {
        Contract.requireArgNotNull("other", other);
        if (this.dayOfTheWeek != other.dayOfTheWeek) {
            return false;
        }
        for (HourRange otherRange : other.hourRanges) {
            if (this.hourRanges.openAt(otherRange)) continue;
            return false;
        }
        return true;
    }

    private static List<Change> changes(HourRanges.ChangeType type, DayOfTheWeek dayOfTheWeek, HourRanges ranges) {
        ArrayList<Change> changes = new ArrayList<Change>();
        for (HourRange hr : ranges) {
            changes.add(new Change(type, dayOfTheWeek, hr));
        }
        return changes;
    }

    private static List<Change> changes(DayOfTheWeek dayOfTheWeek, HourRanges from, HourRanges to) {
        ArrayList<Change> changes = new ArrayList<Change>();
        List<HourRanges.Change> diff = from.diff(to);
        for (HourRanges.Change change : diff) {
            changes.add(new Change(dayOfTheWeek, change));
        }
        return changes;
    }

    public static boolean isValid(@Nullable String dayOpeningHours) {
        if (dayOpeningHours == null) {
            return true;
        }
        int p = dayOpeningHours.indexOf(32);
        if (p < 0) {
            return false;
        }
        String dayOfTheWeekStr = dayOpeningHours.substring(0, p);
        String hourRangesStr = dayOpeningHours.substring(p + 1);
        return DayOfTheWeek.isValid(dayOfTheWeekStr) && HourRanges.isValid(hourRangesStr);
    }

    @Nullable
    public static DayOpeningHours valueOf(@Nullable String str) {
        if (str == null) {
            return null;
        }
        return new DayOpeningHours(str);
    }

    public static void requireArgValid(@NotNull String name, @NotNull String value) throws ConstraintViolationException {
        if (!DayOpeningHours.isValid(value)) {
            throw new ConstraintViolationException("The argument '" + name + "' does not represent a valid hour range like 'Mon 09:00-12:00+13:00-17:00': '" + value + "'");
        }
    }

    public static final class Change {
        private final HourRanges.ChangeType type;
        private final DayOfTheWeek day;
        private final HourRange range;

        public Change(@NotNull DayOfTheWeek day, @NotNull HourRanges.Change change) {
            Contract.requireArgNotNull("day", day);
            Contract.requireArgNotNull("change", change);
            this.day = day;
            this.type = change.getType();
            this.range = change.getRange();
        }

        public Change(@NotNull HourRanges.ChangeType type, @NotNull DayOfTheWeek day, @NotNull HourRange range) {
            Contract.requireArgNotNull("type", (Object)type);
            Contract.requireArgNotNull("day", day);
            Contract.requireArgNotNull("range", range);
            this.type = type;
            this.day = day;
            this.range = range;
        }

        public final DayOfTheWeek getDay() {
            return this.day;
        }

        public final HourRanges.ChangeType getType() {
            return this.type;
        }

        public final HourRange getRange() {
            return this.range;
        }

        public final int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.day == null ? 0 : this.day.hashCode());
            result = 31 * result + (this.range == null ? 0 : this.range.hashCode());
            result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
            return result;
        }

        public final boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Change other = (Change)obj;
            if (this.day == null ? other.day != null : !this.day.equals(other.day)) {
                return false;
            }
            if (this.range == null ? other.range != null : !this.range.equals(other.range)) {
                return false;
            }
            return this.type == other.type;
        }

        public String toString() {
            return this.type + " " + this.day + " " + this.range;
        }
    }
}

