/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.objects4j.vo;

import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.validation.constraints.NotNull;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.fuin.objects4j.common.ConstraintViolationException;
import org.fuin.objects4j.common.Contract;
import org.fuin.objects4j.common.Immutable;
import org.fuin.objects4j.ui.Label;
import org.fuin.objects4j.ui.ShortLabel;
import org.fuin.objects4j.ui.Tooltip;
import org.fuin.objects4j.vo.AbstractStringValueObject;
import org.fuin.objects4j.vo.EmailAddressConverter;
import org.fuin.objects4j.vo.EmailAddressStr;

@ShortLabel(value="Email")
@Label(value="Email address")
@Tooltip(value="Identifies an email box to which email messages are delivered")
@XmlJavaTypeAdapter(value=EmailAddressConverter.class)
@Immutable
public final class EmailAddress
extends AbstractStringValueObject {
    private static final long serialVersionUID = 811127657088134517L;
    @NotNull
    private InternetAddress adr;

    protected EmailAddress() {
    }

    public EmailAddress(@NotNull @EmailAddressStr String emailAddress) {
        Contract.requireArgNotEmpty("emailAddress", emailAddress);
        this.adr = EmailAddress.parseArg("emailAddress", emailAddress);
    }

    @Override
    public final String asBaseType() {
        return this.adr.toString();
    }

    public final String toString() {
        return this.asBaseType();
    }

    private static InternetAddress parseArg(@NotNull String name, @NotNull String value) {
        String trimmedLowerCaseValue = value.trim().toLowerCase();
        try {
            InternetAddress[] addr = InternetAddress.parse((String)trimmedLowerCaseValue, (boolean)false);
            if (addr.length != 1) {
                throw new ConstraintViolationException("The argument 'emailAddress' is not a single address: '" + trimmedLowerCaseValue + "'");
            }
            return addr[0];
        }
        catch (AddressException ex) {
            throw new ConstraintViolationException("The argument 'emailAddress' is not valid: '" + trimmedLowerCaseValue + "'");
        }
    }
}

