/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.objects4j.vo;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.fuin.objects4j.common.ConstraintViolationException;
import org.fuin.objects4j.common.Contract;
import org.fuin.objects4j.common.Immutable;
import org.fuin.objects4j.common.Nullable;
import org.fuin.objects4j.ui.Prompt;
import org.fuin.objects4j.vo.AbstractStringValueObject;
import org.fuin.objects4j.vo.DayOfTheWeek;
import org.fuin.objects4j.vo.DayOpeningHours;
import org.fuin.objects4j.vo.HourRanges;
import org.fuin.objects4j.vo.MultiDayOfTheWeek;
import org.fuin.objects4j.vo.WeeklyOpeningHoursConverter;
import org.fuin.objects4j.vo.WeeklyOpeningHoursStr;

@Prompt(value="Mon-Fri 09:00-12:00+13:00-17:00,Sat/Sun 09:-12:00")
@XmlJavaTypeAdapter(value=WeeklyOpeningHoursConverter.class)
@Immutable
public final class WeeklyOpeningHours
extends AbstractStringValueObject
implements Iterable<DayOpeningHours> {
    private static final long serialVersionUID = 1000L;
    @NotEmpty
    private final List<DayOpeningHours> weeklyOpeningHours;
    private final String value;

    public WeeklyOpeningHours(@NotNull @WeeklyOpeningHoursStr String weeklyOpeningHours) {
        Contract.requireArgNotEmpty("weeklyOpeningHours", weeklyOpeningHours);
        WeeklyOpeningHours.requireArgValid("weeklyOpeningHours", weeklyOpeningHours);
        this.weeklyOpeningHours = new ArrayList<DayOpeningHours>();
        StringTokenizer tok = new StringTokenizer(weeklyOpeningHours, ",");
        while (tok.hasMoreTokens()) {
            String part = tok.nextToken();
            int p = part.indexOf(32);
            MultiDayOfTheWeek dayPart = MultiDayOfTheWeek.valueOf(part.substring(0, p));
            HourRanges hourPart = new HourRanges(part.substring(p + 1));
            for (DayOfTheWeek dow : dayPart) {
                DayOpeningHours doh = new DayOpeningHours(dow, hourPart);
                List<DayOpeningHours> normalized = doh.normalize();
                if (normalized.size() == 1) {
                    this.addOrUpdate(normalized.get(0));
                    continue;
                }
                this.addOrUpdate(normalized.get(0));
                this.addOrUpdate(normalized.get(1));
            }
        }
        Collections.sort(this.weeklyOpeningHours);
        this.value = weeklyOpeningHours.toUpperCase();
    }

    public WeeklyOpeningHours(DayOpeningHours ... dayOpeningHours) {
        Contract.requireArgNotNull("dayOpeningHours", dayOpeningHours);
        if (dayOpeningHours.length == 0) {
            throw new ConstraintViolationException("The argument 'dayOpeningHours' cannot be an empty array");
        }
        this.weeklyOpeningHours = new ArrayList<DayOpeningHours>();
        for (DayOpeningHours doh : dayOpeningHours) {
            if (doh == null) continue;
            if (this.weeklyOpeningHours.contains(doh)) {
                throw new ConstraintViolationException("The argument 'dayOpeningHours' cannot contain duplicates: " + doh);
            }
            this.addOrUpdate(doh);
        }
        Collections.sort(this.weeklyOpeningHours);
        this.value = WeeklyOpeningHours.asString(this.weeklyOpeningHours);
    }

    private void addOrUpdate(DayOpeningHours doh) {
        int idx = this.weeklyOpeningHours.indexOf(doh);
        if (idx < 0) {
            this.weeklyOpeningHours.add(doh);
        } else {
            this.weeklyOpeningHours.set(idx, this.weeklyOpeningHours.get(idx).add(doh));
        }
    }

    @Override
    @NotEmpty
    public String asBaseType() {
        return this.value;
    }

    public WeeklyOpeningHours normalize() {
        ArrayList<DayOpeningHours> days = new ArrayList<DayOpeningHours>();
        for (DayOpeningHours doh : this.weeklyOpeningHours) {
            List<DayOpeningHours> normalized = doh.normalize();
            for (DayOpeningHours normalizedDay : normalized) {
                int idx = days.indexOf(normalizedDay);
                if (idx < 0) {
                    days.add(normalizedDay);
                    continue;
                }
                DayOpeningHours found = (DayOpeningHours)days.get(idx);
                DayOpeningHours replacement = found.add(normalizedDay);
                days.set(idx, replacement);
            }
        }
        Collections.sort(days);
        return new WeeklyOpeningHours(days.toArray(new DayOpeningHours[days.size()]));
    }

    @Override
    public Iterator<DayOpeningHours> iterator() {
        return Collections.unmodifiableList(this.weeklyOpeningHours).iterator();
    }

    public List<DayOpeningHours.Change> diff(@NotNull WeeklyOpeningHours toOther) {
        Contract.requireArgNotNull("toOther", toOther);
        WeeklyOpeningHours thisNormalized = this.normalize();
        WeeklyOpeningHours otherNormalized = toOther.normalize();
        ArrayList<DayOpeningHours.Change> changes = new ArrayList<DayOpeningHours.Change>();
        for (DayOpeningHours thisDoh : thisNormalized) {
            DayOpeningHours otherDoh = otherNormalized.findDay(thisDoh);
            if (otherDoh == null) {
                changes.addAll(thisDoh.asRemovedChanges());
                continue;
            }
            changes.addAll(thisDoh.diff(otherDoh));
        }
        for (DayOpeningHours otherDoh : otherNormalized) {
            DayOpeningHours thisDoh = thisNormalized.findDay(otherDoh);
            if (thisDoh != null) continue;
            changes.addAll(otherDoh.asAddedChanges());
        }
        return changes;
    }

    public List<DayOpeningHours.Change> asRemovedChanges() {
        WeeklyOpeningHours normalized = this.normalize();
        ArrayList<DayOpeningHours.Change> changes = new ArrayList<DayOpeningHours.Change>();
        for (DayOpeningHours doh : normalized) {
            changes.addAll(doh.asRemovedChanges());
        }
        return changes;
    }

    public List<DayOpeningHours.Change> asAddedChanges() {
        WeeklyOpeningHours normalized = this.normalize();
        ArrayList<DayOpeningHours.Change> changes = new ArrayList<DayOpeningHours.Change>();
        for (DayOpeningHours doh : normalized) {
            changes.addAll(doh.asAddedChanges());
        }
        return changes;
    }

    private DayOpeningHours findDay(DayOpeningHours toFind) {
        int idx = this.weeklyOpeningHours.indexOf(toFind);
        if (idx < 0) {
            return null;
        }
        return this.weeklyOpeningHours.get(idx);
    }

    public final boolean openAt(@NotNull DayOpeningHours dayOpeningHours) {
        Contract.requireArgNotNull("dayOpeningHours", dayOpeningHours);
        if (!dayOpeningHours.isNormalized()) {
            throw new ConstraintViolationException("The argument 'dayOpeningHours' is expected to have only hours of a single day, but was: " + dayOpeningHours);
        }
        int idx = this.weeklyOpeningHours.indexOf(dayOpeningHours);
        if (idx < 0) {
            return false;
        }
        DayOpeningHours found = this.weeklyOpeningHours.get(idx);
        List<DayOpeningHours> normalized = found.normalize();
        DayOpeningHours day = normalized.get(0);
        return day.openAt(dayOpeningHours);
    }

    public boolean isSimilarTo(WeeklyOpeningHours other) {
        return this.compress().equals(other.compress());
    }

    public final WeeklyOpeningHours compress() {
        HashMap<HourRanges, ArrayList<DayOfTheWeek>> map = new HashMap<HourRanges, ArrayList<DayOfTheWeek>>();
        for (DayOpeningHours doh : this.weeklyOpeningHours) {
            HourRanges ranges = doh.getHourRanges().compress();
            ArrayList<DayOfTheWeek> dayList = (ArrayList<DayOfTheWeek>)map.get(ranges);
            if (dayList == null) {
                dayList = new ArrayList<DayOfTheWeek>();
                map.put(ranges, dayList);
            }
            dayList.add(doh.getDayOfTheWeek());
        }
        StringBuilder sb = new StringBuilder();
        for (HourRanges ranges : map.keySet()) {
            List days = (List)map.get(ranges);
            Collections.sort(days);
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(new MultiDayOfTheWeek(days.toArray(new DayOfTheWeek[days.size()])).compress().asBaseType() + " " + ranges);
        }
        return new WeeklyOpeningHours(sb.toString());
    }

    public final String toString() {
        return this.value;
    }

    private static String asString(List<DayOpeningHours> weeklyOpeningHours) {
        StringBuilder sb = new StringBuilder();
        for (DayOpeningHours dow : weeklyOpeningHours) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(dow.toString());
        }
        return sb.toString();
    }

    public static boolean isValid(@Nullable String weeklyOpeningHours) {
        if (weeklyOpeningHours == null) {
            return true;
        }
        ArrayList<DayOpeningHours> all = new ArrayList<DayOpeningHours>();
        StringTokenizer tok = new StringTokenizer(weeklyOpeningHours, ",");
        if (tok.countTokens() == 0) {
            return false;
        }
        while (tok.hasMoreTokens()) {
            String part = tok.nextToken();
            int p = part.indexOf(32);
            if (p < 0) {
                return false;
            }
            String dayPartStr = part.substring(0, p);
            if (!MultiDayOfTheWeek.isValid(dayPartStr)) {
                return false;
            }
            MultiDayOfTheWeek dayPart = MultiDayOfTheWeek.valueOf(dayPartStr);
            String hourPartStr = part.substring(p + 1);
            if (!HourRanges.isValid(hourPartStr)) {
                return false;
            }
            HourRanges hourPart = new HourRanges(hourPartStr);
            for (DayOfTheWeek dow : dayPart) {
                DayOpeningHours doh = new DayOpeningHours(dow, hourPart);
                if (all.contains(doh)) {
                    return false;
                }
                all.add(doh);
            }
            for (DayOpeningHours doh : all) {
                DayOpeningHours day;
                DayOpeningHours secondDay;
                int idx;
                List<DayOpeningHours> normalized = doh.normalize();
                if (normalized.size() != 2 || (idx = all.indexOf(secondDay = normalized.get(1))) <= -1 || !(day = (DayOpeningHours)all.get(idx)).overlaps(secondDay)) continue;
                return false;
            }
        }
        return true;
    }

    @Nullable
    public static WeeklyOpeningHours valueOf(@Nullable String str) {
        if (str == null) {
            return null;
        }
        return new WeeklyOpeningHours(str);
    }

    public static void requireArgValid(@NotNull String name, @NotNull String value) throws ConstraintViolationException {
        if (!WeeklyOpeningHours.isValid(value)) {
            throw new ConstraintViolationException("The argument '" + name + "' does not represent valid weekly opening hours like 'Mon-Fri 09:00-12:00+13:00-17:00,Sat/Sun 09:-12:00': '" + value + "'");
        }
    }
}

