/*
 * Decompiled with CFR 0.152.
 */
package org.gaul.modernizer_maven_plugin;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.gaul.modernizer_maven_plugin.ModernizerClassVisitor;
import org.gaul.modernizer_maven_plugin.Utils;
import org.gaul.modernizer_maven_plugin.Violation;
import org.gaul.modernizer_maven_plugin.ViolationOccurrence;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public final class Modernizer {
    private final long javaVersion;
    private final Map<String, Violation> violations;
    private final Collection<String> exclusions;
    private final Collection<Pattern> exclusionPatterns;
    private final Collection<String> ignorePackages;
    private final Set<String> ignoreClassNames;
    private final Collection<Pattern> ignoreFullClassNamePatterns;

    public Modernizer(String javaVersion, Map<String, Violation> violations, Collection<String> exclusions, Collection<Pattern> exclusionPatterns, Collection<String> ignorePackages, Set<String> ignoreClassNames, Collection<Pattern> ignoreClassNamePatterns) {
        long version = javaVersion.startsWith("1.") ? Long.parseLong(javaVersion.substring(2)) : Long.parseLong(javaVersion);
        Utils.checkArgument(version >= 0L);
        this.javaVersion = version;
        this.violations = Utils.createImmutableMap(violations);
        this.exclusions = Utils.createImmutableSet(exclusions);
        this.exclusionPatterns = Utils.createImmutableSet(exclusionPatterns);
        this.ignorePackages = Utils.createImmutableSet(ignorePackages);
        this.ignoreClassNames = Utils.createImmutableSet(ignoreClassNames);
        this.ignoreFullClassNamePatterns = Utils.createImmutableSet(ignoreClassNamePatterns);
    }

    public Collection<ViolationOccurrence> check(ClassReader classReader) throws IOException {
        ModernizerClassVisitor classVisitor = new ModernizerClassVisitor(this.javaVersion, this.violations, this.exclusions, this.exclusionPatterns, this.ignorePackages, this.ignoreClassNames, this.ignoreFullClassNamePatterns);
        classReader.accept((ClassVisitor)classVisitor, 0);
        return classVisitor.getOccurrences();
    }

    public Collection<ViolationOccurrence> check(InputStream is) throws IOException {
        return this.check(new ClassReader(is));
    }

    public static Map<String, Violation> parseFromXml(InputStream is) throws IOException, ParserConfigurationException, SAXException {
        HashMap<String, Violation> map = new HashMap<String, Violation>();
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
        Document doc = dBuilder.parse(is);
        doc.getDocumentElement().normalize();
        NodeList nList = doc.getElementsByTagName("violation");
        for (int temp = 0; temp < nList.getLength(); ++temp) {
            Node nNode = nList.item(temp);
            if (nNode.getNodeType() != 1) continue;
            Element element = (Element)nNode;
            String version = element.getElementsByTagName("version").item(0).getTextContent();
            int versionNum = version.startsWith("1.") ? Integer.parseInt(version.substring(2)) : Integer.parseInt(version);
            Violation violation = new Violation(element.getElementsByTagName("name").item(0).getTextContent(), versionNum, element.getElementsByTagName("comment").item(0).getTextContent());
            map.put(violation.getName(), violation);
        }
        return map;
    }
}

