/*
 * Decompiled with CFR 0.152.
 */
package org.gaul.modernizer_maven_plugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.gaul.modernizer_maven_annotations.SuppressModernizer;
import org.gaul.modernizer_maven_plugin.Utils;
import org.gaul.modernizer_maven_plugin.Violation;
import org.gaul.modernizer_maven_plugin.ViolationOccurrence;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.InstructionAdapter;

final class ModernizerClassVisitor
extends ClassVisitor {
    private final long javaVersion;
    private final Map<String, Violation> violations;
    private final Collection<String> exclusions;
    private final Collection<Pattern> exclusionPatterns;
    private final Collection<String> ignorePackages;
    private final Set<String> ignoreClassNames;
    private final Collection<Pattern> ignoreFullClassNamePatterns;
    private final Collection<ViolationOccurrence> occurrences = new ArrayList<ViolationOccurrence>();
    private String packageName;
    private String className;

    ModernizerClassVisitor(long javaVersion, Map<String, Violation> violations, Collection<String> exclusions, Collection<Pattern> exclusionPatterns, Collection<String> ignorePackages, Set<String> ignoreClassNames, Collection<Pattern> ignoreFullClassNamePatterns) {
        super(589824);
        Utils.checkArgument(javaVersion >= 0L);
        this.javaVersion = javaVersion;
        this.violations = Utils.checkNotNull(violations);
        this.exclusions = Utils.checkNotNull(exclusions);
        this.exclusionPatterns = Utils.checkNotNull(exclusionPatterns);
        this.ignorePackages = Utils.checkNotNull(ignorePackages);
        this.ignoreClassNames = Utils.checkNotNull(ignoreClassNames);
        this.ignoreFullClassNamePatterns = Utils.checkNotNull(ignoreFullClassNamePatterns);
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.className = name;
        this.packageName = name.contains("/") ? name.substring(0, name.lastIndexOf(47)).replace('/', '.') : "";
        if (this.ignoreClass()) {
            return;
        }
        for (String itr : interfaces) {
            Violation violation = this.violations.get(itr);
            this.checkToken(itr, violation, name, -1);
        }
    }

    public MethodVisitor visitMethod(int access, String methodName, String methodDescriptor, String methodSignature, String[] exceptions) {
        MethodVisitor base = super.visitMethod(access, methodName, methodDescriptor, methodSignature, exceptions);
        MethodVisitor origVisitor = new MethodVisitor(589824, base){};
        InstructionAdapter adapter = new InstructionAdapter(589824, origVisitor){
            private int lineNumber;
            private boolean methodSuppressed;
            {
                this.lineNumber = -1;
                this.methodSuppressed = false;
            }

            public void visitFieldInsn(int opcode, String owner, String name, String desc) {
                this.visitFieldOrMethod(owner, name, desc);
            }

            public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean isInterface) {
                if (name.equals("<init>")) {
                    name = "\"<init>\"";
                }
                this.visitFieldOrMethod(owner, name, desc);
            }

            public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                this.methodSuppressed |= Type.getType((String)desc).getClassName().equals(SuppressModernizer.class.getName());
                String name = Type.getType((String)desc).getInternalName();
                Violation violation = (Violation)ModernizerClassVisitor.this.violations.get(name);
                this.checkToken(name, violation, name, this.lineNumber);
                return super.visitAnnotation(desc, visible);
            }

            private void visitFieldOrMethod(String owner, String name, String desc) {
                String token = owner + "." + name + ":" + desc;
                Violation violation = (Violation)ModernizerClassVisitor.this.violations.get(token);
                this.checkToken(token, violation, name, this.lineNumber);
            }

            public void visitLineNumber(int lineNumber, Label start) {
                this.lineNumber = lineNumber;
            }

            private void checkToken(String token, Violation violation, String name, int lineNumber) {
                if (this.methodSuppressed) {
                    return;
                }
                ModernizerClassVisitor.this.checkToken(token, violation, name, lineNumber);
            }
        };
        return adapter;
    }

    private void checkToken(String token, Violation violation, String name, int lineNumber) {
        if (violation != null && !this.exclusions.contains(token) && this.javaVersion >= (long)violation.getVersion() && !this.ignorePackages.contains(this.packageName)) {
            if (this.ignoreClass()) {
                return;
            }
            for (Pattern pattern : this.exclusionPatterns) {
                if (!pattern.matcher(token).matches()) continue;
                return;
            }
            for (String prefix : this.ignorePackages) {
                if (!this.packageName.startsWith(prefix + ".")) continue;
                return;
            }
            this.occurrences.add(new ViolationOccurrence(name, lineNumber, violation));
        }
    }

    private boolean ignoreClass() {
        if (this.ignoreClassNames.contains(this.className)) {
            return true;
        }
        for (Pattern pattern : this.ignoreFullClassNamePatterns) {
            if (!pattern.matcher(this.className).matches()) continue;
            return true;
        }
        return false;
    }

    Collection<ViolationOccurrence> getOccurrences() {
        return this.occurrences;
    }
}

