/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.codec;

import org.geolatte.geom.ByteBuffer;
import org.geolatte.geom.Position;
import org.geolatte.geom.codec.BaseWkbParser;
import org.geolatte.geom.codec.HANAWkbDialect;
import org.geolatte.geom.codec.support.GeometryBuilder;
import org.geolatte.geom.crs.CoordinateReferenceSystem;
import org.geolatte.geom.crs.CoordinateReferenceSystems;
import org.geolatte.geom.crs.CrsRegistry;

class HANAWkbParser<P extends Position>
extends BaseWkbParser<P> {
    private boolean crsRead;

    HANAWkbParser(ByteBuffer buffer, CoordinateReferenceSystem<P> crs) {
        super(HANAWkbDialect.INSTANCE, buffer, crs);
    }

    @Override
    protected GeometryBuilder parseWkbType() {
        long tpe = this.buffer.getUInt();
        this.gtype = this.dialect.parseType(tpe);
        if (!this.crsRead) {
            this.readCrs(this.buffer, (int)tpe);
            this.crsRead = true;
        }
        return GeometryBuilder.create(this.gtype);
    }

    protected void readCrs(ByteBuffer byteBuffer, int typeCode) {
        this.hasM = (typeCode & 0x40000000) == 0x40000000;
        boolean bl = this.hasZ = (typeCode & Integer.MIN_VALUE) == Integer.MIN_VALUE;
        if ((typeCode & 0xFFFF) > 3000) {
            this.hasM = true;
            this.hasZ = true;
        } else if ((typeCode & 0xFFFF) > 2000) {
            this.hasM = true;
        } else if ((typeCode & 0xFFFF) > 1000) {
            this.hasZ = true;
        }
        int srid = 0;
        if (this.hasSrid(typeCode)) {
            srid = byteBuffer.getInt();
        }
        this.embeddedCRS = CrsRegistry.getCoordinateReferenceSystemForEPSG(srid, CoordinateReferenceSystems.PROJECTED_2D_METER);
    }

    protected boolean hasSrid(int typeCode) {
        return (typeCode & 0x20000000) == 0x20000000;
    }
}

