/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.codec.db.oracle;

import org.geolatte.geom.codec.db.Decoder;
import org.geolatte.geom.codec.db.oracle.GeometryCollectionSdoDecoder;
import org.geolatte.geom.codec.db.oracle.LineStringSdoDecoder;
import org.geolatte.geom.codec.db.oracle.MultiLineSdoDecoder;
import org.geolatte.geom.codec.db.oracle.MultiPointSdoDecoder;
import org.geolatte.geom.codec.db.oracle.MultiPolygonSdoDecoder;
import org.geolatte.geom.codec.db.oracle.PointSdoDecoder;
import org.geolatte.geom.codec.db.oracle.PolygonSdoDecoder;

enum TypeGeometry {
    UNKNOWN_GEOMETRY(0){

        @Override
        Decoder createDecoder() {
            throw new UnsupportedOperationException();
        }
    }
    ,
    POINT(1){

        @Override
        Decoder createDecoder() {
            return new PointSdoDecoder();
        }
    }
    ,
    LINE(2){

        @Override
        Decoder createDecoder() {
            return new LineStringSdoDecoder();
        }
    }
    ,
    POLYGON(3){

        @Override
        Decoder createDecoder() {
            return new PolygonSdoDecoder();
        }
    }
    ,
    COLLECTION(4){

        @Override
        Decoder createDecoder() {
            return new GeometryCollectionSdoDecoder();
        }
    }
    ,
    MULTIPOINT(5){

        @Override
        Decoder createDecoder() {
            return new MultiPointSdoDecoder();
        }
    }
    ,
    MULTILINE(6){

        @Override
        Decoder createDecoder() {
            return new MultiLineSdoDecoder();
        }
    }
    ,
    MULTIPOLYGON(7){

        @Override
        Decoder createDecoder() {
            return new MultiPolygonSdoDecoder();
        }
    }
    ,
    SOLID(8){

        @Override
        Decoder createDecoder() {
            throw new UnsupportedOperationException();
        }
    }
    ,
    MULTISOLID(9){

        @Override
        Decoder createDecoder() {
            throw new UnsupportedOperationException();
        }
    };

    private final int gtype;

    private TypeGeometry(int gtype) {
        this.gtype = gtype;
    }

    int intValue() {
        return this.gtype;
    }

    static TypeGeometry parse(int v) {
        for (TypeGeometry gt : TypeGeometry.values()) {
            if (gt.intValue() != v) continue;
            return gt;
        }
        throw new RuntimeException("Value " + v + " isn't a valid TypeGeometry value");
    }

    abstract Decoder createDecoder();
}

