/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.codec.db.sqlserver;

import java.util.ArrayList;
import java.util.List;
import org.geolatte.geom.Geometry;
import org.geolatte.geom.codec.db.Encoder;
import org.geolatte.geom.codec.db.sqlserver.AbstractSqlServerEncoder;
import org.geolatte.geom.codec.db.sqlserver.GeometryCollectionSqlServerEncoder;
import org.geolatte.geom.codec.db.sqlserver.LineStringSqlServerEncoder;
import org.geolatte.geom.codec.db.sqlserver.OpenGisType;
import org.geolatte.geom.codec.db.sqlserver.PointSqlServerEncoder;
import org.geolatte.geom.codec.db.sqlserver.PolygonSqlServerEncoder;
import org.geolatte.geom.codec.db.sqlserver.SqlServerGeometry;

public class Encoders {
    private static final List<AbstractSqlServerEncoder> ENCODERS = new ArrayList<AbstractSqlServerEncoder>();

    public static Encoder<SqlServerGeometry> encoderFor(Geometry<?> geom) {
        for (Encoder encoder : ENCODERS) {
            if (!encoder.accepts(geom)) continue;
            return encoder;
        }
        throw new IllegalArgumentException("No encoder for type " + (Object)((Object)geom.getGeometryType()));
    }

    public static byte[] encode(Geometry<?> geom) {
        Encoder<SqlServerGeometry> encoder = Encoders.encoderFor(geom);
        SqlServerGeometry sqlServerGeometry = encoder.encode(geom);
        return SqlServerGeometry.serialize(sqlServerGeometry);
    }

    static {
        ENCODERS.add(new PointSqlServerEncoder());
        ENCODERS.add(new LineStringSqlServerEncoder());
        ENCODERS.add(new PolygonSqlServerEncoder());
        ENCODERS.add(new GeometryCollectionSqlServerEncoder(OpenGisType.MULTIPOINT));
        ENCODERS.add(new GeometryCollectionSqlServerEncoder(OpenGisType.MULTILINESTRING));
        ENCODERS.add(new GeometryCollectionSqlServerEncoder(OpenGisType.MULTIPOLYGON));
        ENCODERS.add(new GeometryCollectionSqlServerEncoder(OpenGisType.GEOMETRYCOLLECTION));
    }
}

