/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.codec.support;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.geolatte.geom.Geometries;
import org.geolatte.geom.Geometry;
import org.geolatte.geom.GeometryType;
import org.geolatte.geom.Position;
import org.geolatte.geom.codec.support.GeometryBuilder;
import org.geolatte.geom.codec.support.Holder;
import org.geolatte.geom.crs.CoordinateReferenceSystem;

public class CollectionGeometryBuilder
extends GeometryBuilder {
    private final List<GeometryBuilder> components = new ArrayList<GeometryBuilder>();

    public void push(GeometryBuilder builder) {
        this.components.add(builder);
    }

    @Override
    public <P extends Position> Geometry<P> createGeometry(CoordinateReferenceSystem<P> crs) {
        if (this.components.isEmpty()) {
            return Geometries.mkEmptyGeometry(GeometryType.GEOMETRYCOLLECTION, crs);
        }
        List geoms = this.components.stream().map(c -> c.createGeometry(crs)).collect(Collectors.toList());
        return Geometries.mkGeometryCollection(geoms);
    }

    @Override
    public int getCoordinateDimension() {
        return this.components.isEmpty() ? 2 : this.components.get(0).getCoordinateDimension();
    }

    @Override
    public void setPositions(Holder positions) {
        throw new IllegalStateException("Can't set positions directly on this instance");
    }

    @Override
    public boolean isEmpty() {
        return this.components.isEmpty();
    }
}

