/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.geometry;

import org.geotoolkit.geometry.AbstractDirectPosition;
import org.geotoolkit.referencing.CRS;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.ArgumentChecks;
import org.geotoolkit.util.Strings;
import org.geotoolkit.util.Utilities;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public abstract class AbstractEnvelope
implements Envelope {
    private static final boolean[] CORNERS = new boolean[]{false, false, false, true, true, true, true, false, false, false};

    protected AbstractEnvelope() {
    }

    static boolean equalsIgnoreMetadata(CoordinateReferenceSystem coordinateReferenceSystem, CoordinateReferenceSystem coordinateReferenceSystem2) {
        return coordinateReferenceSystem == null || coordinateReferenceSystem2 == null || CRS.equalsIgnoreMetadata(coordinateReferenceSystem, coordinateReferenceSystem2);
    }

    static CoordinateReferenceSystem getCoordinateReferenceSystem(DirectPosition directPosition, DirectPosition directPosition2) {
        CoordinateReferenceSystem coordinateReferenceSystem = directPosition.getCoordinateReferenceSystem();
        CoordinateReferenceSystem coordinateReferenceSystem2 = directPosition2.getCoordinateReferenceSystem();
        if (coordinateReferenceSystem == null) {
            return coordinateReferenceSystem2;
        }
        if (coordinateReferenceSystem2 != null && !coordinateReferenceSystem.equals(coordinateReferenceSystem2)) {
            throw new IllegalArgumentException(Errors.format((int)111));
        }
        return coordinateReferenceSystem;
    }

    public DirectPosition getLowerCorner() {
        return new LowerCorner();
    }

    public DirectPosition getUpperCorner() {
        return new UpperCorner();
    }

    public String toString() {
        return AbstractEnvelope.toString(this);
    }

    public static String toString(Envelope envelope) {
        int n;
        int n2 = envelope.getDimension();
        StringBuilder stringBuilder = new StringBuilder("BOX").append(n2).append("D(");
        for (n = 0; n < n2; ++n) {
            if (n != 0) {
                stringBuilder.append(' ');
            }
            Strings.trimFractionalPart((StringBuilder)stringBuilder.append(envelope.getMinimum(n)));
        }
        stringBuilder.append(',');
        for (n = 0; n < n2; ++n) {
            Strings.trimFractionalPart((StringBuilder)stringBuilder.append(' ').append(envelope.getMaximum(n)));
        }
        return stringBuilder.append(')').toString();
    }

    public static String toPolygonString(Envelope envelope) {
        double d;
        int n;
        for (n = envelope.getDimension(); n != 0 && (Double.isNaN(d = envelope.getSpan(n - 1)) || Double.isInfinite(d)); --n) {
        }
        StringBuilder stringBuilder = new StringBuilder("POLYGON(");
        String string = "(";
        for (int i = 0; i < CORNERS.length; i += 2) {
            for (int j = 0; j < n; ++j) {
                double d2;
                switch (j) {
                    case 0: 
                    case 1: {
                        d2 = CORNERS[i + j] ? envelope.getMaximum(j) : envelope.getMinimum(j);
                        break;
                    }
                    default: {
                        d2 = envelope.getMedian(j);
                    }
                }
                Strings.trimFractionalPart((StringBuilder)stringBuilder.append(string).append(d2));
                string = " ";
            }
            string = ", ";
        }
        if (string == ", ") {
            stringBuilder.append(')');
        }
        return stringBuilder.append(')').toString();
    }

    public int hashCode() {
        int n = this.getDimension();
        int n2 = 1;
        boolean bl = true;
        do {
            for (int i = 0; i < n; ++i) {
                long l = Double.doubleToLongBits(bl ? this.getMinimum(i) : this.getMaximum(i));
                n2 = 31 * n2 + ((int)l ^ (int)(l >>> 32));
            }
        } while (!(bl = !bl));
        CoordinateReferenceSystem coordinateReferenceSystem = this.getCoordinateReferenceSystem();
        if (coordinateReferenceSystem != null) {
            n2 += coordinateReferenceSystem.hashCode();
        }
        return n2;
    }

    public boolean equals(Object object) {
        if (object != null && object.getClass() == this.getClass()) {
            Envelope envelope = (Envelope)object;
            int n = this.getDimension();
            if (n == envelope.getDimension()) {
                for (int i = 0; i < n; ++i) {
                    if (Utilities.equals((double)this.getMinimum(i), (double)envelope.getMinimum(i)) && Utilities.equals((double)this.getMaximum(i), (double)envelope.getMaximum(i))) continue;
                    return false;
                }
                if (Utilities.equals((Object)this.getCoordinateReferenceSystem(), (Object)envelope.getCoordinateReferenceSystem())) {
                    assert (this.hashCode() == envelope.hashCode()) : this;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean equals(Envelope envelope, double d, boolean bl) {
        ArgumentChecks.ensureNonNull((String)"envelope", (Object)envelope);
        int n = this.getDimension();
        if (envelope.getDimension() != n) {
            return false;
        }
        assert (AbstractEnvelope.equalsIgnoreMetadata(this.getCoordinateReferenceSystem(), envelope.getCoordinateReferenceSystem())) : envelope;
        for (int i = 0; i < n; ++i) {
            double d2;
            d2 = bl ? ((d2 = Math.max(this.getSpan(i), envelope.getSpan(i))) > 0.0 && d2 < Double.POSITIVE_INFINITY ? d2 * d : d) : d;
            if (Math.abs(this.getMinimum(i) - envelope.getMinimum(i)) <= d2 && Math.abs(this.getMaximum(i) - envelope.getMaximum(i)) <= d2) continue;
            return false;
        }
        return true;
    }

    private final class UpperCorner
    extends Corner {
        private UpperCorner() {
        }

        public double getOrdinate(int n) throws IndexOutOfBoundsException {
            return AbstractEnvelope.this.getMaximum(n);
        }
    }

    private final class LowerCorner
    extends Corner {
        private LowerCorner() {
        }

        public double getOrdinate(int n) throws IndexOutOfBoundsException {
            return AbstractEnvelope.this.getMinimum(n);
        }
    }

    private abstract class Corner
    extends AbstractDirectPosition {
        private Corner() {
        }

        public CoordinateReferenceSystem getCoordinateReferenceSystem() {
            return AbstractEnvelope.this.getCoordinateReferenceSystem();
        }

        public int getDimension() {
            return AbstractEnvelope.this.getDimension();
        }

        public void setOrdinate(int n, double d) {
            throw new UnsupportedOperationException();
        }
    }
}

