/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.geometry;

import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Arrays;
import javax.measure.converter.ConversionException;
import javax.measure.unit.Unit;
import org.geotoolkit.display.shape.XRectangle2D;
import org.geotoolkit.geometry.AbstractDirectPosition;
import org.geotoolkit.geometry.AbstractEnvelope;
import org.geotoolkit.geometry.GeneralDirectPosition;
import org.geotoolkit.math.XMath;
import org.geotoolkit.referencing.CRS;
import org.geotoolkit.referencing.crs.DefaultGeographicCRS;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.ArgumentChecks;
import org.geotoolkit.util.Cloneable;
import org.geotoolkit.util.Utilities;
import org.geotoolkit.util.XArrays;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.metadata.extent.GeographicBoundingBox;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.RangeMeaning;

public class GeneralEnvelope
extends AbstractEnvelope
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 1752330560227688940L;
    private static volatile Field ordinatesField;
    private final double[] ordinates;
    private CoordinateReferenceSystem crs;

    public GeneralEnvelope(int n) {
        this.ordinates = new double[n << 1];
    }

    public GeneralEnvelope(double d, double d2) {
        this.ordinates = new double[]{d, d2};
        GeneralEnvelope.checkCoordinates(this.ordinates);
    }

    public GeneralEnvelope(double[] dArray, double[] dArray2) throws IllegalArgumentException {
        ArgumentChecks.ensureNonNull((String)"minDP", (Object)dArray);
        ArgumentChecks.ensureNonNull((String)"maxDP", (Object)dArray2);
        GeneralEnvelope.ensureSameDimension(dArray.length, dArray2.length);
        this.ordinates = new double[dArray.length + dArray2.length];
        System.arraycopy(dArray, 0, this.ordinates, 0, dArray.length);
        System.arraycopy(dArray2, 0, this.ordinates, dArray.length, dArray2.length);
        GeneralEnvelope.checkCoordinates(this.ordinates);
    }

    public GeneralEnvelope(GeneralDirectPosition generalDirectPosition, GeneralDirectPosition generalDirectPosition2) throws IllegalArgumentException {
        this(generalDirectPosition.ordinates, generalDirectPosition2.ordinates);
        this.crs = GeneralEnvelope.getCoordinateReferenceSystem(generalDirectPosition, generalDirectPosition2);
        AbstractDirectPosition.checkCoordinateReferenceSystemDimension(this.crs, this.ordinates.length >>> 1);
    }

    public GeneralEnvelope(CoordinateReferenceSystem coordinateReferenceSystem) {
        this(coordinateReferenceSystem.getCoordinateSystem().getDimension());
        this.crs = coordinateReferenceSystem;
    }

    public GeneralEnvelope(Envelope envelope) {
        ArgumentChecks.ensureNonNull((String)"envelope", (Object)envelope);
        if (envelope instanceof GeneralEnvelope) {
            GeneralEnvelope generalEnvelope = (GeneralEnvelope)envelope;
            this.ordinates = (double[])generalEnvelope.ordinates.clone();
            this.crs = generalEnvelope.crs;
        } else {
            this.crs = envelope.getCoordinateReferenceSystem();
            int n = envelope.getDimension();
            this.ordinates = new double[2 * n];
            for (int i = 0; i < n; ++i) {
                this.ordinates[i] = envelope.getMinimum(i);
                this.ordinates[i + n] = envelope.getMaximum(i);
            }
            GeneralEnvelope.checkCoordinates(this.ordinates);
        }
    }

    public GeneralEnvelope(GeographicBoundingBox geographicBoundingBox) {
        ArgumentChecks.ensureNonNull((String)"box", (Object)geographicBoundingBox);
        this.ordinates = new double[]{geographicBoundingBox.getWestBoundLongitude(), geographicBoundingBox.getSouthBoundLatitude(), geographicBoundingBox.getEastBoundLongitude(), geographicBoundingBox.getNorthBoundLatitude()};
        this.crs = DefaultGeographicCRS.WGS84;
    }

    public GeneralEnvelope(Rectangle2D rectangle2D) {
        ArgumentChecks.ensureNonNull((String)"rect", (Object)rectangle2D);
        this.ordinates = new double[]{rectangle2D.getMinX(), rectangle2D.getMinY(), rectangle2D.getMaxX(), rectangle2D.getMaxY()};
        GeneralEnvelope.checkCoordinates(this.ordinates);
    }

    /*
     * Unable to fully structure code
     */
    public GeneralEnvelope(String var1_1) throws NumberFormatException, IllegalArgumentException {
        super();
        ArgumentChecks.ensureNonNull((String)"wkt", (Object)var1_1);
        var2_2 = 0;
        var3_3 = 0;
        var4_4 = 4;
        var5_5 = 0;
        var6_6 = var1_1.length();
        var7_7 = new double[var4_4];
        var8_8 = new double[var4_4];
        var9_9 = 0;
        block12: for (var10_10 = 0; var10_10 < var6_6; ++var10_10) {
            var11_11 = var1_1.charAt(var10_10);
            if (!Character.isJavaIdentifierStart(var11_11)) ** GOTO lbl17
            while (++var10_10 < var6_6) {
                var11_11 = var1_1.charAt(var10_10);
                if (Character.isJavaIdentifierPart(var11_11)) continue;
lbl17:
                // 2 sources

                if (Character.isWhitespace(var11_11)) continue block12;
                switch (var11_11) {
                    case ',': {
                        var9_9 = 0;
                        continue block12;
                    }
                    case '(': {
                        ++var2_2;
                        var9_9 = 0;
                        continue block12;
                    }
                    case '[': {
                        ++var3_3;
                        var9_9 = 0;
                        continue block12;
                    }
                    case ')': {
                        if (--var2_2 < 0) {
                            GeneralEnvelope.fail(var1_1, '(');
                        }
                        var9_9 = 0;
                        continue block12;
                    }
                    case ']': {
                        if (--var3_3 < 0) {
                            GeneralEnvelope.fail(var1_1, '[');
                        }
                        var9_9 = 0;
                        continue block12;
                    }
                    default: {
                        var12_12 = var10_10;
                        var13_13 = false;
                        block14: while (++var10_10 < var6_6 && !Character.isWhitespace(var11_11 = var1_1.charAt(var10_10))) {
                            switch (var11_11) {
                                case ',': {
                                    var13_13 = true;
                                    break block14;
                                }
                                case ')': {
                                    if (--var2_2 < 0) {
                                        GeneralEnvelope.fail(var1_1, '(');
                                    }
                                    var13_13 = true;
                                    break block14;
                                }
                                case ']': {
                                    if (--var3_3 < 0) {
                                        GeneralEnvelope.fail(var1_1, '[');
                                    }
                                    var13_13 = true;
                                    break block14;
                                }
                                default: {
                                    continue block14;
                                }
                            }
                        }
                        var14_14 = Double.parseDouble(var1_1.substring(var12_12, var10_10));
                        if (var9_9 == var5_5) {
                            if (var9_9 == var4_4) {
                                var7_7 = Arrays.copyOf(var7_7, var4_4 *= 2);
                                var8_8 = Arrays.copyOf(var8_8, var4_4);
                            }
                            var7_7[var9_9] = var8_8[var9_9] = var14_14;
                            var5_5 = ++var9_9;
                        } else {
                            if (var14_14 < var7_7[var9_9]) {
                                var7_7[var9_9] = var14_14;
                            }
                            if (var14_14 > var8_8[var9_9]) {
                                var8_8[var9_9] = var14_14;
                            }
                            ++var9_9;
                        }
                        if (!var13_13) continue block12;
                        var9_9 = 0;
                    }
                }
                continue block12;
            }
            break block12;
        }
        if (var2_2 != 0) {
            GeneralEnvelope.fail(var1_1, ')');
        }
        if (var3_3 != 0) {
            GeneralEnvelope.fail(var1_1, ']');
        }
        this.ordinates = XArrays.resize((double[])var7_7, (int)(var5_5 << 1));
        System.arraycopy(var8_8, 0, this.ordinates, var5_5, var5_5);
    }

    private static void fail(String string, char c) {
        throw new IllegalArgumentException(Errors.format((int)132, (Object)string, (Object)Character.valueOf(c)));
    }

    private static void ensureSameDimension(int n, int n2) throws MismatchedDimensionException {
        if (n != n2) {
            throw new MismatchedDimensionException(Errors.format((int)112, (Object)n, (Object)n2));
        }
    }

    private static void checkCoordinates(double[] dArray) throws IllegalArgumentException {
        int n = dArray.length >>> 1;
        for (int i = 0; i < n; ++i) {
            double d = dArray[i];
            double d2 = dArray[n + i];
            if (!(d > d2)) continue;
            String string = Errors.format((int)81, (Object)i);
            string = string + ' ' + Errors.format((int)14, (Object)d, (Object)d2);
            throw new IllegalArgumentException(string);
        }
    }

    public final int getDimension() {
        return this.ordinates.length >>> 1;
    }

    public final CoordinateReferenceSystem getCoordinateReferenceSystem() {
        assert (this.crs == null || this.crs.getCoordinateSystem().getDimension() == this.getDimension());
        return this.crs;
    }

    public void setCoordinateReferenceSystem(CoordinateReferenceSystem coordinateReferenceSystem) throws MismatchedDimensionException {
        AbstractDirectPosition.checkCoordinateReferenceSystemDimension(coordinateReferenceSystem, this.getDimension());
        this.crs = coordinateReferenceSystem;
    }

    public boolean reduceToDomain(boolean bl) {
        boolean bl2 = false;
        if (this.crs != null) {
            Envelope envelope;
            double d;
            CoordinateSystemAxis coordinateSystemAxis;
            int n = this.ordinates.length >>> 1;
            CoordinateSystem coordinateSystem = this.crs.getCoordinateSystem();
            for (int i = 0; i < n; ++i) {
                double d2;
                int n2 = i + n;
                coordinateSystemAxis = coordinateSystem.getAxis(i);
                double d3 = coordinateSystemAxis.getMinimumValue();
                d = coordinateSystemAxis.getMaximumValue();
                RangeMeaning rangeMeaning = coordinateSystemAxis.getRangeMeaning();
                if (RangeMeaning.EXACT.equals((Object)rangeMeaning)) {
                    if (this.ordinates[i] < d3) {
                        this.ordinates[i] = d3;
                        bl2 = true;
                    }
                    if (!(this.ordinates[n2] > d)) continue;
                    this.ordinates[n2] = d;
                    bl2 = true;
                    continue;
                }
                if (!RangeMeaning.WRAPAROUND.equals((Object)rangeMeaning) || !((d2 = d - d3) > 0.0) || !(d2 < Double.POSITIVE_INFINITY)) continue;
                double d4 = Math.floor((this.ordinates[i] - d3) / d2) * d2;
                if (d4 != 0.0) {
                    int n3 = i;
                    this.ordinates[n3] = this.ordinates[n3] - d4;
                    int n4 = n2;
                    this.ordinates[n4] = this.ordinates[n4] - d4;
                    bl2 = true;
                }
                if (!(this.ordinates[n2] > d)) continue;
                this.ordinates[i] = d3;
                this.ordinates[n2] = d;
                bl2 = true;
            }
            if (bl && (envelope = CRS.getEnvelope(this.crs)) != null) {
                CoordinateReferenceSystem coordinateReferenceSystem = envelope.getCoordinateReferenceSystem();
                if (coordinateReferenceSystem == null) {
                    this.intersect(envelope);
                } else {
                    coordinateSystemAxis = coordinateReferenceSystem.getCoordinateSystem();
                    int n5 = coordinateSystemAxis.getDimension();
                    for (int i = 0; i < n5; ++i) {
                        d = envelope.getMinimum(i);
                        double d5 = envelope.getMaximum(i);
                        AxisDirection axisDirection = coordinateSystemAxis.getAxis(i).getDirection();
                        for (int j = 0; j < n; ++j) {
                            if (!axisDirection.equals((Object)coordinateSystem.getAxis(j).getDirection())) continue;
                            int n6 = j + n;
                            if (this.ordinates[j] < d) {
                                this.ordinates[j] = d;
                            }
                            if (!(this.ordinates[n6] > d5)) continue;
                            this.ordinates[n6] = d5;
                        }
                    }
                }
            }
        }
        return bl2;
    }

    public void roundIfAlmostInteger(double d, int n) {
        if (!(d > 0.0)) {
            throw new IllegalArgumentException(Errors.format((int)73, (Object)"factor", (Object)d));
        }
        for (int i = 0; i < this.ordinates.length; ++i) {
            double d2 = this.ordinates[i] * d;
            double d3 = XMath.roundIfAlmostInteger((double)d2, (int)n);
            if (d2 == d3) continue;
            this.ordinates[i] = d3 / d;
        }
    }

    @Override
    public DirectPosition getLowerCorner() {
        int n = this.ordinates.length >>> 1;
        GeneralDirectPosition generalDirectPosition = new GeneralDirectPosition(n);
        System.arraycopy(this.ordinates, 0, generalDirectPosition.ordinates, 0, n);
        generalDirectPosition.setCoordinateReferenceSystem(this.crs);
        return generalDirectPosition;
    }

    @Override
    public DirectPosition getUpperCorner() {
        int n = this.ordinates.length >>> 1;
        GeneralDirectPosition generalDirectPosition = new GeneralDirectPosition(n);
        System.arraycopy(this.ordinates, n, generalDirectPosition.ordinates, 0, n);
        generalDirectPosition.setCoordinateReferenceSystem(this.crs);
        return generalDirectPosition;
    }

    public DirectPosition getMedian() {
        GeneralDirectPosition generalDirectPosition = new GeneralDirectPosition(this.ordinates.length >>> 1);
        int n = generalDirectPosition.ordinates.length;
        while (--n >= 0) {
            generalDirectPosition.ordinates[n] = this.getMedian(n);
        }
        generalDirectPosition.setCoordinateReferenceSystem(this.crs);
        return generalDirectPosition;
    }

    public final double getMinimum(int n) throws IndexOutOfBoundsException {
        ArgumentChecks.ensureValidIndex((int)(this.ordinates.length >>> 1), (int)n);
        return this.ordinates[n];
    }

    public final double getMaximum(int n) throws IndexOutOfBoundsException {
        ArgumentChecks.ensureValidIndex((int)(this.ordinates.length >>> 1), (int)n);
        return this.ordinates[n + (this.ordinates.length >>> 1)];
    }

    public final double getMedian(int n) throws IndexOutOfBoundsException {
        return 0.5 * (this.ordinates[n] + this.ordinates[n + (this.ordinates.length >>> 1)]);
    }

    public final double getSpan(int n) throws IndexOutOfBoundsException {
        return this.ordinates[n + (this.ordinates.length >>> 1)] - this.ordinates[n];
    }

    public double getSpan(int n, Unit<?> unit) throws IndexOutOfBoundsException, ConversionException {
        Unit unit2;
        double d = this.getSpan(n);
        if (this.crs != null && (unit2 = this.crs.getCoordinateSystem().getAxis(n).getUnit()) != null) {
            d = unit2.getConverterToAny(unit).convert(d);
        }
        return d;
    }

    public void setRange(int n, double d, double d2) throws IndexOutOfBoundsException {
        if (d > d2) {
            d = d2 = 0.5 * (d + d2);
        }
        ArgumentChecks.ensureValidIndex((int)(this.ordinates.length >>> 1), (int)n);
        this.ordinates[n + (this.ordinates.length >>> 1)] = d2;
        this.ordinates[n] = d;
    }

    public void setEnvelope(double ... dArray) {
        if ((dArray.length & 1) != 0) {
            throw new IllegalArgumentException(Errors.format((int)178, (Object)dArray.length));
        }
        int n = dArray.length >>> 1;
        int n2 = this.ordinates.length >>> 1;
        if (n != n2) {
            throw new MismatchedDimensionException(Errors.format((int)113, (Object)"ordinates", (Object)n, (Object)n2));
        }
        GeneralEnvelope.checkCoordinates(dArray);
        System.arraycopy(dArray, 0, this.ordinates, 0, dArray.length);
    }

    public void setEnvelope(Envelope envelope) throws MismatchedDimensionException {
        ArgumentChecks.ensureNonNull((String)"envelope", (Object)envelope);
        int n = this.ordinates.length >>> 1;
        AbstractDirectPosition.ensureDimensionMatch("envelope", envelope.getDimension(), n);
        if (envelope instanceof GeneralEnvelope) {
            System.arraycopy(((GeneralEnvelope)envelope).ordinates, 0, this.ordinates, 0, this.ordinates.length);
        } else {
            for (int i = 0; i < n; ++i) {
                this.ordinates[i] = envelope.getMinimum(i);
                this.ordinates[i + n] = envelope.getMaximum(i);
            }
        }
        CoordinateReferenceSystem coordinateReferenceSystem = envelope.getCoordinateReferenceSystem();
        if (coordinateReferenceSystem != null) {
            this.crs = coordinateReferenceSystem;
            assert (this.crs.getCoordinateSystem().getDimension() == this.getDimension()) : this.crs;
            assert (envelope.getClass() != this.getClass() || this.equals(envelope)) : envelope;
        }
    }

    public void setSubEnvelope(Envelope envelope, int n) throws IndexOutOfBoundsException {
        ArgumentChecks.ensureNonNull((String)"envelope", (Object)envelope);
        int n2 = envelope.getDimension();
        int n3 = this.ordinates.length >>> 1;
        if (n < 0 || n + n2 > n3) {
            throw new IndexOutOfBoundsException(Errors.format((int)73, (Object)"lower", (Object)n));
        }
        for (int i = 0; i < n2; ++i) {
            this.ordinates[n] = envelope.getMinimum(i);
            this.ordinates[n + n3] = envelope.getMaximum(i);
            ++n;
        }
    }

    public GeneralEnvelope getSubEnvelope(int n, int n2) throws IndexOutOfBoundsException {
        int n3 = this.ordinates.length >>> 1;
        int n4 = n2 - n;
        if (n < 0 || n > n3) {
            throw new IndexOutOfBoundsException(Errors.format((int)73, (Object)"lower", (Object)n));
        }
        if (n4 < 0 || n2 > n3) {
            throw new IndexOutOfBoundsException(Errors.format((int)73, (Object)"upper", (Object)n2));
        }
        GeneralEnvelope generalEnvelope = new GeneralEnvelope(n4);
        System.arraycopy(this.ordinates, n, generalEnvelope.ordinates, 0, n4);
        System.arraycopy(this.ordinates, n + n3, generalEnvelope.ordinates, n4, n4);
        return generalEnvelope;
    }

    public GeneralEnvelope getReducedEnvelope(int n, int n2) throws IndexOutOfBoundsException {
        int n3 = this.ordinates.length >>> 1;
        int n4 = n2 - n;
        if (n < 0 || n > n3) {
            throw new IndexOutOfBoundsException(Errors.format((int)73, (Object)"lower", (Object)n));
        }
        if (n4 < 0 || n2 > n3) {
            throw new IndexOutOfBoundsException(Errors.format((int)73, (Object)"upper", (Object)n2));
        }
        GeneralEnvelope generalEnvelope = new GeneralEnvelope(n3 - n4);
        System.arraycopy(this.ordinates, 0, generalEnvelope.ordinates, 0, n);
        System.arraycopy(this.ordinates, n, generalEnvelope.ordinates, n2, n3 - n2);
        return generalEnvelope;
    }

    public void setToInfinite() {
        int n = this.ordinates.length >>> 1;
        Arrays.fill(this.ordinates, 0, n, Double.NEGATIVE_INFINITY);
        Arrays.fill(this.ordinates, n, this.ordinates.length, Double.POSITIVE_INFINITY);
        assert (this.isInfinite()) : this;
    }

    public boolean isInfinite() {
        for (int i = 0; i < this.ordinates.length; ++i) {
            if (!Double.isInfinite(this.ordinates[i])) continue;
            return true;
        }
        return false;
    }

    public void setToNull() {
        Arrays.fill(this.ordinates, Double.NaN);
        assert (this.isNull()) : this;
    }

    public boolean isNull() {
        for (int i = 0; i < this.ordinates.length; ++i) {
            if (Double.isNaN(this.ordinates[i])) continue;
            return false;
        }
        assert (this.isEmpty()) : this;
        return true;
    }

    public boolean isEmpty() {
        int n = this.ordinates.length >>> 1;
        if (n == 0) {
            return true;
        }
        for (int i = 0; i < n; ++i) {
            if (this.ordinates[i] < this.ordinates[i + n]) continue;
            return true;
        }
        assert (!this.isNull()) : this;
        return false;
    }

    private static boolean hasNaN(DirectPosition directPosition) {
        int n = directPosition.getDimension();
        while (--n >= 0) {
            if (!Double.isNaN(directPosition.getOrdinate(n))) continue;
            return true;
        }
        return false;
    }

    private static boolean hasNaN(Envelope envelope) {
        return GeneralEnvelope.hasNaN(envelope.getLowerCorner()) || GeneralEnvelope.hasNaN(envelope.getUpperCorner());
    }

    public void add(DirectPosition directPosition) throws MismatchedDimensionException {
        ArgumentChecks.ensureNonNull((String)"position", (Object)directPosition);
        int n = this.ordinates.length >>> 1;
        AbstractDirectPosition.ensureDimensionMatch("position", directPosition.getDimension(), n);
        assert (GeneralEnvelope.equalsIgnoreMetadata(this.crs, directPosition.getCoordinateReferenceSystem())) : directPosition;
        for (int i = 0; i < n; ++i) {
            double d = directPosition.getOrdinate(i);
            if (d < this.ordinates[i]) {
                this.ordinates[i] = d;
            }
            if (!(d > this.ordinates[i + n])) continue;
            this.ordinates[i + n] = d;
        }
        assert (this.isEmpty() || this.contains(directPosition) || GeneralEnvelope.hasNaN(directPosition)) : directPosition;
    }

    public void add(Envelope envelope) throws MismatchedDimensionException {
        ArgumentChecks.ensureNonNull((String)"envelope", (Object)envelope);
        int n = this.ordinates.length >>> 1;
        AbstractDirectPosition.ensureDimensionMatch("envelope", envelope.getDimension(), n);
        assert (GeneralEnvelope.equalsIgnoreMetadata(this.crs, envelope.getCoordinateReferenceSystem())) : envelope;
        for (int i = 0; i < n; ++i) {
            double d = envelope.getMinimum(i);
            double d2 = envelope.getMaximum(i);
            if (d < this.ordinates[i]) {
                this.ordinates[i] = d;
            }
            if (!(d2 > this.ordinates[i + n])) continue;
            this.ordinates[i + n] = d2;
        }
        assert (this.isEmpty() || this.contains(envelope, true) || GeneralEnvelope.hasNaN(envelope)) : envelope;
    }

    public boolean contains(DirectPosition directPosition) throws MismatchedDimensionException {
        ArgumentChecks.ensureNonNull((String)"position", (Object)directPosition);
        int n = this.ordinates.length >>> 1;
        AbstractDirectPosition.ensureDimensionMatch("point", directPosition.getDimension(), n);
        assert (GeneralEnvelope.equalsIgnoreMetadata(this.crs, directPosition.getCoordinateReferenceSystem())) : directPosition;
        for (int i = 0; i < n; ++i) {
            double d = directPosition.getOrdinate(i);
            if (!(d >= this.ordinates[i])) {
                return false;
            }
            if (d <= this.ordinates[i + n]) continue;
            return false;
        }
        return true;
    }

    public boolean contains(Envelope envelope, boolean bl) throws MismatchedDimensionException {
        ArgumentChecks.ensureNonNull((String)"envelope", (Object)envelope);
        int n = this.ordinates.length >>> 1;
        AbstractDirectPosition.ensureDimensionMatch("envelope", envelope.getDimension(), n);
        assert (GeneralEnvelope.equalsIgnoreMetadata(this.crs, envelope.getCoordinateReferenceSystem())) : envelope;
        for (int i = 0; i < n; ++i) {
            double d = envelope.getMinimum(i);
            double d2 = this.ordinates[i];
            if (!(!bl ? d > d2 : d >= d2)) {
                return false;
            }
            d = envelope.getMaximum(i);
            d2 = this.ordinates[i + n];
            if (!bl ? d < d2 : d <= d2) continue;
            return false;
        }
        assert (this.intersects(envelope, bl) || GeneralEnvelope.hasNaN(envelope)) : envelope;
        return true;
    }

    public boolean intersects(Envelope envelope, boolean bl) throws MismatchedDimensionException {
        ArgumentChecks.ensureNonNull((String)"envelope", (Object)envelope);
        int n = this.ordinates.length >>> 1;
        AbstractDirectPosition.ensureDimensionMatch("envelope", envelope.getDimension(), n);
        assert (GeneralEnvelope.equalsIgnoreMetadata(this.crs, envelope.getCoordinateReferenceSystem())) : envelope;
        for (int i = 0; i < n; ++i) {
            double d = envelope.getMaximum(i);
            double d2 = this.ordinates[i];
            if (!(!bl ? d > d2 : d >= d2)) {
                return false;
            }
            d = envelope.getMinimum(i);
            d2 = this.ordinates[i + n];
            if (!bl ? d < d2 : d <= d2) continue;
            return false;
        }
        return true;
    }

    public void intersect(Envelope envelope) throws MismatchedDimensionException {
        ArgumentChecks.ensureNonNull((String)"envelope", (Object)envelope);
        int n = this.ordinates.length >>> 1;
        AbstractDirectPosition.ensureDimensionMatch("envelope", envelope.getDimension(), n);
        assert (GeneralEnvelope.equalsIgnoreMetadata(this.crs, envelope.getCoordinateReferenceSystem())) : envelope;
        for (int i = 0; i < n; ++i) {
            double d;
            double d2 = Math.max(this.ordinates[i], envelope.getMinimum(i));
            if (d2 > (d = Math.min(this.ordinates[i + n], envelope.getMaximum(i)))) {
                d2 = d = 0.5 * (d2 + d);
            }
            this.ordinates[i] = d2;
            this.ordinates[i + n] = d;
        }
    }

    public Rectangle2D toRectangle2D() throws IllegalStateException {
        if (this.ordinates.length == 4) {
            return XRectangle2D.createFromExtremums((double)this.ordinates[0], (double)this.ordinates[1], (double)this.ordinates[2], (double)this.ordinates[3]);
        }
        throw new IllegalStateException(Errors.format((int)150, (Object)this.getDimension()));
    }

    @Override
    public int hashCode() {
        int n = Arrays.hashCode(this.ordinates);
        if (this.crs != null) {
            n += this.crs.hashCode();
        }
        assert (n == super.hashCode());
        return n;
    }

    @Override
    public boolean equals(Object object) {
        if (object != null && object.getClass() == this.getClass()) {
            GeneralEnvelope generalEnvelope = (GeneralEnvelope)object;
            return Arrays.equals(this.ordinates, generalEnvelope.ordinates) && Utilities.equals((Object)this.crs, (Object)generalEnvelope.crs);
        }
        return false;
    }

    public GeneralEnvelope clone() {
        try {
            Field field = ordinatesField;
            if (field == null) {
                field = GeneralEnvelope.class.getDeclaredField("ordinates");
                field.setAccessible(true);
                ordinatesField = field;
            }
            GeneralEnvelope generalEnvelope = (GeneralEnvelope)super.clone();
            field.set(generalEnvelope, this.ordinates.clone());
            return generalEnvelope;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new AssertionError((Object)cloneNotSupportedException);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new AssertionError((Object)noSuchFieldException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new AssertionError((Object)illegalAccessException);
        }
    }
}

