/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.internal.referencing;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.measure.unit.NonSI;
import javax.measure.unit.SI;
import javax.measure.unit.Unit;
import org.geotoolkit.metadata.iso.citation.Citations;
import org.geotoolkit.parameter.DefaultParameterDescriptor;
import org.geotoolkit.parameter.DefaultParameterDescriptorGroup;
import org.geotoolkit.referencing.NamedIdentifier;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.NullArgumentException;
import org.geotoolkit.util.XArrays;
import org.geotoolkit.util.collection.XCollections;
import org.opengis.metadata.citation.Citation;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.util.GenericName;

public final class Identifiers
extends DefaultParameterDescriptor<Double> {
    private static final long serialVersionUID = -4608976443553166518L;
    public static final Identifiers CENTRAL_MERIDIAN = new Identifiers(new NamedIdentifier[]{new NamedIdentifier(OGC, "central_meridian"), new NamedIdentifier(Citations.ESRI, "Central_Meridian"), new NamedIdentifier(OGC, "longitude_of_center"), new NamedIdentifier(Citations.ESRI, "Longitude_Of_Center"), new NamedIdentifier(Citations.ESRI, "Longitude_Of_Origin"), new NamedIdentifier(EPSG, "Longitude of origin"), new NamedIdentifier(EPSG, "Longitude of false origin"), new NamedIdentifier(EPSG, "Longitude of natural origin"), new NamedIdentifier(EPSG, "Spherical longitude of origin"), new NamedIdentifier(EPSG, "Longitude of projection centre"), new NamedIdentifier(GEOTIFF, "NatOriginLong"), new NamedIdentifier(GEOTIFF, "FalseOriginLong"), new NamedIdentifier(GEOTIFF, "ProjCenterLong"), new NamedIdentifier(GEOTIFF, "CenterLong"), new NamedIdentifier(GEOTIFF, "StraightVertPoleLong")}, 0.0, -180.0, 180.0, NonSI.DEGREE_ANGLE, true);
    public static final Identifiers LATITUDE_OF_ORIGIN;
    public static final Identifiers STANDARD_PARALLEL_1;
    public static final Identifiers STANDARD_PARALLEL_2;
    public static final Identifiers LAT_OF_1ST_POINT;
    public static final Identifiers LONG_OF_1ST_POINT;
    public static final Identifiers LAT_OF_2ND_POINT;
    public static final Identifiers LONG_OF_2ND_POINT;
    public static final Identifiers AZIMUTH;
    public static final Identifiers RECTIFIED_GRID_ANGLE;
    public static final Identifiers SCALE_FACTOR;
    public static final Identifiers FALSE_EASTING;
    public static final Identifiers FALSE_NORTHING;
    private final Map<String, NamedIdentifier> identifiers;

    private Identifiers(NamedIdentifier[] namedIdentifierArray, double d, double d2, double d3, Unit<?> unit, boolean bl) {
        super(Identifiers.toMap((ReferenceIdentifier[])namedIdentifierArray), Double.class, null, Double.isNaN(d) ? null : Double.valueOf(d), d2 == Double.NEGATIVE_INFINITY ? null : Double.valueOf(d2), d3 == Double.POSITIVE_INFINITY ? null : Double.valueOf(d3), unit, bl);
        this.identifiers = new LinkedHashMap<String, NamedIdentifier>(XCollections.hashMapCapacity((int)namedIdentifierArray.length));
        for (NamedIdentifier namedIdentifier : namedIdentifierArray) {
            if (this.identifiers.put(namedIdentifier.getCode(), namedIdentifier) == null) continue;
            throw new IllegalArgumentException(Errors.format((int)55, (Object)((Object)namedIdentifier)));
        }
    }

    public ParameterDescriptor<Double> select(String ... stringArray) {
        return this.select(this.getMinimumOccurs() != 0, (Double)this.getDefaultValue(), stringArray);
    }

    public ParameterDescriptor<Double> select(boolean bl, String ... stringArray) {
        return this.select(bl, (Double)this.getDefaultValue(), stringArray);
    }

    public ParameterDescriptor<Double> select(boolean bl, double d, String ... stringArray) {
        return this.select(bl, (Double)d, stringArray);
    }

    private ParameterDescriptor<Double> select(boolean bl, Double d, String ... stringArray) {
        Object object;
        Object object2;
        int n;
        HashMap<Citation, Boolean> hashMap = new HashMap<Citation, Boolean>();
        NamedIdentifier[] namedIdentifierArray = new NamedIdentifier[this.identifiers.size()];
        namedIdentifierArray = this.identifiers.values().toArray(namedIdentifierArray);
        boolean[] blArray = new boolean[namedIdentifierArray.length];
        boolean[] blArray2 = new boolean[stringArray.length];
        block0: for (n = 0; n < namedIdentifierArray.length; ++n) {
            NamedIdentifier namedIdentifier = namedIdentifierArray[n];
            object2 = namedIdentifier.getCode();
            int n2 = stringArray.length;
            while (--n2 >= 0) {
                if (!object2.equals(stringArray[n2])) continue;
                object = namedIdentifier.getAuthority();
                if (hashMap.put((Citation)object, Boolean.TRUE) != null) {
                    throw new IllegalStateException(Errors.format((int)245, (Object)object));
                }
                blArray2[n2] = true;
                blArray[n] = true;
                continue block0;
            }
        }
        for (n = 0; n < blArray2.length; ++n) {
            if (blArray2[n]) continue;
            throw new IllegalArgumentException(Errors.format((int)223, (Object)stringArray[n]));
        }
        n = 0;
        for (int i = 0; i < namedIdentifierArray.length; ++i) {
            object2 = namedIdentifierArray[i];
            if (!blArray[i]) {
                Citation citation = object2.getAuthority();
                object = (Boolean)hashMap.get(citation);
                if (object == null) {
                    hashMap.put(citation, Boolean.FALSE);
                } else {
                    if (!((Boolean)object).equals(Boolean.FALSE)) continue;
                    for (int j = 0; j < n; ++j) {
                        if (!citation.equals(namedIdentifierArray[j].getAuthority())) continue;
                        System.arraycopy(namedIdentifierArray, j + 1, namedIdentifierArray, j, --n - j);
                    }
                    continue;
                }
            }
            namedIdentifierArray[n++] = object2;
        }
        namedIdentifierArray = (NamedIdentifier[])XArrays.resize((Object[])namedIdentifierArray, (int)n);
        if (bl && (d == null || d.isNaN())) {
            d = 0.0;
        }
        return new DefaultParameterDescriptor<Double>(Identifiers.toMap((ReferenceIdentifier[])namedIdentifierArray), Double.class, null, d, this.getMinimumValue(), this.getMaximumValue(), this.getUnit(), bl);
    }

    public ParameterDescriptor<?> find(Collection<GeneralParameterDescriptor> collection) {
        for (GeneralParameterDescriptor generalParameterDescriptor : collection) {
            ReferenceIdentifier referenceIdentifier = generalParameterDescriptor.getName();
            NamedIdentifier namedIdentifier = this.identifiers.get(referenceIdentifier.getCode());
            if (namedIdentifier == null || !Citations.identifierMatches((Citation)referenceIdentifier.getAuthority(), (Citation)namedIdentifier.getAuthority()) || !(generalParameterDescriptor instanceof ParameterDescriptor)) continue;
            return (ParameterDescriptor)generalParameterDescriptor;
        }
        return null;
    }

    public static ParameterDescriptor<Double> createDescriptor(ReferenceIdentifier[] referenceIdentifierArray, double d, double d2, double d3, Unit<?> unit) {
        return DefaultParameterDescriptor.create(Identifiers.toMap(referenceIdentifierArray), d, d2, d3, unit, true);
    }

    public static ParameterDescriptor<Double> createOptionalDescriptor(ReferenceIdentifier[] referenceIdentifierArray, double d, double d2, double d3, Unit<?> unit) {
        return DefaultParameterDescriptor.create(Identifiers.toMap(referenceIdentifierArray), d, d2, d3, unit, false);
    }

    public static ParameterDescriptorGroup createDescriptorGroup(ReferenceIdentifier[] referenceIdentifierArray, GeneralParameterDescriptor[] generalParameterDescriptorArray) {
        return new DefaultParameterDescriptorGroup(Identifiers.toMap(referenceIdentifierArray), generalParameterDescriptorArray);
    }

    private static Map<String, Object> toMap(ReferenceIdentifier[] referenceIdentifierArray) {
        if (referenceIdentifierArray == null) {
            throw new NullArgumentException("identifiers");
        }
        if (referenceIdentifierArray.length == 0) {
            throw new IllegalArgumentException(Errors.format((int)58));
        }
        int n = 0;
        int n2 = 0;
        Object[] objectArray = new ReferenceIdentifier[referenceIdentifierArray.length];
        Object[] objectArray2 = new GenericName[referenceIdentifierArray.length];
        for (ReferenceIdentifier referenceIdentifier : referenceIdentifierArray) {
            if (referenceIdentifier instanceof GenericName) {
                objectArray2[n2++] = (GenericName)referenceIdentifier;
                continue;
            }
            objectArray[n++] = referenceIdentifier;
        }
        objectArray = (ReferenceIdentifier[])XArrays.resize((Object[])objectArray, (int)n);
        objectArray2 = (GenericName[])XArrays.resize((Object[])objectArray2, (int)n2);
        HashMap hashMap = new HashMap(4);
        hashMap.put("name", referenceIdentifierArray[0]);
        hashMap.put("identifiers", objectArray);
        hashMap.put("alias", objectArray2);
        return hashMap;
    }

    static {
        NamedIdentifier namedIdentifier = new NamedIdentifier(Citations.ESRI, "Standard_Parallel_1");
        NamedIdentifier namedIdentifier2 = new NamedIdentifier(EPSG, "Latitude of 1st standard parallel");
        LATITUDE_OF_ORIGIN = new Identifiers(new NamedIdentifier[]{new NamedIdentifier(OGC, "latitude_of_origin"), new NamedIdentifier(Citations.ESRI, "Latitude_Of_Origin"), new NamedIdentifier(OGC, "latitude_of_center"), new NamedIdentifier(Citations.ESRI, "Latitude_Of_Center"), namedIdentifier, new NamedIdentifier(EPSG, "Latitude of false origin"), new NamedIdentifier(EPSG, "Latitude of natural origin"), new NamedIdentifier(EPSG, "Spherical latitude of origin"), new NamedIdentifier(EPSG, "Latitude of projection centre"), namedIdentifier2, new NamedIdentifier(GEOTIFF, "NatOriginLat"), new NamedIdentifier(GEOTIFF, "FalseOriginLat"), new NamedIdentifier(GEOTIFF, "ProjCenterLat"), new NamedIdentifier(GEOTIFF, "CenterLat")}, 0.0, -90.0, 90.0, NonSI.DEGREE_ANGLE, true);
        STANDARD_PARALLEL_1 = new Identifiers(new NamedIdentifier[]{new NamedIdentifier(OGC, "standard_parallel_1"), new NamedIdentifier(OGC, "pseudo_standard_parallel_1"), new NamedIdentifier(Citations.ESRI, "Pseudo_Standard_Parallel_1"), namedIdentifier, new NamedIdentifier(EPSG, "Latitude of standard parallel"), namedIdentifier2, new NamedIdentifier(EPSG, "Latitude of pseudo standard parallel"), new NamedIdentifier(GEOTIFF, "StdParallel1")}, Double.NaN, -90.0, 90.0, NonSI.DEGREE_ANGLE, false);
        STANDARD_PARALLEL_2 = new Identifiers(new NamedIdentifier[]{new NamedIdentifier(OGC, "standard_parallel_2"), new NamedIdentifier(Citations.ESRI, "Standard_Parallel_2"), new NamedIdentifier(EPSG, "Latitude of 2nd standard parallel"), new NamedIdentifier(GEOTIFF, "StdParallel2")}, Double.NaN, -90.0, 90.0, NonSI.DEGREE_ANGLE, false);
        LAT_OF_1ST_POINT = new Identifiers(new NamedIdentifier[]{new NamedIdentifier(Citations.ESRI, "Latitude_Of_1st_Point")}, Double.NaN, -90.0, 90.0, NonSI.DEGREE_ANGLE, true);
        LONG_OF_1ST_POINT = new Identifiers(new NamedIdentifier[]{new NamedIdentifier(Citations.ESRI, "Longitude_Of_1st_Point")}, Double.NaN, -180.0, 180.0, NonSI.DEGREE_ANGLE, true);
        LAT_OF_2ND_POINT = new Identifiers(new NamedIdentifier[]{new NamedIdentifier(Citations.ESRI, "Latitude_Of_2nd_Point")}, Double.NaN, -90.0, 90.0, NonSI.DEGREE_ANGLE, true);
        LONG_OF_2ND_POINT = new Identifiers(new NamedIdentifier[]{new NamedIdentifier(Citations.ESRI, "Longitude_Of_2nd_Point")}, Double.NaN, -180.0, 180.0, NonSI.DEGREE_ANGLE, true);
        AZIMUTH = new Identifiers(new NamedIdentifier[]{new NamedIdentifier(OGC, "azimuth"), new NamedIdentifier(Citations.ESRI, "Azimuth"), new NamedIdentifier(EPSG, "Azimuth of initial line"), new NamedIdentifier(GEOTIFF, "AzimuthAngle")}, Double.NaN, -360.0, 360.0, NonSI.DEGREE_ANGLE, true);
        RECTIFIED_GRID_ANGLE = new Identifiers(new NamedIdentifier[]{new NamedIdentifier(Citations.OGC, "rectified_grid_angle"), new NamedIdentifier(Citations.EPSG, "Angle from Rectified to Skew Grid"), new NamedIdentifier(Citations.ESRI, "XY_Plane_Rotation"), new NamedIdentifier(Citations.GEOTIFF, "RectifiedGridAngle")}, Double.NaN, -360.0, 360.0, NonSI.DEGREE_ANGLE, false);
        SCALE_FACTOR = new Identifiers(new NamedIdentifier[]{new NamedIdentifier(OGC, "scale_factor"), new NamedIdentifier(Citations.ESRI, "Scale_Factor"), new NamedIdentifier(EPSG, "Scale factor at natural origin"), new NamedIdentifier(EPSG, "Scale factor on initial line"), new NamedIdentifier(EPSG, "Scale factor on pseudo standard parallel"), new NamedIdentifier(GEOTIFF, "ScaleAtNatOrigin"), new NamedIdentifier(GEOTIFF, "ScaleAtCenter")}, 1.0, 0.0, Double.POSITIVE_INFINITY, Unit.ONE, true);
        FALSE_EASTING = new Identifiers(new NamedIdentifier[]{new NamedIdentifier(OGC, "false_easting"), new NamedIdentifier(Citations.ESRI, "False_Easting"), new NamedIdentifier(EPSG, "False easting"), new NamedIdentifier(EPSG, "Easting at false origin"), new NamedIdentifier(EPSG, "Easting at projection centre"), new NamedIdentifier(GEOTIFF, "FalseEasting"), new NamedIdentifier(GEOTIFF, "FalseOriginEasting")}, 0.0, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, (Unit<?>)SI.METRE, true);
        FALSE_NORTHING = new Identifiers(new NamedIdentifier[]{new NamedIdentifier(OGC, "false_northing"), new NamedIdentifier(Citations.ESRI, "False_Northing"), new NamedIdentifier(EPSG, "False northing"), new NamedIdentifier(EPSG, "Northing at false origin"), new NamedIdentifier(EPSG, "Northing at projection centre"), new NamedIdentifier(GEOTIFF, "FalseNorthing"), new NamedIdentifier(GEOTIFF, "FalseOriginNorthing")}, 0.0, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, (Unit<?>)SI.METRE, true);
    }
}

