/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.internal.referencing;

import java.awt.geom.AffineTransform;
import javax.vecmath.MismatchedSizeException;
import javax.vecmath.SingularMatrixException;
import org.geotoolkit.lang.Static;
import org.geotoolkit.referencing.operation.matrix.AffineMatrix3;
import org.geotoolkit.referencing.operation.matrix.GeneralMatrix;
import org.geotoolkit.referencing.operation.matrix.Matrix3;
import org.geotoolkit.referencing.operation.matrix.MatrixFactory;
import org.geotoolkit.referencing.operation.matrix.XMatrix;
import org.geotoolkit.referencing.operation.transform.LinearTransform;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.Cloneable;
import org.geotoolkit.util.ComparisonMode;
import org.geotoolkit.util.Utilities;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.NoninvertibleTransformException;

public final class MatrixUtilities
extends Static {
    private MatrixUtilities() {
    }

    public static Matrix forDimensions(MathTransform mathTransform, int n, int n2) {
        Matrix matrix;
        if (mathTransform instanceof LinearTransform && (matrix = MatrixFactory.getMatrix(mathTransform)) != null && MatrixUtilities.isAffine(matrix)) {
            int n3 = matrix.getNumCol() - 1;
            int n4 = matrix.getNumRow() - 1;
            if (n3 != n && n4 != n2) {
                XMatrix xMatrix = MatrixFactory.create(n2 + 1, n + 1);
                int n5 = Math.min(n2, n4);
                int n6 = Math.min(n, n3);
                for (int i = 0; i < n5; ++i) {
                    if (i >= n6 && i < n2) {
                        xMatrix.setElement(i, i, 0.0);
                    }
                    for (int j = 0; j < n6; ++j) {
                        xMatrix.setElement(i, j, matrix.getElement(i, j));
                    }
                    xMatrix.setElement(i, n, matrix.getElement(i, n3));
                }
                matrix = xMatrix;
            }
            return matrix;
        }
        return null;
    }

    public static AffineTransform toAffineTransform(Matrix matrix) throws IllegalStateException {
        Matrix3 matrix3;
        if (matrix instanceof AffineTransform) {
            return (AffineTransform)matrix;
        }
        if (matrix instanceof Matrix3) {
            matrix3 = (Matrix3)matrix;
        } else {
            if (matrix instanceof GeneralMatrix) {
                return ((GeneralMatrix)matrix).toAffineTransform2D();
            }
            matrix3 = new Matrix3(matrix);
        }
        return matrix3.toAffineTransform();
    }

    private static AffineMatrix3 toAffineMatrix3(Matrix matrix) throws IllegalStateException {
        AffineTransform affineTransform = MatrixUtilities.toAffineTransform(matrix);
        return affineTransform instanceof AffineMatrix3 ? (AffineMatrix3)affineTransform : new AffineMatrix3(affineTransform);
    }

    private static boolean isAffine2D(Matrix matrix) {
        return matrix.getNumRow() == 3 && matrix.getNumCol() == 3 && MatrixUtilities.isAffine(matrix);
    }

    public static boolean isAffine(Matrix matrix) {
        if (matrix instanceof AffineTransform) {
            return true;
        }
        if (matrix instanceof XMatrix) {
            return ((XMatrix)matrix).isAffine();
        }
        double d = 1.0;
        int n = matrix.getNumRow() - 1;
        int n2 = matrix.getNumCol();
        while (--n2 >= 0) {
            if (matrix.getElement(n, n2) != d) {
                return false;
            }
            d = 0.0;
        }
        return true;
    }

    public static void reverseAxis(Matrix matrix, int n, double d) {
        int n2 = matrix.getNumRow();
        int n3 = matrix.getNumCol() - 1;
        for (int i = 0; i < n2; ++i) {
            double d2 = matrix.getElement(i, n);
            matrix.setElement(i, n, -d2);
            matrix.setElement(i, n3, matrix.getElement(i, n3) + d2 * d);
        }
    }

    public static Matrix invert(Matrix matrix) throws NoninvertibleTransformException {
        int n;
        int n2 = matrix.getNumRow();
        if (n2 < (n = matrix.getNumCol())) {
            int n3;
            int n4 = n - n2;
            int[] nArray = new int[n4];
            int n5 = n;
            block0: while (--n5 >= 0) {
                n3 = n2;
                while (--n3 >= 0) {
                    if (matrix.getElement(n3, n5) == 0.0) continue;
                    continue block0;
                }
                nArray[--n4] = n5;
                if (n4 != 0) continue;
            }
            if (n4 == 0) {
                int n6;
                int n7;
                XMatrix xMatrix = MatrixFactory.create(n2);
                n3 = 0;
                for (n7 = 0; n7 < n; ++n7) {
                    if (n4 != nArray.length && n7 == nArray[n4]) {
                        ++n4;
                        continue;
                    }
                    n6 = n2;
                    while (--n6 >= 0) {
                        xMatrix.setElement(n6, n3, matrix.getElement(n6, n7));
                    }
                    ++n3;
                }
                xMatrix = MatrixUtilities.invertSquare(xMatrix);
                XMatrix xMatrix2 = MatrixFactory.create(n, n2);
                n4 = 0;
                n7 = 0;
                for (n6 = 0; n6 < n; ++n6) {
                    if (n4 != nArray.length && n6 == nArray[n4]) {
                        if (n6 < n2) {
                            xMatrix2.setElement(n6, n6, 0.0);
                        }
                        xMatrix2.setElement(n6, n2 - 1, Double.NaN);
                        ++n4;
                        continue;
                    }
                    int n8 = n2;
                    while (--n8 >= 0) {
                        xMatrix2.setElement(n6, n8, xMatrix.getElement(n7, n8));
                    }
                    ++n7;
                }
                return xMatrix2;
            }
        }
        return MatrixUtilities.invertSquare(matrix);
    }

    public static Matrix invertSquare(Matrix matrix) throws NoninvertibleTransformException {
        Cloneable cloneable;
        int n;
        int n2 = 0;
        int[] nArray = null;
        int n3 = matrix.getNumCol() - 1;
        int n4 = matrix.getNumRow() - 1;
        if (MatrixUtilities.isAffine(matrix)) {
            int n5;
            int n6;
            int n7 = n4;
            block5: while (--n7 >= 0) {
                for (n6 = n3; n6 >= 0; --n6) {
                    if (!Double.isNaN(matrix.getElement(n7, n6))) continue;
                    n5 = -1;
                    if (n6 != n3) {
                        n5 = n6;
                        n = n4;
                        while (--n >= 0) {
                            if (n == n7 || matrix.getElement(n, n6) == 0.0) continue;
                            nArray = null;
                            n2 = 0;
                            break block5;
                        }
                    }
                    n = n3;
                    while (--n >= 0) {
                        if (n == n6 || matrix.getElement(n7, n) == 0.0) continue;
                        if (n5 >= 0) {
                            nArray = null;
                            n2 = 0;
                            break block5;
                        }
                        n5 = n;
                    }
                    if (nArray == null) {
                        nArray = new int[n4 * 6];
                    }
                    nArray[n2++] = n6;
                    nArray[n2++] = n7;
                    nArray[n2++] = n5;
                }
            }
            for (n7 = 0; n7 < n2; n7 += 3) {
                n6 = nArray[n7];
                n5 = nArray[n7 + 1];
                matrix.setElement(n5, n6, n6 == n3 ? 0.0 : 1.0);
            }
        }
        Throwable throwable = null;
        if (MatrixUtilities.isAffine2D(matrix)) {
            cloneable = MatrixUtilities.toAffineMatrix3(matrix);
            try {
                cloneable.invert();
                matrix = cloneable;
            }
            catch (java.awt.geom.NoninvertibleTransformException noninvertibleTransformException) {
                throwable = noninvertibleTransformException;
            }
        } else {
            cloneable = MatrixFactory.toOptimalMatrix(matrix);
            try {
                cloneable.invert();
                matrix = cloneable;
            }
            catch (SingularMatrixException singularMatrixException) {
                throwable = singularMatrixException;
            }
            catch (MismatchedSizeException mismatchedSizeException) {
                throwable = mismatchedSizeException;
            }
        }
        if (throwable != null) {
            throw new NoninvertibleTransformException(Errors.format((int)126), throwable);
        }
        int n8 = 0;
        while (n8 < n2) {
            void var7_15 = nArray[n8++];
            n = nArray[n8++];
            int n9 = nArray[n8++];
            if (var7_15 != n3) {
                matrix.setElement((int)var7_15, n, Double.NaN);
                if (matrix.getElement((int)var7_15, n4) == 0.0) continue;
                matrix.setElement((int)var7_15, n4, Double.NaN);
                continue;
            }
            if (n9 < 0) continue;
            matrix.setElement(n9, n4, Double.NaN);
        }
        return matrix;
    }

    public static Matrix multiply(Matrix matrix, Matrix matrix2) {
        int n = matrix.getNumRow();
        int n2 = matrix2.getNumCol();
        if (n2 == matrix.getNumCol()) {
            if (MatrixUtilities.isAffine2D(matrix) && MatrixUtilities.isAffine2D(matrix2)) {
                AffineMatrix3 affineMatrix3 = MatrixUtilities.toAffineMatrix3(matrix);
                affineMatrix3.concatenate(MatrixUtilities.toAffineTransform(matrix2));
                return affineMatrix3;
            }
            XMatrix xMatrix = MatrixFactory.toOptimalMatrix(matrix);
            xMatrix.multiply(matrix2);
            return xMatrix;
        }
        GeneralMatrix generalMatrix = new GeneralMatrix(n, n2);
        generalMatrix.mul(MatrixFactory.toGeneralMatrix(matrix), MatrixFactory.toGeneralMatrix(matrix2));
        return generalMatrix;
    }

    public static boolean epsilonEqual(Matrix matrix, Matrix matrix2, double d, boolean bl) {
        int n = matrix.getNumRow();
        if (n != matrix2.getNumRow()) {
            return false;
        }
        int n2 = matrix.getNumCol();
        if (n2 != matrix2.getNumCol()) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                double d2 = matrix.getElement(i, j);
                double d3 = matrix2.getElement(i, j);
                double d4 = d;
                if (bl) {
                    d4 *= Math.max(Math.abs(d2), Math.abs(d3));
                }
                if (Math.abs(d2 - d3) <= d4 || Utilities.equals((double)d2, (double)d3)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean equals(Matrix matrix, Object object, ComparisonMode comparisonMode) {
        switch (comparisonMode) {
            case STRICT: {
                return Utilities.equals((Object)matrix, (Object)object);
            }
            case BY_CONTRACT: 
            case IGNORE_METADATA: {
                return object instanceof Matrix && MatrixUtilities.epsilonEqual(matrix, (Matrix)object, 0.0, false);
            }
            case APPROXIMATIVE: {
                return object instanceof Matrix && MatrixUtilities.epsilonEqual(matrix, (Matrix)object, 1.0E-14, true);
            }
        }
        throw new IllegalArgumentException(Errors.format((int)260, (Object)comparisonMode));
    }
}

