/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.io.wkt;

import java.lang.reflect.Array;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.util.Collection;
import java.util.Locale;
import java.util.Set;
import javax.measure.quantity.Angle;
import javax.measure.quantity.Length;
import javax.measure.unit.NonSI;
import javax.measure.unit.SI;
import javax.measure.unit.Unit;
import javax.measure.unit.UnitFormat;
import org.geotoolkit.io.X364;
import org.geotoolkit.io.wkt.Colors;
import org.geotoolkit.io.wkt.Formattable;
import org.geotoolkit.io.wkt.FormattableObject;
import org.geotoolkit.io.wkt.Symbols;
import org.geotoolkit.io.wkt.UnformattableObjectException;
import org.geotoolkit.math.XMath;
import org.geotoolkit.measure.Units;
import org.geotoolkit.metadata.iso.citation.Citations;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.NullArgumentException;
import org.geotoolkit.util.Strings;
import org.geotoolkit.util.converter.Numbers;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.citation.Citation;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterValue;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.util.CodeList;
import org.opengis.util.GenericName;

public class Formatter {
    private static final Class<? extends IdentifiedObject>[] AUTHORITY_EXCLUDES = new Class[]{CoordinateSystemAxis.class};
    private static final Citation[] US_UNIT_NAMES = new Citation[]{Citations.ESRI, Citations.ORACLE};
    private final Symbols symbols;
    Colors colors;
    Citation authority = FormattableObject.OGC;
    private Unit<Length> linearUnit;
    private Unit<Angle> angularUnit;
    private final NumberFormat numberFormat;
    private final UnitFormat unitFormat;
    private final FieldPosition dummy = new FieldPosition(0);
    StringBuffer buffer;
    int bufferBase;
    int indentation;
    private int margin;
    private final String lineSeparator = System.getProperty("line.separator", "\n");
    private boolean lineChanged;
    private boolean invalidWKT;
    private Class<?> unformattable;
    String warning;

    public Formatter() {
        this(Symbols.DEFAULT, null, 0);
    }

    public Formatter(Symbols symbols, Colors colors, int n) {
        if (symbols == null) {
            throw new NullArgumentException(Errors.format((int)172, (Object)"symbols"));
        }
        if (n < 0) {
            throw new IllegalArgumentException(Errors.format((int)73, (Object)"indentation", (Object)n));
        }
        this.symbols = symbols;
        this.colors = colors;
        this.indentation = n;
        this.numberFormat = (NumberFormat)symbols.numberFormat.clone();
        this.unitFormat = UnitFormat.getInstance((Locale)symbols.locale);
        this.buffer = new StringBuffer();
    }

    Formatter(Symbols symbols, NumberFormat numberFormat) {
        this.symbols = symbols;
        this.indentation = FormattableObject.getDefaultIndentation();
        this.numberFormat = numberFormat;
        this.unitFormat = UnitFormat.getInstance((Locale)symbols.locale);
    }

    private void setColor(Colors.Element element) {
        X364 x364;
        if (this.colors != null && (x364 = this.colors.get(element)) != null) {
            this.buffer.append(x364.sequence());
        }
    }

    private void resetColor() {
        if (this.colors != null) {
            this.buffer.append(X364.FOREGROUND_DEFAULT.sequence());
        }
    }

    private static Colors.Element getNameColor(IdentifiedObject identifiedObject) {
        if (identifiedObject instanceof Datum) {
            return Colors.Element.DATUM;
        }
        if (identifiedObject instanceof OperationMethod) {
            return Colors.Element.METHOD;
        }
        if (identifiedObject instanceof CoordinateSystemAxis) {
            return Colors.Element.AXIS;
        }
        return null;
    }

    private void appendSeparator(boolean bl) {
        char c;
        Symbols symbols = this.symbols;
        StringBuffer stringBuffer = this.buffer;
        int n = stringBuffer.length();
        do {
            if (n == this.bufferBase) {
                return;
            }
            if ((c = stringBuffer.charAt(--n)) != symbols.open && c != symbols.openArray) continue;
            return;
        } while (Character.isWhitespace(c) || c == symbols.space);
        stringBuffer.append(symbols.separator).append(symbols.space);
        if (bl && this.indentation > 0) {
            stringBuffer.append(this.lineSeparator).append(Strings.spaces((int)this.margin));
            this.lineChanged = true;
        }
    }

    public void append(Formattable formattable) {
        String string;
        String string2;
        Identifier identifier;
        Object object;
        IdentifiedObject identifiedObject;
        Symbols symbols = this.symbols;
        StringBuffer stringBuffer = this.buffer;
        this.appendSeparator(true);
        int n = stringBuffer.length();
        stringBuffer.append(symbols.open);
        IdentifiedObject identifiedObject2 = identifiedObject = formattable instanceof IdentifiedObject ? (IdentifiedObject)formattable : null;
        if (identifiedObject != null) {
            object = Formatter.getNameColor(identifiedObject);
            if (object != null) {
                this.setColor((Colors.Element)((Object)object));
            }
            stringBuffer.append(symbols.quote).append(this.getName(identifiedObject)).append(symbols.quote);
            if (object != null) {
                this.resetColor();
            }
        }
        this.indent(1);
        this.lineChanged = false;
        object = formattable.formatWKT(this);
        if (this.colors != null && this.invalidWKT) {
            this.invalidWKT = false;
            identifier = this.colors.get(Colors.Element.ERROR);
            if (identifier != null) {
                string2 = identifier.sequence();
                stringBuffer.insert(n, string2 + X364.BACKGROUND_DEFAULT.sequence());
                n += string2.length();
            }
        }
        stringBuffer.insert(n, (String)object);
        identifier = this.getIdentifier(identifiedObject);
        if (identifier != null && Formatter.isAuthorityAllowed(identifiedObject) && (string2 = identifier.getAuthority()) != null && (string = Citations.getIdentifier((Citation)string2)) != null) {
            this.appendSeparator(this.lineChanged);
            stringBuffer.append("AUTHORITY").append(symbols.open).append(symbols.quote).append(string).append(symbols.quote);
            String string3 = identifier.getCode();
            if (string3 != null) {
                stringBuffer.append(symbols.separator).append(symbols.quote).append(string3).append(symbols.quote);
            }
            stringBuffer.append(symbols.close);
        }
        stringBuffer.append(symbols.close);
        this.lineChanged = true;
        this.indent(-1);
    }

    public void append(IdentifiedObject identifiedObject) {
        if (!(identifiedObject instanceof Formattable)) {
            throw Formatter.unsupported(identifiedObject);
        }
        this.append((Formattable)identifiedObject);
    }

    public void append(MathTransform mathTransform) {
        if (!(mathTransform instanceof Formattable)) {
            throw Formatter.unsupported(mathTransform);
        }
        this.append((Formattable)mathTransform);
    }

    private static UnformattableObjectException unsupported(Object object) {
        Class<?> clazz = object.getClass();
        return new UnformattableObjectException(Errors.format((int)76, clazz, Formattable.class), clazz);
    }

    public void append(CodeList<?> codeList) {
        if (codeList != null) {
            this.appendSeparator(false);
            this.setColor(Colors.Element.CODE_LIST);
            String string = codeList.name();
            boolean bl = string.indexOf(32) >= 0;
            Symbols symbols = this.symbols;
            StringBuffer stringBuffer = this.buffer;
            if (bl) {
                stringBuffer.append(symbols.quote);
            }
            stringBuffer.append(string);
            if (bl) {
                stringBuffer.append(symbols.quote);
                this.setInvalidWKT(codeList.getClass());
            }
            this.resetColor();
        }
    }

    public void append(GeneralParameterValue generalParameterValue) {
        if (generalParameterValue instanceof ParameterValueGroup) {
            for (ParameterDescriptor parameterDescriptor : ((ParameterValueGroup)generalParameterValue).values()) {
                this.append((GeneralParameterValue)parameterDescriptor);
            }
        }
        if (generalParameterValue instanceof ParameterValue) {
            ParameterDescriptor parameterDescriptor;
            ParameterValue parameterValue = (ParameterValue)generalParameterValue;
            parameterDescriptor = parameterValue.getDescriptor();
            Unit<Length> unit = parameterDescriptor.getUnit();
            Unit<Length> unit2 = unit;
            if (unit2 != null && !Unit.ONE.equals((Object)unit2)) {
                if (this.linearUnit != null && unit2.isCompatible(this.linearUnit)) {
                    unit2 = this.linearUnit;
                } else if (this.angularUnit != null && unit2.isCompatible(this.angularUnit)) {
                    unit2 = this.angularUnit;
                }
            }
            this.appendSeparator(true);
            Symbols symbols = this.symbols;
            StringBuffer stringBuffer = this.buffer;
            int n = stringBuffer.length();
            stringBuffer.append("PARAMETER");
            int n2 = stringBuffer.length();
            stringBuffer.append(symbols.open);
            this.setColor(Colors.Element.PARAMETER);
            stringBuffer.append(symbols.quote).append(this.getName((IdentifiedObject)parameterDescriptor)).append(symbols.quote);
            this.resetColor();
            stringBuffer.append(symbols.separator).append(symbols.space);
            if (unit2 != null) {
                double d;
                try {
                    d = parameterValue.doubleValue(unit2);
                }
                catch (IllegalStateException illegalStateException) {
                    X364 x364;
                    if (this.colors != null && (x364 = this.colors.get(Colors.Element.ERROR)) != null) {
                        stringBuffer.insert(n2, X364.BACKGROUND_DEFAULT.sequence()).insert(n, x364.sequence());
                    }
                    this.warning = illegalStateException.getLocalizedMessage();
                    d = Double.NaN;
                }
                if (!unit2.equals(unit)) {
                    d = XMath.trimDecimalFractionDigits((double)d, (int)4, (int)9);
                }
                this.format(d);
            } else {
                this.appendObject(parameterValue.getValue());
            }
            stringBuffer.append(symbols.close);
        }
    }

    private void appendObject(Object object) {
        StringBuffer stringBuffer = this.buffer;
        if (object == null) {
            stringBuffer.append("null");
            return;
        }
        Symbols symbols = this.symbols;
        if (object.getClass().isArray()) {
            stringBuffer.append(symbols.openArray);
            int n = Array.getLength(object);
            for (int i = 0; i < n; ++i) {
                if (i != 0) {
                    stringBuffer.append(symbols.separator).append(symbols.space);
                }
                this.appendObject(Array.get(object, i));
            }
            stringBuffer.append(symbols.closeArray);
            return;
        }
        if (object instanceof Number) {
            this.format((Number)object);
        } else if (object instanceof Boolean) {
            stringBuffer.append((Boolean)object != false ? "TRUE" : "FALSE");
        } else {
            stringBuffer.append(symbols.quote).append(object).append(symbols.quote);
        }
    }

    public void append(long l) {
        this.appendSeparator(false);
        this.format(l);
    }

    public void append(double d) {
        this.appendSeparator(false);
        this.format(d);
    }

    public void append(Unit<?> unit) {
        if (unit != null) {
            StringBuffer stringBuffer = this.buffer;
            Symbols symbols = this.symbols;
            this.appendSeparator(this.lineChanged);
            stringBuffer.append("UNIT").append(symbols.open);
            this.setColor(Colors.Element.UNIT);
            stringBuffer.append(symbols.quote);
            if (NonSI.DEGREE_ANGLE.equals(unit)) {
                stringBuffer.append("degree");
            } else if (SI.METRE.equals(unit)) {
                Citation citation = this.getEffectiveAuthority();
                String string = "metre";
                for (int i = 0; i < US_UNIT_NAMES.length; ++i) {
                    if (!Citations.identifierMatches((Citation)US_UNIT_NAMES[i], (Citation)citation)) continue;
                    string = "meter";
                    break;
                }
                stringBuffer.append(string);
            } else {
                this.unitFormat.format(unit, stringBuffer, this.dummy);
            }
            stringBuffer.append(symbols.quote);
            this.resetColor();
            this.append(Units.toStandardUnit(unit));
            stringBuffer.append(symbols.close);
        }
    }

    public void append(String string) {
        this.appendSeparator(false);
        this.buffer.append(this.symbols.quote).append(string).append(this.symbols.quote);
    }

    private void format(Number number) {
        if (Numbers.isInteger(number.getClass())) {
            this.format(number.longValue());
        } else {
            this.format(number.doubleValue());
        }
    }

    private void format(long l) {
        this.setColor(Colors.Element.INTEGER);
        NumberFormat numberFormat = this.numberFormat;
        int n = numberFormat.getMinimumFractionDigits();
        numberFormat.setMinimumFractionDigits(0);
        numberFormat.format(l, this.buffer, this.dummy);
        numberFormat.setMinimumFractionDigits(n);
        this.resetColor();
    }

    private void format(double d) {
        double d2 = d * 1000.0;
        d2 = XMath.roundIfAlmostInteger((double)(d * 1000.0), (int)4);
        if (d2 != d2) {
            d = d2 / 1000.0;
        }
        this.setColor(Colors.Element.NUMBER);
        this.numberFormat.format(d, this.buffer, this.dummy);
        this.resetColor();
    }

    private void indent(int n) {
        this.margin = Math.max(0, this.margin + this.indentation * n);
    }

    private static boolean isAuthorityAllowed(IdentifiedObject identifiedObject) {
        for (int i = 0; i < AUTHORITY_EXCLUDES.length; ++i) {
            if (!AUTHORITY_EXCLUDES[i].isInstance(identifiedObject)) continue;
            return false;
        }
        return true;
    }

    public Identifier getIdentifier(IdentifiedObject identifiedObject) {
        Identifier identifier = null;
        if (identifiedObject != null) {
            Citation citation = this.getEffectiveAuthority();
            Set set = identifiedObject.getIdentifiers();
            if (set != null) {
                for (Identifier identifier2 : set) {
                    if (Formatter.authorityMatches(citation, identifier2.getAuthority())) {
                        return identifier2;
                    }
                    if (identifier != null) continue;
                    identifier = identifier2;
                }
            }
        }
        return identifier;
    }

    private static boolean authorityMatches(Citation citation, Citation citation2) {
        if (citation == citation2) {
            return true;
        }
        return citation2 != null && citation.getTitle().toString(null).equalsIgnoreCase(citation2.getTitle().toString(null));
    }

    public String getName(IdentifiedObject identifiedObject) {
        Collection collection;
        ReferenceIdentifier referenceIdentifier = identifiedObject.getName();
        if (referenceIdentifier == null) {
            return null;
        }
        Citation citation = this.getEffectiveAuthority();
        if (!Formatter.authorityMatches(citation, referenceIdentifier.getAuthority()) && (collection = identifiedObject.getAlias()) != null) {
            for (Object object : collection) {
                Identifier identifier;
                if (!(object instanceof Identifier) || !Formatter.authorityMatches(citation, (identifier = (Identifier)object).getAuthority())) continue;
                return identifier.getCode();
            }
            String string = citation.getTitle().toString(null);
            for (Identifier identifier : collection) {
                GenericName genericName = identifier.scope().name();
                if (genericName == null || !string.equalsIgnoreCase(genericName.toString())) continue;
                return identifier.tip().toString();
            }
        }
        return referenceIdentifier.getCode();
    }

    public Unit<Length> getLinearUnit() {
        return this.linearUnit;
    }

    public void setLinearUnit(Unit<Length> unit) {
        if (unit != null && !Units.isLinear(unit)) {
            throw new IllegalArgumentException(Errors.format((int)135, unit));
        }
        this.linearUnit = unit;
    }

    public Unit<Angle> getAngularUnit() {
        return this.angularUnit;
    }

    public void setAngularUnit(Unit<Angle> unit) {
        if (unit != null && !Units.isAngular(unit)) {
            throw new IllegalArgumentException(Errors.format((int)128, unit));
        }
        this.angularUnit = unit;
    }

    private Citation getEffectiveAuthority() {
        return this.isInternalWKT() ? FormattableObject.OGC : this.authority;
    }

    public boolean isInternalWKT() {
        return FormattableObject.INTERNAL.equals(this.authority);
    }

    public boolean isInvalidWKT() {
        return this.unformattable != null || this.buffer != null && this.buffer.length() == 0;
    }

    final Class<?> getUnformattableClass() {
        return this.unformattable;
    }

    public void setInvalidWKT(Class<?> clazz) {
        this.unformattable = clazz;
        this.invalidWKT = true;
    }

    public String toString() {
        return this.buffer.toString();
    }

    public void clear() {
        if (this.buffer != null) {
            this.buffer.setLength(0);
        }
        this.linearUnit = null;
        this.angularUnit = null;
        this.unformattable = null;
        this.warning = null;
        this.invalidWKT = false;
        this.lineChanged = false;
        this.margin = 0;
    }
}

