/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.io.wkt;

import java.io.BufferedReader;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import org.geotoolkit.io.ContentFormatException;
import org.geotoolkit.io.wkt.FormattableObject;
import org.geotoolkit.lang.Static;
import org.geotoolkit.referencing.CRS;
import org.geotoolkit.resources.Errors;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.util.FactoryException;

public final class PrjFiles
extends Static {
    private static final String ENCODING = "ISO-8859-1";

    private PrjFiles() {
    }

    public static CoordinateReferenceSystem read(File file) throws ContentFormatException, IOException {
        return PrjFiles.read(new FileInputStream(file), true);
    }

    public static CoordinateReferenceSystem read(URL uRL) throws ContentFormatException, IOException {
        return PrjFiles.read(uRL.openStream(), true);
    }

    public static CoordinateReferenceSystem read(ReadableByteChannel readableByteChannel, boolean bl) throws ContentFormatException, IOException {
        return PrjFiles.read(Channels.newInputStream(readableByteChannel), bl);
    }

    public static CoordinateReferenceSystem read(InputStream inputStream, boolean bl) throws ContentFormatException, IOException {
        return PrjFiles.read(new BufferedReader(new InputStreamReader(inputStream, ENCODING)), bl);
    }

    public static CoordinateReferenceSystem read(BufferedReader bufferedReader, boolean bl) throws ContentFormatException, IOException {
        String string;
        StringBuilder stringBuilder = null;
        String string2 = null;
        while ((string = bufferedReader.readLine()) != null) {
            if ((string = string.trim()).isEmpty()) continue;
            if (string2 == null) {
                string2 = string;
                continue;
            }
            if (stringBuilder == null) {
                stringBuilder = new StringBuilder(string2);
            }
            stringBuilder.append('\n').append(string);
        }
        if (bl) {
            bufferedReader.close();
        }
        if (stringBuilder != null) {
            string2 = stringBuilder.toString();
        }
        if (string2 == null) {
            throw new EOFException(Errors.format((int)61));
        }
        try {
            return CRS.parseWKT(string2);
        }
        catch (FactoryException factoryException) {
            throw new ContentFormatException(factoryException.getLocalizedMessage(), (Throwable)factoryException);
        }
    }

    private static String format(CoordinateReferenceSystem coordinateReferenceSystem) throws ContentFormatException {
        try {
            if (coordinateReferenceSystem instanceof FormattableObject) {
                return ((FormattableObject)coordinateReferenceSystem).toWKT(0);
            }
            return coordinateReferenceSystem.toWKT();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            throw new ContentFormatException(unsupportedOperationException.getLocalizedMessage(), (Throwable)unsupportedOperationException);
        }
    }

    public static void write(CoordinateReferenceSystem coordinateReferenceSystem, File file) throws ContentFormatException, IOException {
        String string = PrjFiles.format(coordinateReferenceSystem);
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(file), ENCODING);
        outputStreamWriter.write(string);
        ((Writer)outputStreamWriter).write(10);
        ((Writer)outputStreamWriter).close();
    }

    public static void write(CoordinateReferenceSystem coordinateReferenceSystem, WritableByteChannel writableByteChannel) throws ContentFormatException, IOException {
        PrjFiles.write(coordinateReferenceSystem, Channels.newOutputStream(writableByteChannel));
    }

    public static void write(CoordinateReferenceSystem coordinateReferenceSystem, OutputStream outputStream) throws ContentFormatException, IOException {
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, ENCODING);
        PrjFiles.write(coordinateReferenceSystem, outputStreamWriter);
        ((Writer)outputStreamWriter).flush();
    }

    public static void write(CoordinateReferenceSystem coordinateReferenceSystem, Writer writer) throws ContentFormatException, IOException {
        writer.write(PrjFiles.format(coordinateReferenceSystem));
        writer.write(10);
    }
}

