/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.io.wkt;

import java.text.ParseException;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.measure.quantity.Angle;
import javax.measure.quantity.Length;
import javax.measure.quantity.Quantity;
import javax.measure.unit.NonSI;
import javax.measure.unit.SI;
import javax.measure.unit.Unit;
import org.geotoolkit.factory.FactoryFinder;
import org.geotoolkit.factory.Hints;
import org.geotoolkit.internal.referencing.WktUtilities;
import org.geotoolkit.io.wkt.Element;
import org.geotoolkit.io.wkt.MathTransformParser;
import org.geotoolkit.io.wkt.Symbols;
import org.geotoolkit.measure.Units;
import org.geotoolkit.metadata.iso.citation.Citations;
import org.geotoolkit.referencing.NamedIdentifier;
import org.geotoolkit.referencing.cs.AbstractCS;
import org.geotoolkit.referencing.cs.DefaultCoordinateSystemAxis;
import org.geotoolkit.referencing.datum.BursaWolfParameters;
import org.geotoolkit.referencing.datum.DefaultGeodeticDatum;
import org.geotoolkit.referencing.datum.DefaultPrimeMeridian;
import org.geotoolkit.referencing.datum.DefaultVerticalDatum;
import org.geotoolkit.referencing.factory.ReferencingFactoryContainer;
import org.geotoolkit.referencing.operation.DefiningConversion;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.ArgumentChecks;
import org.geotoolkit.util.collection.XCollections;
import org.opengis.metadata.citation.Citation;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValue;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.crs.CRSFactory;
import org.opengis.referencing.crs.CompoundCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.DerivedCRS;
import org.opengis.referencing.crs.EngineeringCRS;
import org.opengis.referencing.crs.GeocentricCRS;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.crs.VerticalCRS;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CSFactory;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.datum.DatumFactory;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.datum.EngineeringDatum;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.datum.PrimeMeridian;
import org.opengis.referencing.datum.VerticalDatum;
import org.opengis.referencing.datum.VerticalDatumType;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.util.FactoryException;
import org.opengis.util.NoSuchIdentifierException;

public class ReferencingParser
extends MathTransformParser {
    private static final boolean ALLOW_ORACLE_SYNTAX = true;
    private final DatumFactory datumFactory;
    private final CSFactory csFactory;
    private final CRSFactory crsFactory;
    private boolean isoConform;
    private boolean axisIgnored;
    private final Map<String, AxisDirection> directions;
    private static Map<String, AxisDirection> lastDirections;

    public ReferencingParser() {
        this(Symbols.DEFAULT, (Hints)null);
    }

    public ReferencingParser(Symbols symbols, Hints hints) {
        this(symbols, FactoryFinder.getDatumFactory((Hints)hints), FactoryFinder.getCSFactory((Hints)hints), FactoryFinder.getCRSFactory((Hints)hints), FactoryFinder.getMathTransformFactory((Hints)hints));
    }

    public ReferencingParser(Symbols symbols, ReferencingFactoryContainer referencingFactoryContainer) {
        this(symbols, referencingFactoryContainer.getDatumFactory(), referencingFactoryContainer.getCSFactory(), referencingFactoryContainer.getCRSFactory(), referencingFactoryContainer.getMathTransformFactory());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReferencingParser(Symbols symbols, DatumFactory datumFactory, CSFactory cSFactory, CRSFactory cRSFactory, MathTransformFactory mathTransformFactory) {
        super(symbols, mathTransformFactory);
        this.datumFactory = datumFactory;
        this.csFactory = cSFactory;
        this.crsFactory = cRSFactory;
        ArgumentChecks.ensureNonNull((String)"datumFactory", (Object)datumFactory);
        ArgumentChecks.ensureNonNull((String)"csFactory", (Object)cSFactory);
        ArgumentChecks.ensureNonNull((String)"crsFactory", (Object)cRSFactory);
        AxisDirection[] axisDirectionArray = AxisDirection.values();
        Map<String, AxisDirection> map = new HashMap<String, AxisDirection>(XCollections.hashMapCapacity((int)axisDirectionArray.length));
        Locale locale = symbols.locale;
        for (int i = 0; i < axisDirectionArray.length; ++i) {
            map.put(axisDirectionArray[i].name().trim().toUpperCase(locale), axisDirectionArray[i]);
        }
        Class<ReferencingParser> clazz = ReferencingParser.class;
        synchronized (ReferencingParser.class) {
            Map<String, AxisDirection> map2 = lastDirections;
            if (((Object)map).equals(map2)) {
                map = map2;
            } else {
                lastDirections = map;
            }
            // ** MonitorExit[var9_10] (shouldn't be in output)
            this.directions = map;
            return;
        }
    }

    public boolean isISOConform() {
        return this.isoConform;
    }

    public void setISOConform(boolean bl) {
        this.isoConform = bl;
    }

    public boolean isAxisIgnored() {
        return this.axisIgnored;
    }

    public void setAxisIgnored(boolean bl) {
        this.axisIgnored = bl;
    }

    public final CoordinateReferenceSystem parseCoordinateReferenceSystem(String string) throws ParseException {
        Element element = this.getTree(string, new ParsePosition(0));
        CoordinateReferenceSystem coordinateReferenceSystem = this.parseCoordinateReferenceSystem(element);
        element.close();
        return coordinateReferenceSystem;
    }

    private CoordinateReferenceSystem parseCoordinateReferenceSystem(Element element) throws ParseException {
        Object object = element.peek();
        if (object instanceof Element) {
            String string = this.keyword((Element)object);
            switch (string.hashCode()) {
                case 2098816550: {
                    if (!"GEOGCS".equals(string)) break;
                    return this.parseGeoGCS(element);
                }
                case -1926479731: {
                    if (!"PROJCS".equals(string)) break;
                    return this.parseProjCS(element);
                }
                case 2098812706: {
                    if (!"GEOCCS".equals(string)) break;
                    return this.parseGeoCCS(element);
                }
                case 1069641278: {
                    if (!"VERT_CS".equals(string)) break;
                    return this.parseVertCS(element);
                }
                case -1611514396: {
                    if (!"LOCAL_CS".equals(string)) break;
                    return this.parseLocalCS(element);
                }
                case 182967770: {
                    if (!"COMPD_CS".equals(string)) break;
                    return this.parseCompdCS(element);
                }
                case 414930797: {
                    if (!"FITTED_CS".equals(string)) break;
                    return this.parseFittedCS(element);
                }
            }
        }
        throw element.parseFailed(null, Errors.format((int)226, (Object)object));
    }

    @Override
    Object parse(Element element) throws ParseException {
        Object object = element.peek();
        if (object instanceof Element) {
            String string = this.keyword((Element)object);
            switch (string.hashCode()) {
                case 2023329: {
                    if (!"AXIS".equals(string)) break;
                    return this.parseAxis(element, (Unit<?>)SI.METRE, true);
                }
                case -1926655538: {
                    if (!"PRIMEM".equals(string)) break;
                    return this.parsePrimem(element, (Unit<Angle>)NonSI.DEGREE_ANGLE);
                }
                case -414856156: {
                    if (!"TOWGS84".equals(string)) break;
                    return ReferencingParser.parseToWGS84(element);
                }
                case -1262236878: {
                    if (!"SPHEROID".equals(string)) break;
                    return this.parseSpheroid(element);
                }
                case 1321414593: {
                    if (!"VERT_DATUM".equals(string)) break;
                    return this.parseVertDatum(element);
                }
                case 519534171: {
                    if (!"LOCAL_DATUM".equals(string)) break;
                    return this.parseLocalDatum(element);
                }
                case 64819279: {
                    if (!"DATUM".equals(string)) break;
                    return this.parseDatum(element, DefaultPrimeMeridian.GREENWICH);
                }
                case 2098816550: {
                    if (!"GEOGCS".equals(string)) break;
                    return this.parseGeoGCS(element);
                }
                case -1926479731: {
                    if (!"PROJCS".equals(string)) break;
                    return this.parseProjCS(element);
                }
                case 2098812706: {
                    if (!"GEOCCS".equals(string)) break;
                    return this.parseGeoCCS(element);
                }
                case 1069641278: {
                    if (!"VERT_CS".equals(string)) break;
                    return this.parseVertCS(element);
                }
                case -1611514396: {
                    if (!"LOCAL_CS".equals(string)) break;
                    return this.parseLocalCS(element);
                }
                case 182967770: {
                    if (!"COMPD_CS".equals(string)) break;
                    return this.parseCompdCS(element);
                }
                case 414930797: {
                    if (!"FITTED_CS".equals(string)) break;
                    return this.parseFittedCS(element);
                }
                case 1954077369: {
                    if (!"PARAM_MT".equals(string)) break;
                    return this.parseParamMT(element);
                }
                case 1889286834: {
                    if (!"CONCAT_MT".equals(string)) break;
                    return this.parseConcatMT(element);
                }
                case -1910641354: {
                    if (!"INVERSE_MT".equals(string)) break;
                    return this.parseInverseMT(element);
                }
                case -219294638: {
                    if (!"PASSTHROUGH_MT".equals(string)) break;
                    return this.parsePassThroughMT(element);
                }
            }
        }
        throw element.parseFailed(null, Errors.format((int)226, (Object)object));
    }

    protected Map<String, Object> alterProperties(Map<String, Object> map) {
        return map;
    }

    private Map<String, Object> parseAuthority(Element element, String string) throws ParseException {
        Map<String, Object> map;
        boolean bl = element.isRoot();
        Element element2 = element.pullOptionalElement("AUTHORITY");
        if (element2 == null) {
            if (bl) {
                map = new HashMap<String, String>(4);
                map.put("name", string);
            } else {
                map = Collections.singletonMap("name", string);
            }
        } else {
            String string2 = element2.pullString("name");
            String string3 = element2.pullObject("code").toString();
            element2.close();
            Citation citation = Citations.fromName((String)string2);
            map = new HashMap<String, Object>(4);
            map.put("name", (Object)new NamedIdentifier(citation, string));
            map.put("identifiers", (Object)new NamedIdentifier(citation, string3));
        }
        if (bl) {
            map = this.alterProperties(map);
        }
        return map;
    }

    private <T extends Quantity> Unit<T> parseUnit(Element element, Unit<T> unit) throws ParseException {
        Element element2 = element.pullElement("UNIT");
        String string = element2.pullString("name");
        double d = element2.pullDouble("factor");
        Map<String, Object> map = this.parseAuthority(element2, string);
        element2.close();
        return Units.multiply(unit, (double)d);
    }

    private CoordinateSystemAxis parseAxis(Element element, Unit<?> unit, boolean bl) throws ParseException {
        Element element2;
        if (bl) {
            element2 = element.pullElement("AXIS");
        } else {
            element2 = element.pullOptionalElement("AXIS");
            if (element2 == null) {
                return null;
            }
        }
        String string = element2.pullString("name");
        Element element3 = element2.pullVoidElement("orientation");
        Map<String, Object> map = this.parseAuthority(element2, string);
        element2.close();
        AxisDirection axisDirection = this.directions.get(this.keyword(element3));
        if (axisDirection == null) {
            throw element2.parseFailed(null, Errors.format((int)226, (Object)element3));
        }
        try {
            return this.createAxis(map, string, axisDirection, unit);
        }
        catch (FactoryException factoryException) {
            throw element2.parseFailed((Exception)((Object)factoryException), null);
        }
    }

    private CoordinateSystemAxis createAxis(Map<String, ?> map, String string, AxisDirection axisDirection, Unit<?> unit) throws FactoryException {
        DefaultCoordinateSystemAxis defaultCoordinateSystemAxis = DefaultCoordinateSystemAxis.getPredefined(string, axisDirection);
        if (defaultCoordinateSystemAxis != null && unit.equals((Object)defaultCoordinateSystemAxis.getUnit())) {
            return defaultCoordinateSystemAxis;
        }
        if (map == null) {
            map = Collections.singletonMap("name", string);
        }
        return this.csFactory.createCoordinateSystemAxis(map, string, axisDirection, unit);
    }

    private PrimeMeridian parsePrimem(Element element, Unit<Angle> unit) throws ParseException {
        Element element2 = element.pullElement("PRIMEM");
        String string = element2.pullString("name");
        double d = element2.pullDouble("longitude");
        Map<String, Object> map = this.parseAuthority(element2, string);
        element2.close();
        try {
            return this.datumFactory.createPrimeMeridian(map, d, unit);
        }
        catch (FactoryException factoryException) {
            throw element2.parseFailed((Exception)((Object)factoryException), null);
        }
    }

    private static BursaWolfParameters parseToWGS84(Element element) throws ParseException {
        Element element2 = element.pullOptionalElement("TOWGS84");
        if (element2 == null) {
            return null;
        }
        BursaWolfParameters bursaWolfParameters = new BursaWolfParameters(DefaultGeodeticDatum.WGS84);
        bursaWolfParameters.dx = element2.pullDouble("dx");
        bursaWolfParameters.dy = element2.pullDouble("dy");
        bursaWolfParameters.dz = element2.pullDouble("dz");
        if (element2.peek() != null) {
            bursaWolfParameters.ex = element2.pullDouble("ex");
            bursaWolfParameters.ey = element2.pullDouble("ey");
            bursaWolfParameters.ez = element2.pullDouble("ez");
            bursaWolfParameters.ppm = element2.pullDouble("ppm");
        }
        element2.close();
        return bursaWolfParameters;
    }

    private Ellipsoid parseSpheroid(Element element) throws ParseException {
        Element element2 = element.pullElement("SPHEROID");
        String string = element2.pullString("name");
        double d = element2.pullDouble("semiMajorAxis");
        double d2 = element2.pullDouble("inverseFlattening");
        Map<String, Object> map = this.parseAuthority(element2, string);
        element2.close();
        if (d2 == 0.0) {
            d2 = Double.POSITIVE_INFINITY;
        }
        try {
            return this.datumFactory.createFlattenedSphere(map, d, d2, (Unit)SI.METRE);
        }
        catch (FactoryException factoryException) {
            throw element2.parseFailed((Exception)((Object)factoryException), null);
        }
    }

    private ParameterValueGroup parseProjection(Element element, Ellipsoid ellipsoid, Unit<Length> unit, Unit<Angle> unit2) throws ParseException {
        ParameterValueGroup parameterValueGroup;
        Element element2 = element.pullElement("PROJECTION");
        String string = element2.pullString("name");
        Map<String, Object> map = this.parseAuthority(element2, string);
        element2.close();
        try {
            parameterValueGroup = this.mtFactory.getDefaultParameters(string);
        }
        catch (NoSuchIdentifierException noSuchIdentifierException) {
            throw element2.parseFailed((Exception)((Object)noSuchIdentifierException), null);
        }
        Element element3 = element;
        try {
            Object object;
            if (ellipsoid != null) {
                object = ellipsoid.getAxisUnit();
                parameterValueGroup.parameter("semi_major").setValue(ellipsoid.getSemiMajorAxis(), object);
                parameterValueGroup.parameter("semi_minor").setValue(ellipsoid.getSemiMinorAxis(), object);
            }
            while ((element3 = element.pullOptionalElement("PARAMETER")) != null) {
                object = element3.pullString("name");
                double d = element3.pullDouble("value");
                ParameterValue parameterValue = parameterValueGroup.parameter((String)object);
                Unit unit3 = parameterValue.getDescriptor().getUnit();
                if (unit3 != null && !Unit.ONE.equals((Object)unit3)) {
                    if (unit != null && SI.METRE.isCompatible(unit3)) {
                        parameterValue.setValue(d, unit);
                        continue;
                    }
                    if (unit2 != null && SI.RADIAN.isCompatible(unit3)) {
                        parameterValue.setValue(d, unit2);
                        continue;
                    }
                }
                parameterValue.setValue(d);
            }
        }
        catch (ParameterNotFoundException parameterNotFoundException) {
            throw element3.parseFailed((Exception)((Object)parameterNotFoundException), Errors.format((int)210, (Object)parameterNotFoundException.getParameterName()));
        }
        return parameterValueGroup;
    }

    private GeodeticDatum parseDatum(Element element, PrimeMeridian primeMeridian) throws ParseException {
        Element element2 = element.pullElement("DATUM");
        String string = element2.pullString("name");
        Ellipsoid ellipsoid = this.parseSpheroid(element2);
        BursaWolfParameters bursaWolfParameters = ReferencingParser.parseToWGS84(element2);
        Map<String, Object> map = this.parseAuthority(element2, string);
        if (bursaWolfParameters == null && element2.peek() instanceof Number) {
            bursaWolfParameters = new BursaWolfParameters(DefaultGeodeticDatum.WGS84);
            bursaWolfParameters.dx = element2.pullDouble("dx");
            bursaWolfParameters.dy = element2.pullDouble("dy");
            bursaWolfParameters.dz = element2.pullDouble("dz");
            bursaWolfParameters.ex = element2.pullDouble("ex");
            bursaWolfParameters.ey = element2.pullDouble("ey");
            bursaWolfParameters.ez = element2.pullDouble("ez");
            bursaWolfParameters.ppm = element2.pullDouble("ppm");
        }
        element2.close();
        if (bursaWolfParameters != null) {
            if (!(map instanceof HashMap)) {
                map = new HashMap<String, Object>(map);
            }
            map.put("bursaWolf", bursaWolfParameters);
        }
        try {
            return this.datumFactory.createGeodeticDatum(map, ellipsoid, primeMeridian);
        }
        catch (FactoryException factoryException) {
            throw element2.parseFailed((Exception)((Object)factoryException), null);
        }
    }

    private VerticalDatum parseVertDatum(Element element) throws ParseException {
        Element element2 = element.pullElement("VERT_DATUM");
        String string = element2.pullString("name");
        int n = element2.pullInteger("datum");
        Map<String, Object> map = this.parseAuthority(element2, string);
        element2.close();
        VerticalDatumType verticalDatumType = DefaultVerticalDatum.getVerticalDatumTypeFromLegacyCode(n);
        if (verticalDatumType == null) {
            throw element2.parseFailed(null, Errors.format((int)226, (Object)n));
        }
        try {
            return this.datumFactory.createVerticalDatum(map, verticalDatumType);
        }
        catch (FactoryException factoryException) {
            throw element2.parseFailed((Exception)((Object)factoryException), null);
        }
    }

    private EngineeringDatum parseLocalDatum(Element element) throws ParseException {
        Element element2 = element.pullElement("LOCAL_DATUM");
        String string = element2.pullString("name");
        int n = element2.pullInteger("datum");
        Map<String, Object> map = this.parseAuthority(element2, string);
        element2.close();
        try {
            return this.datumFactory.createEngineeringDatum(map);
        }
        catch (FactoryException factoryException) {
            throw element2.parseFailed((Exception)((Object)factoryException), null);
        }
    }

    private EngineeringCRS parseLocalCS(Element element) throws ParseException {
        Element element2 = element.pullElement("LOCAL_CS");
        String string = element2.pullString("name");
        EngineeringDatum engineeringDatum = this.parseLocalDatum(element2);
        Unit unit = this.parseUnit(element2, (Unit)SI.METRE);
        CoordinateSystemAxis coordinateSystemAxis = this.parseAxis(element2, unit, true);
        ArrayList<CoordinateSystemAxis> arrayList = new ArrayList<CoordinateSystemAxis>();
        do {
            arrayList.add(coordinateSystemAxis);
        } while ((coordinateSystemAxis = this.parseAxis(element2, unit, false)) != null);
        Map<String, Object> map = this.parseAuthority(element2, string);
        element2.close();
        AbstractCS abstractCS = new AbstractCS(Collections.singletonMap("name", string), arrayList.toArray(new CoordinateSystemAxis[arrayList.size()]));
        try {
            return this.crsFactory.createEngineeringCRS(map, engineeringDatum, (CoordinateSystem)abstractCS);
        }
        catch (FactoryException factoryException) {
            throw element2.parseFailed((Exception)((Object)factoryException), null);
        }
    }

    private GeocentricCRS parseGeoCCS(Element element) throws ParseException {
        Element element2 = element.pullElement("GEOCCS");
        String string = element2.pullString("name");
        Map<String, Object> map = this.parseAuthority(element2, string);
        PrimeMeridian primeMeridian = this.parsePrimem(element2, (Unit<Angle>)NonSI.DEGREE_ANGLE);
        GeodeticDatum geodeticDatum = this.parseDatum(element2, primeMeridian);
        Unit unit = this.parseUnit(element2, (Unit)SI.METRE);
        CoordinateSystemAxis coordinateSystemAxis = null;
        CoordinateSystemAxis coordinateSystemAxis2 = null;
        CoordinateSystemAxis coordinateSystemAxis3 = this.parseAxis(element2, unit, false);
        try {
            if (coordinateSystemAxis3 != null) {
                coordinateSystemAxis = this.parseAxis(element2, unit, true);
                coordinateSystemAxis2 = this.parseAxis(element2, unit, true);
            }
            if (coordinateSystemAxis3 == null || this.axisIgnored) {
                coordinateSystemAxis3 = this.createAxis(null, "X", AxisDirection.OTHER, unit);
                coordinateSystemAxis = this.createAxis(null, "Y", AxisDirection.EAST, unit);
                coordinateSystemAxis2 = this.createAxis(null, "Z", AxisDirection.NORTH, unit);
            }
            element2.close();
            CartesianCS cartesianCS = this.csFactory.createCartesianCS(map, coordinateSystemAxis3, coordinateSystemAxis, coordinateSystemAxis2);
            cartesianCS = WktUtilities.replace(cartesianCS, false);
            return this.crsFactory.createGeocentricCRS(map, geodeticDatum, cartesianCS);
        }
        catch (FactoryException factoryException) {
            throw element2.parseFailed((Exception)((Object)factoryException), null);
        }
    }

    private VerticalCRS parseVertCS(Element element) throws ParseException {
        Element element2 = element.pullElement("VERT_CS");
        if (element2 == null) {
            return null;
        }
        String string = element2.pullString("name");
        VerticalDatum verticalDatum = this.parseVertDatum(element2);
        Unit unit = this.parseUnit(element2, (Unit)SI.METRE);
        CoordinateSystemAxis coordinateSystemAxis = this.parseAxis(element2, unit, false);
        Map<String, Object> map = this.parseAuthority(element2, string);
        element2.close();
        try {
            if (coordinateSystemAxis == null || this.axisIgnored) {
                coordinateSystemAxis = this.createAxis(null, this.isoConform ? "h" : "H", AxisDirection.UP, unit);
            }
            return this.crsFactory.createVerticalCRS(map, verticalDatum, this.csFactory.createVerticalCS(Collections.singletonMap("name", string), coordinateSystemAxis));
        }
        catch (FactoryException factoryException) {
            throw element2.parseFailed((Exception)((Object)factoryException), null);
        }
    }

    private GeographicCRS parseGeoGCS(Element element) throws ParseException {
        Element element2 = element.pullElement("GEOGCS");
        String string = element2.pullString("name");
        Map<String, Object> map = this.parseAuthority(element2, string);
        Unit unit = this.parseUnit(element2, (Unit)SI.RADIAN);
        PrimeMeridian primeMeridian = this.parsePrimem(element2, unit);
        GeodeticDatum geodeticDatum = this.parseDatum(element2, primeMeridian);
        CoordinateSystemAxis coordinateSystemAxis = this.parseAxis(element2, unit, false);
        CoordinateSystemAxis coordinateSystemAxis2 = null;
        try {
            if (coordinateSystemAxis != null) {
                coordinateSystemAxis2 = this.parseAxis(element2, unit, true);
            }
            if (coordinateSystemAxis == null || this.axisIgnored) {
                coordinateSystemAxis = this.createAxis(null, this.isoConform ? "\u03bb" : "Lon", AxisDirection.EAST, unit);
                coordinateSystemAxis2 = this.createAxis(null, this.isoConform ? "\u03c6" : "Lat", AxisDirection.NORTH, unit);
            }
            element2.close();
            return this.crsFactory.createGeographicCRS(map, geodeticDatum, this.csFactory.createEllipsoidalCS(map, coordinateSystemAxis, coordinateSystemAxis2));
        }
        catch (FactoryException factoryException) {
            throw element2.parseFailed((Exception)((Object)factoryException), null);
        }
    }

    private ProjectedCRS parseProjCS(Element element) throws ParseException {
        Element element2 = element.pullElement("PROJCS");
        String string = element2.pullString("name");
        Map<String, Object> map = this.parseAuthority(element2, string);
        GeographicCRS geographicCRS = this.parseGeoGCS(element2);
        Ellipsoid ellipsoid = geographicCRS.getDatum().getEllipsoid();
        Unit unit = this.parseUnit(element2, (Unit)SI.METRE);
        Unit unit2 = geographicCRS.getCoordinateSystem().getAxis(0).getUnit().asType(Angle.class);
        ParameterValueGroup parameterValueGroup = this.parseProjection(element2, ellipsoid, unit, (Unit<Angle>)unit2);
        CoordinateSystemAxis coordinateSystemAxis = this.parseAxis(element2, unit, false);
        CoordinateSystemAxis coordinateSystemAxis2 = null;
        try {
            if (coordinateSystemAxis != null) {
                coordinateSystemAxis2 = this.parseAxis(element2, unit, true);
            }
            if (coordinateSystemAxis == null || this.axisIgnored) {
                coordinateSystemAxis = this.createAxis(null, this.isoConform ? "x" : "X", AxisDirection.EAST, unit);
                coordinateSystemAxis2 = this.createAxis(null, this.isoConform ? "y" : "Y", AxisDirection.NORTH, unit);
            }
            element2.close();
            DefiningConversion definingConversion = new DefiningConversion(string, parameterValueGroup);
            return this.crsFactory.createProjectedCRS(map, geographicCRS, (Conversion)definingConversion, this.csFactory.createCartesianCS(map, coordinateSystemAxis, coordinateSystemAxis2));
        }
        catch (FactoryException factoryException) {
            throw element2.parseFailed((Exception)((Object)factoryException), null);
        }
    }

    private CompoundCRS parseCompdCS(Element element) throws ParseException {
        CoordinateReferenceSystem[] coordinateReferenceSystemArray = new CoordinateReferenceSystem[2];
        Element element2 = element.pullElement("COMPD_CS");
        String string = element2.pullString("name");
        Map<String, Object> map = this.parseAuthority(element2, string);
        coordinateReferenceSystemArray[0] = this.parseCoordinateReferenceSystem(element2);
        coordinateReferenceSystemArray[1] = this.parseCoordinateReferenceSystem(element2);
        element2.close();
        try {
            return this.crsFactory.createCompoundCRS(map, coordinateReferenceSystemArray);
        }
        catch (FactoryException factoryException) {
            throw element2.parseFailed((Exception)((Object)factoryException), null);
        }
    }

    private DerivedCRS parseFittedCS(Element element) throws ParseException {
        Element element2 = element.pullElement("FITTED_CS");
        String string = element2.pullString("name");
        Map<String, Object> map = this.parseAuthority(element2, string);
        MathTransform mathTransform = this.parseMathTransform(element2, true);
        CoordinateReferenceSystem coordinateReferenceSystem = this.parseCoordinateReferenceSystem(element2);
        OperationMethod operationMethod = this.getOperationMethod();
        element2.close();
        CoordinateSystemAxis[] coordinateSystemAxisArray = new CoordinateSystemAxis[mathTransform.getSourceDimensions()];
        StringBuilder stringBuilder = new StringBuilder(string);
        stringBuilder.append(" axis ");
        int n = stringBuilder.length();
        try {
            Object object;
            for (int i = 0; i < coordinateSystemAxisArray.length; ++i) {
                object = String.valueOf(i);
                stringBuilder.setLength(n);
                stringBuilder.append((String)object);
                coordinateSystemAxisArray[i] = this.csFactory.createCoordinateSystemAxis(Collections.singletonMap("name", stringBuilder.toString()), (String)object, AxisDirection.OTHER, Unit.ONE);
            }
            DefiningConversion definingConversion = new DefiningConversion(Collections.singletonMap("name", operationMethod.getName().getCode()), operationMethod, mathTransform.inverse());
            object = new AbstractCS(map, coordinateSystemAxisArray);
            return this.crsFactory.createDerivedCRS(map, coordinateReferenceSystem, (Conversion)definingConversion, (CoordinateSystem)object);
        }
        catch (FactoryException factoryException) {
            throw element2.parseFailed((Exception)((Object)factoryException), null);
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            throw element2.parseFailed((Exception)((Object)noninvertibleTransformException), null);
        }
    }
}

