/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.parameter;

import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.lang.reflect.Array;
import java.util.Set;
import javax.measure.unit.Unit;
import org.geotoolkit.io.TableWriter;
import org.geotoolkit.io.wkt.FormattableObject;
import org.geotoolkit.io.wkt.Formatter;
import org.geotoolkit.measure.Units;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.ArgumentChecks;
import org.geotoolkit.util.Cloneable;
import org.geotoolkit.util.Utilities;
import org.geotoolkit.util.converter.Classes;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.InvalidParameterValueException;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterValue;
import org.opengis.parameter.ParameterValueGroup;

public abstract class AbstractParameter
extends FormattableObject
implements GeneralParameterValue,
Serializable,
Cloneable {
    private static final long serialVersionUID = 8458179223988766398L;
    final GeneralParameterDescriptor descriptor;

    protected AbstractParameter(GeneralParameterDescriptor generalParameterDescriptor) {
        this.descriptor = generalParameterDescriptor;
        ArgumentChecks.ensureNonNull((String)"descriptor", (Object)generalParameterDescriptor);
    }

    public GeneralParameterDescriptor getDescriptor() {
        return this.descriptor;
    }

    static <T> T ensureValidValue(ParameterDescriptor<T> parameterDescriptor, Object object) throws InvalidParameterValueException {
        String string;
        if (object == null) {
            if (parameterDescriptor.getMinimumOccurs() != 0) {
                return (T)parameterDescriptor.getDefaultValue();
            }
            return null;
        }
        Class clazz = parameterDescriptor.getValueClass();
        if (!clazz.isInstance(object)) {
            string = Errors.format((int)87, (Object)Classes.getClass((Object)object));
        } else {
            Object t = clazz.cast(object);
            Comparable comparable = parameterDescriptor.getMinimumValue();
            Comparable comparable2 = parameterDescriptor.getMaximumValue();
            if (comparable != null && comparable.compareTo(t) > 0 || comparable2 != null && comparable2.compareTo(t) < 0) {
                string = Errors.format((int)246, (Object)object, (Object)comparable, (Object)comparable2);
            } else {
                Set set = parameterDescriptor.getValidValues();
                if (set != null && !set.contains(object)) {
                    string = Errors.format((int)73, (Object)AbstractParameter.getName(parameterDescriptor), (Object)object);
                } else {
                    return t;
                }
            }
        }
        throw new InvalidParameterValueException(string, AbstractParameter.getName(parameterDescriptor), object);
    }

    static IllegalStateException unitlessParameter(GeneralParameterDescriptor generalParameterDescriptor) {
        return new IllegalStateException(Errors.format((int)214, (Object)AbstractParameter.getName(generalParameterDescriptor)));
    }

    static String getName(GeneralParameterDescriptor generalParameterDescriptor) {
        return generalParameterDescriptor.getName().getCode();
    }

    static int getUnitMessageID(Unit<?> unit) {
        if (Units.isLinear(unit)) {
            return 135;
        }
        if (Units.isAngular(unit)) {
            return 128;
        }
        if (Units.isTemporal(unit)) {
            return 139;
        }
        if (Units.isScale(unit)) {
            return 138;
        }
        return 92;
    }

    public AbstractParameter clone() {
        try {
            return (AbstractParameter)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new AssertionError((Object)cloneNotSupportedException);
        }
    }

    public boolean equals(Object object) {
        if (object != null && object.getClass() == this.getClass()) {
            AbstractParameter abstractParameter = (AbstractParameter)object;
            return Utilities.equals((Object)this.descriptor, (Object)abstractParameter.descriptor);
        }
        return false;
    }

    public int hashCode() {
        return this.descriptor.hashCode() ^ 0xDC7086BE;
    }

    @Override
    public final String toString() {
        TableWriter tableWriter = new TableWriter(null, 1);
        tableWriter.setMultiLinesCells(true);
        try {
            this.write(tableWriter);
        }
        catch (IOException iOException) {
            throw new AssertionError((Object)iOException);
        }
        return tableWriter.toString();
    }

    protected void write(TableWriter tableWriter) throws IOException {
        tableWriter.write(AbstractParameter.getName(this.descriptor));
        tableWriter.nextColumn();
        if (this instanceof ParameterValue) {
            tableWriter.write(61);
            tableWriter.nextColumn();
            AbstractParameter.append((Writer)tableWriter, ((ParameterValue)this).getValue());
        } else if (this instanceof ParameterValueGroup) {
            tableWriter.write(58);
            tableWriter.nextColumn();
            TableWriter tableWriter2 = null;
            for (GeneralParameterValue generalParameterValue : ((ParameterValueGroup)this).values()) {
                if (generalParameterValue instanceof AbstractParameter) {
                    if (tableWriter2 == null) {
                        tableWriter2 = new TableWriter((Writer)tableWriter, 1);
                        tableWriter2.setMultiLinesCells(true);
                    }
                    ((AbstractParameter)generalParameterValue).write(tableWriter2);
                    continue;
                }
                if (tableWriter2 != null) {
                    tableWriter2.flush();
                    tableWriter2 = null;
                }
                tableWriter.write(generalParameterValue.toString());
                tableWriter.write(10);
            }
            if (tableWriter2 != null) {
                tableWriter2.flush();
            }
        }
        tableWriter.nextLine();
    }

    private static void append(Writer writer, Object object) throws IOException {
        if (object == null) {
            writer.write("null");
        } else if (object.getClass().isArray()) {
            writer.write(123);
            int n = Array.getLength(object);
            int n2 = Math.min(5, n);
            for (int i = 0; i < n2; ++i) {
                if (i != 0) {
                    writer.write(", ");
                }
                AbstractParameter.append(writer, Array.get(object, i));
            }
            if (n > n2) {
                writer.write(", ...");
            }
            writer.write(125);
        } else {
            boolean bl = object instanceof Number;
            if (!bl) {
                writer.write(34);
            }
            writer.write(object.toString());
            if (!bl) {
                writer.write(34);
            }
        }
    }

    @Override
    public String formatWKT(Formatter formatter) {
        return "PARAMETER";
    }
}

