/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing;

import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.StringTokenizer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.geotoolkit.display.shape.XRectangle2D;
import org.geotoolkit.factory.AuthorityFactoryFinder;
import org.geotoolkit.factory.Factories;
import org.geotoolkit.factory.Factory;
import org.geotoolkit.factory.FactoryFinder;
import org.geotoolkit.factory.FactoryNotFoundException;
import org.geotoolkit.factory.FactoryRegistryException;
import org.geotoolkit.factory.Hints;
import org.geotoolkit.geometry.Envelope2D;
import org.geotoolkit.geometry.GeneralDirectPosition;
import org.geotoolkit.geometry.GeneralEnvelope;
import org.geotoolkit.internal.referencing.CRSUtilities;
import org.geotoolkit.lang.Static;
import org.geotoolkit.metadata.iso.extent.DefaultGeographicBoundingBox;
import org.geotoolkit.referencing.DefaultAuthorityFactory;
import org.geotoolkit.referencing.IdentifiedObjects;
import org.geotoolkit.referencing.crs.DefaultCompoundCRS;
import org.geotoolkit.referencing.crs.DefaultGeographicCRS;
import org.geotoolkit.referencing.crs.DefaultVerticalCRS;
import org.geotoolkit.referencing.cs.DefaultCoordinateSystemAxis;
import org.geotoolkit.referencing.cs.DefaultEllipsoidalCS;
import org.geotoolkit.referencing.operation.matrix.XAffineTransform;
import org.geotoolkit.referencing.operation.projection.UnitaryProjection;
import org.geotoolkit.referencing.operation.transform.IdentityTransform;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.ArgumentChecks;
import org.geotoolkit.util.ComparisonMode;
import org.geotoolkit.util.UnsupportedImplementationException;
import org.geotoolkit.util.Utilities;
import org.geotoolkit.util.Version;
import org.geotoolkit.util.logging.Logging;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.extent.Extent;
import org.opengis.metadata.extent.GeographicBoundingBox;
import org.opengis.metadata.extent.GeographicExtent;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.crs.CRSFactory;
import org.opengis.referencing.crs.CompoundCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeneralDerivedCRS;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.crs.TemporalCRS;
import org.opengis.referencing.crs.VerticalCRS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.CoordinateOperationFactory;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

public final class CRS
extends Static {
    private static volatile CRSFactory crsFactory;
    private static volatile CRSAuthorityFactory standardFactory;
    private static volatile CRSAuthorityFactory xyFactory;
    private static volatile CoordinateOperationFactory strictFactory;
    private static volatile CoordinateOperationFactory lenientFactory;
    private static volatile Boolean defaultOrder;
    private static volatile Boolean defaultLenient;

    private CRS() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static CRSFactory getCRSFactory() {
        CRSFactory cRSFactory = crsFactory;
        if (cRSFactory != null) return cRSFactory;
        Class<CRS> clazz = CRS.class;
        synchronized (CRS.class) {
            cRSFactory = crsFactory;
            if (cRSFactory != null) return cRSFactory;
            crsFactory = cRSFactory = FactoryFinder.getCRSFactory(null);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return cRSFactory;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CRSAuthorityFactory getAuthorityFactory(Boolean bl) throws FactoryRegistryException {
        CRSAuthorityFactory cRSAuthorityFactory;
        if (bl == null && (bl = defaultOrder) == null) {
            defaultOrder = bl = Boolean.valueOf(Boolean.TRUE.equals(Hints.getSystemDefault((RenderingHints.Key)Hints.FORCE_LONGITUDE_FIRST_AXIS_ORDER)));
        }
        CRSAuthorityFactory cRSAuthorityFactory2 = cRSAuthorityFactory = bl != false ? xyFactory : standardFactory;
        if (cRSAuthorityFactory != null) return cRSAuthorityFactory;
        Class<CRS> clazz = CRS.class;
        synchronized (CRS.class) {
            CRSAuthorityFactory cRSAuthorityFactory3 = cRSAuthorityFactory = bl != false ? xyFactory : standardFactory;
            if (cRSAuthorityFactory != null) return cRSAuthorityFactory;
            try {
                cRSAuthorityFactory = DefaultAuthorityFactory.create(bl);
                if (bl.booleanValue()) {
                    xyFactory = cRSAuthorityFactory;
                } else {
                    standardFactory = cRSAuthorityFactory;
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                throw new FactoryNotFoundException(null, (Throwable)noSuchElementException);
            }
            return cRSAuthorityFactory;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CoordinateOperationFactory getCoordinateOperationFactory(boolean bl) {
        CoordinateOperationFactory coordinateOperationFactory;
        CoordinateOperationFactory coordinateOperationFactory2 = coordinateOperationFactory = bl ? lenientFactory : strictFactory;
        if (coordinateOperationFactory != null) return coordinateOperationFactory;
        Class<CRS> clazz = CRS.class;
        synchronized (CRS.class) {
            CoordinateOperationFactory coordinateOperationFactory3 = coordinateOperationFactory = bl ? lenientFactory : strictFactory;
            if (coordinateOperationFactory != null) return coordinateOperationFactory;
            Hints hints = new Hints();
            if (bl) {
                hints.put((Object)Hints.LENIENT_DATUM_SHIFT, (Object)Boolean.TRUE);
            }
            coordinateOperationFactory = FactoryFinder.getCoordinateOperationFactory((Hints)hints);
            if (bl) {
                lenientFactory = coordinateOperationFactory;
            } else {
                strictFactory = coordinateOperationFactory;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return coordinateOperationFactory;
        }
    }

    public static Version getVersion(String string) throws FactoryRegistryException {
        Factory factory;
        ArgumentChecks.ensureNonNull((String)"authority", (Object)string);
        Object object = AuthorityFactoryFinder.getCRSAuthorityFactory((String)string, null);
        HashSet<Factory> hashSet = new HashSet<Factory>();
        while (object instanceof Factory && hashSet.add(factory = (Factory)object)) {
            Map map = factory.getImplementationHints();
            Object v = map.get(Hints.VERSION);
            if (v instanceof Version) {
                return (Version)v;
            }
            object = map.get(Hints.CRS_AUTHORITY_FACTORY);
        }
        return null;
    }

    public static Set<String> getSupportedCodes(String string) {
        ArgumentChecks.ensureNonNull((String)"authority", (Object)string);
        return DefaultAuthorityFactory.getSupportedCodes(string);
    }

    public static Set<String> getSupportedAuthorities(boolean bl) {
        return DefaultAuthorityFactory.getSupportedAuthorities(bl);
    }

    public static CoordinateReferenceSystem decode(String string) throws NoSuchAuthorityCodeException, FactoryException {
        ArgumentChecks.ensureNonNull((String)"code", (Object)string);
        return CRS.getAuthorityFactory(null).createCoordinateReferenceSystem(string);
    }

    public static CoordinateReferenceSystem decode(String string, boolean bl) throws NoSuchAuthorityCodeException, FactoryException {
        ArgumentChecks.ensureNonNull((String)"code", (Object)string);
        return CRS.getAuthorityFactory(bl).createCoordinateReferenceSystem(string);
    }

    public static CoordinateReferenceSystem parseWKT(String string) throws FactoryException {
        ArgumentChecks.ensureNonNull((String)"wkt", (Object)string);
        return CRS.getCRSFactory().createFromWKT(string);
    }

    public static Envelope getEnvelope(CoordinateReferenceSystem coordinateReferenceSystem) {
        Extent extent;
        GeneralEnvelope generalEnvelope = null;
        GeneralEnvelope generalEnvelope2 = null;
        if (coordinateReferenceSystem != null && (extent = coordinateReferenceSystem.getDomainOfValidity()) != null) {
            for (GeographicExtent geographicExtent : extent.getGeographicElements()) {
                if (!Boolean.FALSE.equals(geographicExtent.getInclusion())) continue;
            }
        }
        if (generalEnvelope == null && (extent = CRS.getGeographicBoundingBox(coordinateReferenceSystem)) != null && !Boolean.FALSE.equals(extent.getInclusion())) {
            GeographicExtent geographicExtent;
            generalEnvelope = generalEnvelope2 = new GeneralEnvelope(new double[]{extent.getWestBoundLongitude(), extent.getSouthBoundLatitude()}, new double[]{extent.getEastBoundLongitude(), extent.getNorthBoundLatitude()});
            SingleCRS singleCRS = CRS.getHorizontalCRS(coordinateReferenceSystem);
            geographicExtent = CRSUtilities.getStandardGeographicCRS2D((CoordinateReferenceSystem)singleCRS);
            generalEnvelope2.setCoordinateReferenceSystem((CoordinateReferenceSystem)geographicExtent);
            try {
                generalEnvelope = CRS.transform(generalEnvelope, (CoordinateReferenceSystem)singleCRS);
            }
            catch (TransformException transformException) {
                generalEnvelope = null;
                CRS.unexpectedException("getEnvelope", (Exception)((Object)transformException));
            }
            generalEnvelope2.setCoordinateReferenceSystem((CoordinateReferenceSystem)singleCRS);
        }
        return generalEnvelope;
    }

    public static GeographicBoundingBox getGeographicBoundingBox(CoordinateReferenceSystem coordinateReferenceSystem) {
        Extent extent;
        GeographicBoundingBox geographicBoundingBox = null;
        DefaultGeographicBoundingBox defaultGeographicBoundingBox = null;
        if (coordinateReferenceSystem != null && (extent = coordinateReferenceSystem.getDomainOfValidity()) != null) {
            for (GeographicExtent geographicExtent : extent.getGeographicElements()) {
                if (!(geographicExtent instanceof GeographicBoundingBox)) continue;
                GeographicBoundingBox geographicBoundingBox2 = (GeographicBoundingBox)geographicExtent;
                if (geographicBoundingBox == null) {
                    geographicBoundingBox = geographicBoundingBox2;
                    continue;
                }
                if (defaultGeographicBoundingBox == null) {
                    defaultGeographicBoundingBox = new DefaultGeographicBoundingBox(geographicBoundingBox);
                    geographicBoundingBox = defaultGeographicBoundingBox;
                }
                defaultGeographicBoundingBox.add(geographicBoundingBox2);
            }
        }
        return geographicBoundingBox;
    }

    public static boolean isHorizontalCRS(CoordinateReferenceSystem coordinateReferenceSystem) {
        Datum datum;
        int n;
        if (coordinateReferenceSystem instanceof SingleCRS && (n = coordinateReferenceSystem.getCoordinateSystem().getDimension()) == 2 && (datum = ((SingleCRS)coordinateReferenceSystem).getDatum()) instanceof GeodeticDatum) {
            while (coordinateReferenceSystem instanceof GeneralDerivedCRS) {
                coordinateReferenceSystem = ((GeneralDerivedCRS)coordinateReferenceSystem).getBaseCRS();
            }
            return coordinateReferenceSystem instanceof GeographicCRS;
        }
        return false;
    }

    public static SingleCRS getHorizontalCRS(CoordinateReferenceSystem coordinateReferenceSystem) {
        CoordinateReferenceSystem coordinateReferenceSystem2;
        CoordinateSystem coordinateSystem;
        if (coordinateReferenceSystem instanceof SingleCRS) {
            Datum datum;
            coordinateSystem = coordinateReferenceSystem.getCoordinateSystem();
            int n = coordinateSystem.getDimension();
            if (n == 2) {
                datum = ((SingleCRS)coordinateReferenceSystem).getDatum();
                if (datum instanceof GeodeticDatum) {
                    coordinateReferenceSystem2 = coordinateReferenceSystem;
                    while (coordinateReferenceSystem2 instanceof GeneralDerivedCRS) {
                        coordinateReferenceSystem2 = ((GeneralDerivedCRS)coordinateReferenceSystem2).getBaseCRS();
                    }
                    if (coordinateReferenceSystem2 instanceof GeographicCRS) {
                        assert (CRS.isHorizontalCRS(coordinateReferenceSystem)) : coordinateReferenceSystem;
                        return (SingleCRS)coordinateReferenceSystem;
                    }
                }
            } else if (n >= 3 && coordinateReferenceSystem instanceof GeographicCRS) {
                Object object;
                datum = null;
                coordinateReferenceSystem2 = null;
                int n2 = 0;
                block9: for (int i = 0; i < n; ++i) {
                    object = coordinateSystem.getAxis(i);
                    if (!DefaultCoordinateSystemAxis.isCompassDirection(object.getDirection())) continue;
                    switch (n2++) {
                        case 0: {
                            datum = object;
                            continue block9;
                        }
                        case 1: {
                            coordinateReferenceSystem2 = object;
                            continue block9;
                        }
                    }
                }
                if (n2 == 2) {
                    GeographicCRS geographicCRS;
                    EllipsoidalCS ellipsoidalCS;
                    GeodeticDatum geodeticDatum = ((GeographicCRS)coordinateReferenceSystem).getDatum();
                    object = CRSUtilities.changeDimensionInName((IdentifiedObject)coordinateSystem, "3D", "2D");
                    try {
                        ellipsoidalCS = FactoryFinder.getCSFactory(null).createEllipsoidalCS((Map)object, (CoordinateSystemAxis)datum, (CoordinateSystemAxis)coordinateReferenceSystem2);
                    }
                    catch (FactoryException factoryException) {
                        Logging.recoverableException(CRS.class, (String)"getHorizontalCRS", (Throwable)factoryException);
                        ellipsoidalCS = new DefaultEllipsoidalCS((Map<String, ?>)object, (CoordinateSystemAxis)datum, (CoordinateSystemAxis)coordinateReferenceSystem2);
                    }
                    object = CRSUtilities.changeDimensionInName((IdentifiedObject)coordinateReferenceSystem, "3D", "2D");
                    try {
                        geographicCRS = CRS.getCRSFactory().createGeographicCRS((Map)object, geodeticDatum, ellipsoidalCS);
                    }
                    catch (FactoryException factoryException) {
                        Logging.recoverableException(CRS.class, (String)"getHorizontalCRS", (Throwable)factoryException);
                        geographicCRS = new DefaultGeographicCRS((Map<String, ?>)object, geodeticDatum, ellipsoidalCS);
                    }
                    assert (CRS.isHorizontalCRS((CoordinateReferenceSystem)geographicCRS)) : geographicCRS;
                    return geographicCRS;
                }
            }
        }
        if (coordinateReferenceSystem instanceof CompoundCRS) {
            coordinateSystem = (CompoundCRS)coordinateReferenceSystem;
            for (Datum datum : coordinateSystem.getComponents()) {
                coordinateReferenceSystem2 = CRS.getHorizontalCRS((CoordinateReferenceSystem)datum);
                if (coordinateReferenceSystem2 == null) continue;
                assert (CRS.isHorizontalCRS(coordinateReferenceSystem2)) : coordinateReferenceSystem2;
                return coordinateReferenceSystem2;
            }
        }
        return null;
    }

    public static ProjectedCRS getProjectedCRS(CoordinateReferenceSystem coordinateReferenceSystem) {
        if (coordinateReferenceSystem instanceof ProjectedCRS) {
            return (ProjectedCRS)coordinateReferenceSystem;
        }
        if (coordinateReferenceSystem instanceof CompoundCRS) {
            CompoundCRS compoundCRS = (CompoundCRS)coordinateReferenceSystem;
            for (CoordinateReferenceSystem coordinateReferenceSystem2 : compoundCRS.getComponents()) {
                ProjectedCRS projectedCRS = CRS.getProjectedCRS(coordinateReferenceSystem2);
                if (projectedCRS == null) continue;
                return projectedCRS;
            }
        }
        return null;
    }

    public static VerticalCRS getVerticalCRS(CoordinateReferenceSystem coordinateReferenceSystem) {
        CompoundCRS compoundCRS;
        if (coordinateReferenceSystem instanceof VerticalCRS) {
            return (VerticalCRS)coordinateReferenceSystem;
        }
        if (coordinateReferenceSystem instanceof CompoundCRS) {
            compoundCRS = (CompoundCRS)coordinateReferenceSystem;
            for (CoordinateReferenceSystem coordinateReferenceSystem2 : compoundCRS.getComponents()) {
                VerticalCRS verticalCRS = CRS.getVerticalCRS(coordinateReferenceSystem2);
                if (verticalCRS == null) continue;
                return verticalCRS;
            }
        }
        if (coordinateReferenceSystem instanceof GeographicCRS && (compoundCRS = coordinateReferenceSystem.getCoordinateSystem()).getDimension() >= 3) {
            assert (CRSUtilities.dimensionColinearWith((CoordinateSystem)compoundCRS, DefaultCoordinateSystemAxis.ELLIPSOIDAL_HEIGHT) >= 0) : compoundCRS;
            return DefaultVerticalCRS.ELLIPSOIDAL_HEIGHT;
        }
        return null;
    }

    public static TemporalCRS getTemporalCRS(CoordinateReferenceSystem coordinateReferenceSystem) {
        if (coordinateReferenceSystem instanceof TemporalCRS) {
            return (TemporalCRS)coordinateReferenceSystem;
        }
        if (coordinateReferenceSystem instanceof CompoundCRS) {
            CompoundCRS compoundCRS = (CompoundCRS)coordinateReferenceSystem;
            for (CoordinateReferenceSystem coordinateReferenceSystem2 : compoundCRS.getComponents()) {
                TemporalCRS temporalCRS = CRS.getTemporalCRS(coordinateReferenceSystem2);
                if (temporalCRS == null) continue;
                return temporalCRS;
            }
        }
        return null;
    }

    public static CompoundCRS getCompoundCRS(CompoundCRS compoundCRS, SingleCRS ... singleCRSArray) {
        CompoundCRS compoundCRS2;
        List<SingleCRS> list = DefaultCompoundCRS.getSingleCRS((CoordinateReferenceSystem)compoundCRS);
        if (list.size() == singleCRSArray.length) {
            int n = 0;
            CoordinateReferenceSystem coordinateReferenceSystem = (CoordinateReferenceSystem)singleCRSArray.clone();
            compoundCRS2 = list.iterator();
            block0: while (compoundCRS2.hasNext()) {
                SingleCRS singleCRS = compoundCRS2.next();
                for (int i = n; i < ((CoordinateReferenceSystem)coordinateReferenceSystem).length; ++i) {
                    if (!CRS.equalsIgnoreMetadata(singleCRS, coordinateReferenceSystem[i])) continue;
                    System.arraycopy(coordinateReferenceSystem, n, coordinateReferenceSystem, n + 1, i - n);
                    coordinateReferenceSystem[n++] = null;
                    continue block0;
                }
                n = -1;
                break;
            }
            if (n == ((CoordinateReferenceSystem)coordinateReferenceSystem).length) {
                return compoundCRS;
            }
        }
        for (CoordinateReferenceSystem coordinateReferenceSystem : compoundCRS.getComponents()) {
            if (!(coordinateReferenceSystem instanceof CompoundCRS) || (compoundCRS2 = CRS.getCompoundCRS((CompoundCRS)coordinateReferenceSystem, singleCRSArray)) == null) continue;
            return compoundCRS2;
        }
        return null;
    }

    public static CoordinateReferenceSystem getSubCRS(CoordinateReferenceSystem coordinateReferenceSystem, int n, int n2) {
        if (coordinateReferenceSystem != null) {
            int n3 = coordinateReferenceSystem.getCoordinateSystem().getDimension();
            if (n < 0 || n > n2 || n2 > n3) {
                throw new IndexOutOfBoundsException(Errors.format((int)96, (Object)(n < 0 ? n : n2)));
            }
            while (n != 0 || n2 != n3) {
                List<? extends CoordinateReferenceSystem> list = CRSUtilities.getComponents(coordinateReferenceSystem);
                if (list == null) {
                    return null;
                }
                Iterator<? extends CoordinateReferenceSystem> iterator = list.iterator();
                while (iterator.hasNext() && n >= (n3 = (coordinateReferenceSystem = iterator.next()).getCoordinateSystem().getDimension())) {
                    n -= n3;
                    n2 -= n3;
                }
            }
        }
        return coordinateReferenceSystem;
    }

    public static Datum getDatum(CoordinateReferenceSystem coordinateReferenceSystem) {
        return CRSUtilities.getDatum(coordinateReferenceSystem);
    }

    public static Ellipsoid getEllipsoid(CoordinateReferenceSystem coordinateReferenceSystem) {
        Object object;
        if (coordinateReferenceSystem instanceof SingleCRS && (object = ((SingleCRS)coordinateReferenceSystem).getDatum()) instanceof GeodeticDatum) {
            return ((GeodeticDatum)object).getEllipsoid();
        }
        if (coordinateReferenceSystem instanceof CompoundCRS) {
            for (CoordinateReferenceSystem coordinateReferenceSystem2 : ((CompoundCRS)coordinateReferenceSystem).getComponents()) {
                Ellipsoid ellipsoid = CRS.getEllipsoid(coordinateReferenceSystem2);
                if (ellipsoid == null) continue;
                return ellipsoid;
            }
        }
        return null;
    }

    @Deprecated
    public static String getDeclaredIdentifier(IdentifiedObject identifiedObject) {
        return IdentifiedObjects.getIdentifier(identifiedObject);
    }

    @Deprecated
    public static String lookupIdentifier(IdentifiedObject identifiedObject, boolean bl) throws FactoryException {
        return IdentifiedObjects.lookupIdentifier(identifiedObject, bl);
    }

    @Deprecated
    public static String lookupIdentifier(Citation citation, CoordinateReferenceSystem coordinateReferenceSystem, boolean bl) throws FactoryException {
        return IdentifiedObjects.lookupIdentifier(citation, (IdentifiedObject)coordinateReferenceSystem, bl);
    }

    public static Integer lookupEpsgCode(CoordinateReferenceSystem coordinateReferenceSystem, boolean bl) throws FactoryException {
        return IdentifiedObjects.lookupEpsgCode((IdentifiedObject)coordinateReferenceSystem, bl);
    }

    public static boolean equalsIgnoreMetadata(Object object, Object object2) {
        return Utilities.deepEquals((Object)object, (Object)object2, (ComparisonMode)ComparisonMode.IGNORE_METADATA);
    }

    public static boolean equalsApproximatively(Object object, Object object2) {
        return Utilities.deepEquals((Object)object, (Object)object2, (ComparisonMode)ComparisonMode.APPROXIMATIVE);
    }

    public static MathTransform findMathTransform(CoordinateReferenceSystem coordinateReferenceSystem, CoordinateReferenceSystem coordinateReferenceSystem2) throws FactoryException {
        Boolean bl = defaultLenient;
        if (bl == null) {
            defaultLenient = bl = Boolean.valueOf(Boolean.TRUE.equals(Hints.getSystemDefault((RenderingHints.Key)Hints.LENIENT_DATUM_SHIFT)));
        }
        return CRS.findMathTransform(coordinateReferenceSystem, coordinateReferenceSystem2, bl);
    }

    public static MathTransform findMathTransform(CoordinateReferenceSystem coordinateReferenceSystem, CoordinateReferenceSystem coordinateReferenceSystem2, boolean bl) throws FactoryException {
        if (CRS.equalsIgnoreMetadata(coordinateReferenceSystem, coordinateReferenceSystem2)) {
            return IdentityTransform.create(coordinateReferenceSystem.getCoordinateSystem().getDimension());
        }
        ArgumentChecks.ensureNonNull((String)"sourceCRS", (Object)coordinateReferenceSystem);
        ArgumentChecks.ensureNonNull((String)"targetCRS", (Object)coordinateReferenceSystem2);
        CoordinateOperationFactory coordinateOperationFactory = CRS.getCoordinateOperationFactory(bl);
        return coordinateOperationFactory.createOperation(coordinateReferenceSystem, coordinateReferenceSystem2).getMathTransform();
    }

    public static Envelope transform(Envelope envelope, CoordinateReferenceSystem coordinateReferenceSystem) throws TransformException {
        CoordinateReferenceSystem coordinateReferenceSystem2;
        if (envelope != null && coordinateReferenceSystem != null && (coordinateReferenceSystem2 = envelope.getCoordinateReferenceSystem()) != null) {
            if (!CRS.equalsIgnoreMetadata(coordinateReferenceSystem2, coordinateReferenceSystem)) {
                CoordinateOperation coordinateOperation;
                CoordinateOperationFactory coordinateOperationFactory = CRS.getCoordinateOperationFactory(true);
                try {
                    coordinateOperation = coordinateOperationFactory.createOperation(coordinateReferenceSystem2, coordinateReferenceSystem);
                }
                catch (FactoryException factoryException) {
                    throw new TransformException(Errors.format((int)40), (Throwable)factoryException);
                }
                if (!coordinateOperation.getMathTransform().isIdentity()) {
                    envelope = CRS.transform(coordinateOperation, envelope);
                }
            }
            assert (CRS.equalsIgnoreMetadata(envelope.getCoordinateReferenceSystem(), coordinateReferenceSystem));
        }
        return envelope;
    }

    public static GeneralEnvelope transform(MathTransform mathTransform, Envelope envelope) throws TransformException {
        ArgumentChecks.ensureNonNull((String)"transform", (Object)mathTransform);
        return CRS.transform(mathTransform, envelope, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static GeneralEnvelope transform(MathTransform mathTransform, Envelope envelope, GeneralDirectPosition generalDirectPosition) throws TransformException {
        if (envelope == null) {
            return null;
        }
        if (mathTransform.isIdentity()) {
            GeneralEnvelope generalEnvelope = new GeneralEnvelope(envelope);
            generalEnvelope.setCoordinateReferenceSystem(null);
            if (generalDirectPosition != null) {
                int n = envelope.getDimension();
                while (--n >= 0) {
                    generalDirectPosition.setOrdinate(n, generalEnvelope.getMedian(n));
                }
            }
            return generalEnvelope;
        }
        int n = mathTransform.getSourceDimensions();
        if (envelope.getDimension() != n) {
            throw new MismatchedDimensionException(Errors.format((int)112, (Object)n, (Object)envelope.getDimension()));
        }
        int n2 = 0;
        GeneralEnvelope generalEnvelope = null;
        if (generalDirectPosition == null) {
            generalDirectPosition = new GeneralDirectPosition(mathTransform.getTargetDimensions());
        }
        GeneralDirectPosition generalDirectPosition2 = new GeneralDirectPosition(n);
        int n3 = n;
        while (--n3 >= 0) {
            generalDirectPosition2.setOrdinate(n3, envelope.getMinimum(n3));
        }
        block7: while (true) {
            if (generalDirectPosition != mathTransform.transform((DirectPosition)generalDirectPosition2, (DirectPosition)generalDirectPosition)) {
                throw new UnsupportedImplementationException(mathTransform.getClass());
            }
            if (generalEnvelope != null) {
                generalEnvelope.add(generalDirectPosition);
            } else {
                generalEnvelope = new GeneralEnvelope(generalDirectPosition, generalDirectPosition);
            }
            n3 = ++n2;
            int n4 = n;
            block8: while (true) {
                if (--n4 < 0) {
                    return generalEnvelope;
                }
                switch (n3 % 3) {
                    case 0: {
                        generalDirectPosition2.setOrdinate(n4, envelope.getMinimum(n4));
                        n3 /= 3;
                        continue block8;
                    }
                    case 1: {
                        generalDirectPosition2.setOrdinate(n4, envelope.getMaximum(n4));
                        continue block7;
                    }
                    case 2: {
                        generalDirectPosition2.setOrdinate(n4, envelope.getMedian(n4));
                        continue block7;
                    }
                }
                break;
            }
            break;
        }
        throw new AssertionError(n3);
    }

    public static GeneralEnvelope transform(CoordinateOperation coordinateOperation, Envelope envelope) throws TransformException {
        GeneralEnvelope generalEnvelope;
        Object object;
        CoordinateSystem coordinateSystem;
        GeneralDirectPosition generalDirectPosition;
        CoordinateReferenceSystem coordinateReferenceSystem;
        ArgumentChecks.ensureNonNull((String)"operation", (Object)coordinateOperation);
        if (envelope == null) {
            return null;
        }
        CoordinateReferenceSystem coordinateReferenceSystem2 = coordinateOperation.getSourceCRS();
        if (coordinateReferenceSystem2 != null && (coordinateReferenceSystem = envelope.getCoordinateReferenceSystem()) != null && !CRS.equalsIgnoreMetadata(coordinateReferenceSystem, coordinateReferenceSystem2)) {
            try {
                generalDirectPosition = CRS.findMathTransform(coordinateReferenceSystem, coordinateReferenceSystem2, false);
            }
            catch (FactoryException factoryException) {
                throw new TransformException(Errors.format((int)40), (Throwable)factoryException);
            }
            if (!generalDirectPosition.isIdentity()) {
                envelope = CRS.transform((MathTransform)generalDirectPosition, envelope);
            }
        }
        coordinateReferenceSystem = coordinateOperation.getMathTransform();
        generalDirectPosition = new GeneralDirectPosition(coordinateReferenceSystem.getTargetDimensions());
        GeneralEnvelope generalEnvelope2 = CRS.transform((MathTransform)coordinateReferenceSystem, envelope, generalDirectPosition);
        if (coordinateReferenceSystem2 != null && (coordinateSystem = coordinateReferenceSystem2.getCoordinateSystem()) != null) {
            object = null;
            generalEnvelope = null;
            int n = coordinateSystem.getDimension();
            for (int i = 0; i < n; ++i) {
                boolean bl;
                CoordinateSystemAxis coordinateSystemAxis = coordinateSystem.getAxis(i);
                if (coordinateSystemAxis == null) continue;
                double d = envelope.getMinimum(i);
                double d2 = envelope.getMaximum(i);
                double d3 = coordinateSystemAxis.getMinimumValue();
                double d4 = coordinateSystemAxis.getMaximumValue();
                boolean bl2 = d3 > d && d3 < d2;
                boolean bl3 = bl = d4 > d && d4 < d2;
                if (!bl2 && !bl) continue;
                if (object == null) {
                    object = new GeneralDirectPosition(n);
                    for (int j = 0; j < n; ++j) {
                        object.setOrdinate(j, envelope.getMedian(j));
                    }
                }
                if (bl2) {
                    object.setOrdinate(i, d3);
                    generalEnvelope = coordinateReferenceSystem.transform((DirectPosition)object, (DirectPosition)generalEnvelope);
                    generalEnvelope2.add((DirectPosition)generalEnvelope);
                }
                if (bl) {
                    object.setOrdinate(i, d4);
                    generalEnvelope = coordinateReferenceSystem.transform((DirectPosition)object, (DirectPosition)generalEnvelope);
                    generalEnvelope2.add((DirectPosition)generalEnvelope);
                }
                object.setOrdinate(i, envelope.getMedian(i));
            }
        }
        if ((coordinateSystem = coordinateOperation.getTargetCRS()) == null) {
            return generalEnvelope2;
        }
        generalEnvelope2.setCoordinateReferenceSystem((CoordinateReferenceSystem)coordinateSystem);
        object = coordinateSystem.getCoordinateSystem();
        if (object == null) {
            return generalEnvelope2;
        }
        generalEnvelope = null;
        DirectPosition directPosition = null;
        GeneralDirectPosition generalDirectPosition2 = null;
        int n = object.getDimension();
        for (int i = 0; i < n; ++i) {
            CoordinateSystemAxis coordinateSystemAxis = object.getAxis(i);
            if (coordinateSystemAxis == null) continue;
            boolean bl = false;
            do {
                double d;
                double d5 = d = bl ? coordinateSystemAxis.getMaximumValue() : coordinateSystemAxis.getMinimumValue();
                if (Double.isInfinite(d) || Double.isNaN(d)) continue;
                if (generalDirectPosition2 == null) {
                    try {
                        coordinateReferenceSystem = coordinateReferenceSystem.inverse();
                    }
                    catch (NoninvertibleTransformException noninvertibleTransformException) {
                        if (n >= coordinateReferenceSystem.getSourceDimensions()) {
                            CRS.unexpectedException("transform", (Exception)((Object)noninvertibleTransformException));
                        }
                        return generalEnvelope2;
                    }
                    generalDirectPosition2 = new GeneralDirectPosition(coordinateReferenceSystem.getSourceDimensions());
                    for (int j = 0; j < n; ++j) {
                        generalDirectPosition2.setOrdinate(j, generalDirectPosition.getOrdinate(j));
                    }
                    generalEnvelope = envelope instanceof GeneralEnvelope ? (GeneralEnvelope)envelope : new GeneralEnvelope(envelope);
                }
                generalDirectPosition2.setOrdinate(i, d);
                try {
                    directPosition = coordinateReferenceSystem.transform(generalDirectPosition2, directPosition);
                }
                catch (TransformException transformException) {
                    continue;
                }
                if (!generalEnvelope.contains(directPosition)) continue;
                generalEnvelope2.add(generalDirectPosition2);
            } while (bl = !bl);
            if (generalDirectPosition2 == null) continue;
            generalDirectPosition2.setOrdinate(i, generalDirectPosition.getOrdinate(i));
        }
        return generalEnvelope2;
    }

    public static Rectangle2D transform(MathTransform2D mathTransform2D, Rectangle2D rectangle2D, Rectangle2D rectangle2D2) throws TransformException {
        ArgumentChecks.ensureNonNull((String)"transform", (Object)mathTransform2D);
        if (mathTransform2D instanceof AffineTransform) {
            return XAffineTransform.transform((AffineTransform)mathTransform2D, rectangle2D, rectangle2D2);
        }
        return CRS.transform(mathTransform2D, rectangle2D, rectangle2D2, new Point2D.Double());
    }

    private static Rectangle2D transform(MathTransform2D mathTransform2D, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, Point2D.Double double_) throws TransformException {
        if (rectangle2D == null) {
            return null;
        }
        double d = Double.POSITIVE_INFINITY;
        double d2 = Double.POSITIVE_INFINITY;
        double d3 = Double.NEGATIVE_INFINITY;
        double d4 = Double.NEGATIVE_INFINITY;
        for (int i = 0; i <= 8; ++i) {
            double_.x = (i & 1) == 0 ? rectangle2D.getMinX() : rectangle2D.getMaxX();
            double_.y = (i & 2) == 0 ? rectangle2D.getMinY() : rectangle2D.getMaxY();
            switch (i) {
                case 5: 
                case 6: {
                    double_.x = rectangle2D.getCenterX();
                    break;
                }
                case 8: {
                    double_.x = rectangle2D.getCenterX();
                }
                case 4: 
                case 7: {
                    double_.y = rectangle2D.getCenterY();
                }
            }
            if (double_ != mathTransform2D.transform((Point2D)double_, (Point2D)double_)) {
                throw new UnsupportedImplementationException(mathTransform2D.getClass());
            }
            if (double_.x < d) {
                d = double_.x;
            }
            if (double_.x > d3) {
                d3 = double_.x;
            }
            if (double_.y < d2) {
                d2 = double_.y;
            }
            if (!(double_.y > d4)) continue;
            d4 = double_.y;
        }
        if (rectangle2D2 != null) {
            rectangle2D2.setRect(d, d2, d3 - d, d4 - d2);
        } else {
            rectangle2D2 = XRectangle2D.createFromExtremums((double)d, (double)d2, (double)d3, (double)d4);
        }
        assert (rectangle2D2 == rectangle2D || !(rectangle2D2 instanceof Rectangle2D.Double) && !(rectangle2D2 instanceof Rectangle2D.Float) || XRectangle2D.equalsEpsilon((Rectangle2D)rectangle2D2, (Rectangle2D)CRS.transform((MathTransform)mathTransform2D, (Envelope)new Envelope2D(null, rectangle2D)).toRectangle2D())) : rectangle2D2;
        return rectangle2D2;
    }

    public static Rectangle2D transform(CoordinateOperation coordinateOperation, Rectangle2D rectangle2D, Rectangle2D rectangle2D2) throws TransformException {
        Object object;
        CoordinateSystem coordinateSystem;
        CoordinateSystem coordinateSystem2;
        ArgumentChecks.ensureNonNull((String)"operation", (Object)coordinateOperation);
        if (rectangle2D == null) {
            return null;
        }
        MathTransform mathTransform = coordinateOperation.getMathTransform();
        if (!(mathTransform instanceof MathTransform2D)) {
            throw new MismatchedDimensionException(Errors.format((int)168));
        }
        MathTransform2D mathTransform2D = (MathTransform2D)mathTransform;
        Point2D.Double double_ = new Point2D.Double();
        rectangle2D2 = CRS.transform(mathTransform2D, rectangle2D, rectangle2D2, double_);
        CoordinateReferenceSystem coordinateReferenceSystem = coordinateOperation.getSourceCRS();
        if (coordinateReferenceSystem != null && (coordinateSystem2 = coordinateReferenceSystem.getCoordinateSystem()) != null && coordinateSystem2.getDimension() == 2) {
            coordinateSystem = coordinateSystem2.getAxis(0);
            double d = rectangle2D.getMinX();
            double d2 = rectangle2D.getMaxX();
            object = null;
            for (int i = 0; i < 4; ++i) {
                double d3;
                if (i == 2) {
                    coordinateSystem = coordinateSystem2.getAxis(1);
                    d = rectangle2D.getMinY();
                    d2 = rectangle2D.getMaxY();
                }
                double d4 = d3 = (i & 1) == 0 ? coordinateSystem.getMinimumValue() : coordinateSystem.getMaximumValue();
                if (!(d3 > d) || !(d3 < d2)) continue;
                if (object == null) {
                    object = new Point2D.Double();
                }
                if ((i & 2) == 0) {
                    object.x = d3;
                    object.y = rectangle2D.getCenterY();
                } else {
                    object.x = rectangle2D.getCenterX();
                    object.y = d3;
                }
                rectangle2D2.add(mathTransform2D.transform((Point2D)object, (Point2D)object));
            }
        }
        if ((coordinateSystem2 = coordinateOperation.getTargetCRS()) == null) {
            return rectangle2D2;
        }
        coordinateSystem = coordinateSystem2.getCoordinateSystem();
        if (coordinateSystem == null || coordinateSystem.getDimension() != 2) {
            return rectangle2D2;
        }
        Point2D point2D = null;
        Point2D point2D2 = null;
        for (int i = 0; i < 4; ++i) {
            double d;
            int n = i >> 1;
            object = coordinateSystem.getAxis(n);
            if (object == null) continue;
            double d5 = d = (i & 1) == 0 ? object.getMinimumValue() : object.getMaximumValue();
            if (Double.isInfinite(d) || Double.isNaN(d)) continue;
            if (point2D2 == null) {
                try {
                    mathTransform2D = mathTransform2D.inverse();
                }
                catch (NoninvertibleTransformException noninvertibleTransformException) {
                    CRS.unexpectedException("transform", (Exception)((Object)noninvertibleTransformException));
                    return rectangle2D2;
                }
                point2D2 = new Point2D.Double();
            }
            switch (n) {
                case 0: {
                    point2D2.setLocation(d, double_.y);
                    break;
                }
                case 1: {
                    point2D2.setLocation(double_.x, d);
                    break;
                }
                default: {
                    throw new AssertionError(i);
                }
            }
            try {
                point2D = mathTransform2D.transform(point2D2, point2D);
            }
            catch (TransformException transformException) {
                continue;
            }
            if (!rectangle2D.contains(point2D)) continue;
            rectangle2D2.add(point2D2);
        }
        assert (rectangle2D2 == rectangle2D || XRectangle2D.equalsEpsilon((Rectangle2D)rectangle2D2, (Rectangle2D)CRS.transform(coordinateOperation, (Envelope)new GeneralEnvelope(rectangle2D)).toRectangle2D())) : rectangle2D2;
        return rectangle2D2;
    }

    public static double[] deltaTransform(MathTransform mathTransform, DirectPosition directPosition, double ... dArray) throws TransformException {
        ArgumentChecks.ensureNonNull((String)"transform", (Object)mathTransform);
        int n = mathTransform.getSourceDimensions();
        int n2 = mathTransform.getTargetDimensions();
        double[] dArray2 = new double[n2];
        if (dArray.length != n) {
            throw new IllegalArgumentException(Errors.format((int)113, (Object)"vector", (Object)dArray.length, (Object)n));
        }
        if (mathTransform instanceof AffineTransform) {
            ((AffineTransform)mathTransform).deltaTransform(dArray, 0, dArray2, 0, 1);
        } else {
            int n3;
            double[] dArray3 = new double[2 * Math.max(n, n2)];
            for (n3 = 0; n3 < n; ++n3) {
                double d = directPosition.getOrdinate(n3);
                double d2 = dArray[n3] * 0.5;
                dArray3[n3] = d - d2;
                dArray3[n3 + n] = d + d2;
            }
            mathTransform.transform(dArray3, 0, dArray3, 0, 2);
            for (n3 = 0; n3 < n2; ++n3) {
                dArray2[n3] = dArray3[n3 + n2] - dArray3[n3];
            }
        }
        return dArray2;
    }

    static void unexpectedException(String string, Exception exception) {
        Logging.unexpectedException(CRS.class, (String)string, (Throwable)exception);
    }

    public static synchronized void reset(String string) {
        ArgumentChecks.ensureNonNull((String)"aspects", (Object)string);
        StringTokenizer stringTokenizer = new StringTokenizer(string, ", \t\n\r\f");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            boolean bl = string2.equalsIgnoreCase("all");
            if (bl || string2.equalsIgnoreCase("plugins")) {
                AuthorityFactoryFinder.scanForPlugins();
                standardFactory = null;
                xyFactory = null;
                strictFactory = null;
                lenientFactory = null;
            }
            if (!bl && !string2.equalsIgnoreCase("warnings")) continue;
            UnitaryProjection.resetWarnings();
        }
    }

    static {
        Factories.addChangeListener((ChangeListener)new ChangeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                Class<CRS> clazz = CRS.class;
                synchronized (CRS.class) {
                    crsFactory = null;
                    standardFactory = null;
                    xyFactory = null;
                    strictFactory = null;
                    lenientFactory = null;
                    defaultOrder = null;
                    defaultLenient = null;
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return;
                }
            }
        });
    }
}

