/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.crs;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.jcip.annotations.Immutable;
import org.geotoolkit.internal.referencing.NilReferencingObject;
import org.geotoolkit.io.wkt.Formatter;
import org.geotoolkit.referencing.crs.AbstractCRS;
import org.geotoolkit.referencing.cs.DefaultCompoundCS;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.ArgumentChecks;
import org.geotoolkit.util.ComparisonMode;
import org.geotoolkit.util.Utilities;
import org.geotoolkit.util.collection.CheckedCollection;
import org.geotoolkit.util.collection.UnmodifiableArrayList;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CompoundCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.cs.CoordinateSystem;

@Immutable
public class DefaultCompoundCRS
extends AbstractCRS
implements CompoundCRS {
    private static final long serialVersionUID = -2656710314586929286L;
    private final List<? extends CoordinateReferenceSystem> crs;
    private transient List<SingleCRS> singles;

    private DefaultCompoundCRS() {
        this(NilReferencingObject.INSTANCE);
    }

    public DefaultCompoundCRS(CompoundCRS compoundCRS) {
        super((CoordinateReferenceSystem)compoundCRS);
        if (compoundCRS instanceof DefaultCompoundCRS) {
            DefaultCompoundCRS defaultCompoundCRS = (DefaultCompoundCRS)compoundCRS;
            this.crs = defaultCompoundCRS.crs;
            this.singles = defaultCompoundCRS.singles;
        } else {
            this.crs = this.copy(compoundCRS.getComponents());
        }
    }

    public DefaultCompoundCRS(String string, CoordinateReferenceSystem coordinateReferenceSystem, CoordinateReferenceSystem coordinateReferenceSystem2) {
        this(string, new CoordinateReferenceSystem[]{coordinateReferenceSystem, coordinateReferenceSystem2});
    }

    public DefaultCompoundCRS(String string, CoordinateReferenceSystem coordinateReferenceSystem, CoordinateReferenceSystem coordinateReferenceSystem2, CoordinateReferenceSystem coordinateReferenceSystem3) {
        this(string, new CoordinateReferenceSystem[]{coordinateReferenceSystem, coordinateReferenceSystem2, coordinateReferenceSystem3});
    }

    public DefaultCompoundCRS(String string, CoordinateReferenceSystem[] coordinateReferenceSystemArray) {
        this(Collections.singletonMap("name", string), coordinateReferenceSystemArray);
    }

    public DefaultCompoundCRS(Map<String, ?> map, CoordinateReferenceSystem ... coordinateReferenceSystemArray) {
        super(map, DefaultCompoundCRS.createCoordinateSystem(coordinateReferenceSystemArray));
        this.crs = this.copy(Arrays.asList(coordinateReferenceSystemArray));
    }

    private static CoordinateSystem createCoordinateSystem(CoordinateReferenceSystem[] coordinateReferenceSystemArray) {
        ArgumentChecks.ensureNonNull((String)"crs", (Object)coordinateReferenceSystemArray);
        if (coordinateReferenceSystemArray.length < 2) {
            throw new IllegalArgumentException(Errors.format((int)119, (Object)("crs[" + coordinateReferenceSystemArray.length + ']')));
        }
        CoordinateSystem[] coordinateSystemArray = new CoordinateSystem[coordinateReferenceSystemArray.length];
        for (int i = 0; i < coordinateReferenceSystemArray.length; ++i) {
            ArgumentChecks.ensureNonNull((String)"crs", (int)i, (Object[])coordinateReferenceSystemArray);
            coordinateSystemArray[i] = coordinateReferenceSystemArray[i].getCoordinateSystem();
        }
        return new DefaultCompoundCS(coordinateSystemArray);
    }

    private List<? extends CoordinateReferenceSystem> copy(List<? extends CoordinateReferenceSystem> object) {
        object = this.computeSingleCRS((List<? extends CoordinateReferenceSystem>)object) ? this.singles : UnmodifiableArrayList.wrap((Object[])object.toArray(new CoordinateReferenceSystem[object.size()]));
        return object;
    }

    public static DefaultCompoundCRS wrap(CompoundCRS compoundCRS) {
        return compoundCRS == null || compoundCRS instanceof DefaultCompoundCRS ? (DefaultCompoundCRS)compoundCRS : new DefaultCompoundCRS(compoundCRS);
    }

    public List<CoordinateReferenceSystem> getComponents() {
        return this.crs;
    }

    public List<SingleCRS> getSingleCRS() {
        return this.singles;
    }

    public static List<SingleCRS> getSingleCRS(CoordinateReferenceSystem coordinateReferenceSystem) {
        List<Object> list;
        if (coordinateReferenceSystem instanceof DefaultCompoundCRS) {
            list = ((DefaultCompoundCRS)coordinateReferenceSystem).getSingleCRS();
        } else if (coordinateReferenceSystem instanceof CompoundCRS) {
            List list2 = ((CompoundCRS)coordinateReferenceSystem).getComponents();
            list = new ArrayList<SingleCRS>(list2.size());
            DefaultCompoundCRS.getSingleCRS(list2, list);
        } else {
            list = coordinateReferenceSystem instanceof SingleCRS ? Collections.singletonList((SingleCRS)coordinateReferenceSystem) : Collections.emptyList();
        }
        return list;
    }

    private static boolean getSingleCRS(List<? extends CoordinateReferenceSystem> list, List<SingleCRS> list2) {
        boolean bl = true;
        for (CoordinateReferenceSystem coordinateReferenceSystem : list) {
            if (coordinateReferenceSystem instanceof CompoundCRS) {
                DefaultCompoundCRS.getSingleCRS(((CompoundCRS)coordinateReferenceSystem).getComponents(), list2);
                bl = false;
                continue;
            }
            list2.add((SingleCRS)coordinateReferenceSystem);
        }
        return bl;
    }

    private boolean computeSingleCRS(List<? extends CoordinateReferenceSystem> list) {
        this.singles = new ArrayList<SingleCRS>(list.size());
        boolean bl = DefaultCompoundCRS.getSingleCRS(list, this.singles);
        this.singles = UnmodifiableArrayList.wrap((Object[])this.singles.toArray(new SingleCRS[this.singles.size()]));
        return bl;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        Class clazz;
        objectInputStream.defaultReadObject();
        if (this.crs instanceof CheckedCollection && SingleCRS.class.isAssignableFrom(clazz = ((CheckedCollection)this.crs).getElementType())) {
            this.singles = this.crs;
            return;
        }
        this.computeSingleCRS(this.crs);
    }

    @Override
    public boolean equals(Object object, ComparisonMode comparisonMode) {
        if (object == this) {
            return true;
        }
        if (super.equals(object, comparisonMode)) {
            switch (comparisonMode) {
                case STRICT: {
                    DefaultCompoundCRS defaultCompoundCRS = (DefaultCompoundCRS)object;
                    return Utilities.equals(this.crs, defaultCompoundCRS.crs);
                }
            }
            CompoundCRS compoundCRS = (CompoundCRS)object;
            return Utilities.deepEquals(this.getComponents(), (Object)compoundCRS.getComponents(), (ComparisonMode)comparisonMode);
        }
        return false;
    }

    @Override
    protected int computeHashCode() {
        return Utilities.hash(this.crs, (int)super.computeHashCode());
    }

    @Override
    public String formatWKT(Formatter formatter) {
        for (CoordinateReferenceSystem coordinateReferenceSystem : this.crs) {
            formatter.append((IdentifiedObject)coordinateReferenceSystem);
        }
        return "COMPD_CS";
    }
}

