/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.crs;

import java.util.Collections;
import java.util.Map;
import javax.measure.unit.Unit;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import net.jcip.annotations.Immutable;
import org.geotoolkit.internal.referencing.NilReferencingObject;
import org.geotoolkit.internal.referencing.WktUtilities;
import org.geotoolkit.io.wkt.Formatter;
import org.geotoolkit.referencing.crs.AbstractSingleCRS;
import org.geotoolkit.referencing.cs.DefaultCartesianCS;
import org.geotoolkit.referencing.cs.DefaultSphericalCS;
import org.geotoolkit.referencing.datum.DefaultGeodeticDatum;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.GeocentricCRS;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.SphericalCS;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.datum.GeodeticDatum;

@Immutable
@XmlRootElement(name="GeocentricCRS")
public class DefaultGeocentricCRS
extends AbstractSingleCRS
implements GeocentricCRS {
    private static final long serialVersionUID = 6784642848287659827L;
    public static final DefaultGeocentricCRS CARTESIAN = new DefaultGeocentricCRS(DefaultGeocentricCRS.name(22), (GeodeticDatum)DefaultGeodeticDatum.WGS84, (CartesianCS)DefaultCartesianCS.GEOCENTRIC);
    public static final DefaultGeocentricCRS SPHERICAL = new DefaultGeocentricCRS(DefaultGeocentricCRS.name(278), (GeodeticDatum)DefaultGeodeticDatum.WGS84, (SphericalCS)DefaultSphericalCS.GEOCENTRIC);

    private DefaultGeocentricCRS() {
        this(NilReferencingObject.INSTANCE);
    }

    public DefaultGeocentricCRS(GeocentricCRS geocentricCRS) {
        super((SingleCRS)geocentricCRS);
    }

    public DefaultGeocentricCRS(String string, GeodeticDatum geodeticDatum, CartesianCS cartesianCS) {
        this(Collections.singletonMap("name", string), geodeticDatum, cartesianCS);
    }

    public DefaultGeocentricCRS(String string, GeodeticDatum geodeticDatum, SphericalCS sphericalCS) {
        this(Collections.singletonMap("name", string), geodeticDatum, sphericalCS);
    }

    public DefaultGeocentricCRS(Map<String, ?> map, GeodeticDatum geodeticDatum, CartesianCS cartesianCS) {
        super(map, (Datum)geodeticDatum, (CoordinateSystem)cartesianCS);
    }

    public DefaultGeocentricCRS(Map<String, ?> map, GeodeticDatum geodeticDatum, SphericalCS sphericalCS) {
        super(map, (Datum)geodeticDatum, (CoordinateSystem)sphericalCS);
    }

    public static DefaultGeocentricCRS wrap(GeocentricCRS geocentricCRS) {
        return geocentricCRS == null || geocentricCRS instanceof DefaultGeocentricCRS ? (DefaultGeocentricCRS)geocentricCRS : new DefaultGeocentricCRS(geocentricCRS);
    }

    @XmlElement(name="geodeticDatum")
    public GeodeticDatum getDatum() {
        return (GeodeticDatum)super.getDatum();
    }

    final void setDatum(GeodeticDatum geodeticDatum) {
        super.setDatum((Datum)geodeticDatum);
    }

    @Override
    public String formatWKT(Formatter formatter) {
        Unit<?> unit = this.getUnit();
        GeodeticDatum geodeticDatum = this.getDatum();
        formatter.append((IdentifiedObject)geodeticDatum);
        formatter.append((IdentifiedObject)geodeticDatum.getPrimeMeridian());
        formatter.append(unit);
        CoordinateSystem coordinateSystem = this.getCoordinateSystem();
        if (coordinateSystem instanceof CartesianCS) {
            if (!formatter.isInternalWKT()) {
                coordinateSystem = WktUtilities.replace((CartesianCS)coordinateSystem, true);
            }
        } else {
            formatter.setInvalidWKT(CoordinateSystem.class);
        }
        int n = coordinateSystem.getDimension();
        for (int i = 0; i < n; ++i) {
            formatter.append((IdentifiedObject)coordinateSystem.getAxis(i));
        }
        if (unit == null) {
            formatter.setInvalidWKT(GeocentricCRS.class);
        }
        return "GEOCCS";
    }
}

