/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.cs;

import java.util.Map;
import javax.measure.converter.ConversionException;
import javax.measure.converter.UnitConverter;
import javax.measure.unit.Unit;
import net.jcip.annotations.Immutable;
import org.geotoolkit.internal.referencing.NilReferencingObject;
import org.geotoolkit.measure.Measure;
import org.geotoolkit.referencing.IdentifiedObjects;
import org.geotoolkit.referencing.cs.DefaultAffineCS;
import org.geotoolkit.referencing.cs.DefaultCoordinateSystemAxis;
import org.geotoolkit.resources.Errors;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.cs.AffineCS;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystemAxis;

@Immutable
public class DefaultCartesianCS
extends DefaultAffineCS
implements CartesianCS {
    private static final long serialVersionUID = -6182037957705712945L;
    public static final DefaultCartesianCS PROJECTED = new DefaultCartesianCS((Map<String, ?>)DefaultCartesianCS.name(242), (CoordinateSystemAxis)DefaultCoordinateSystemAxis.EASTING, (CoordinateSystemAxis)DefaultCoordinateSystemAxis.NORTHING);
    public static final DefaultCartesianCS GEOCENTRIC = new DefaultCartesianCS((Map<String, ?>)DefaultCartesianCS.name(115), (CoordinateSystemAxis)DefaultCoordinateSystemAxis.GEOCENTRIC_X, (CoordinateSystemAxis)DefaultCoordinateSystemAxis.GEOCENTRIC_Y, (CoordinateSystemAxis)DefaultCoordinateSystemAxis.GEOCENTRIC_Z);
    public static final DefaultCartesianCS GENERIC_2D = new DefaultCartesianCS((Map<String, ?>)DefaultCartesianCS.name(23), (CoordinateSystemAxis)DefaultCoordinateSystemAxis.X, (CoordinateSystemAxis)DefaultCoordinateSystemAxis.Y);
    public static final DefaultCartesianCS GENERIC_3D = new DefaultCartesianCS((Map<String, ?>)DefaultCartesianCS.name(24), (CoordinateSystemAxis)DefaultCoordinateSystemAxis.X, (CoordinateSystemAxis)DefaultCoordinateSystemAxis.Y, (CoordinateSystemAxis)DefaultCoordinateSystemAxis.Z);
    public static final DefaultCartesianCS GRID = new DefaultCartesianCS((Map<String, ?>)DefaultCartesianCS.name(136), (CoordinateSystemAxis)DefaultCoordinateSystemAxis.COLUMN, (CoordinateSystemAxis)DefaultCoordinateSystemAxis.ROW);
    public static final DefaultCartesianCS DISPLAY = new DefaultCartesianCS((Map<String, ?>)DefaultCartesianCS.name(78), (CoordinateSystemAxis)DefaultCoordinateSystemAxis.DISPLAY_X, (CoordinateSystemAxis)DefaultCoordinateSystemAxis.DISPLAY_Y);
    private volatile transient UnitConverter[] converters;

    private DefaultCartesianCS() {
        this(NilReferencingObject.INSTANCE);
    }

    public DefaultCartesianCS(CartesianCS cartesianCS) {
        super((AffineCS)cartesianCS);
        this.ensurePerpendicularAxis();
    }

    public DefaultCartesianCS(String string, CoordinateSystemAxis coordinateSystemAxis, CoordinateSystemAxis coordinateSystemAxis2) {
        super(string, coordinateSystemAxis, coordinateSystemAxis2);
        this.ensurePerpendicularAxis();
    }

    public DefaultCartesianCS(String string, CoordinateSystemAxis coordinateSystemAxis, CoordinateSystemAxis coordinateSystemAxis2, CoordinateSystemAxis coordinateSystemAxis3) {
        super(string, coordinateSystemAxis, coordinateSystemAxis2, coordinateSystemAxis3);
        this.ensurePerpendicularAxis();
    }

    public DefaultCartesianCS(Map<String, ?> map, CoordinateSystemAxis coordinateSystemAxis, CoordinateSystemAxis coordinateSystemAxis2) {
        super(map, coordinateSystemAxis, coordinateSystemAxis2);
        this.ensurePerpendicularAxis();
    }

    public DefaultCartesianCS(Map<String, ?> map, CoordinateSystemAxis coordinateSystemAxis, CoordinateSystemAxis coordinateSystemAxis2, CoordinateSystemAxis coordinateSystemAxis3) {
        super(map, coordinateSystemAxis, coordinateSystemAxis2, coordinateSystemAxis3);
        this.ensurePerpendicularAxis();
    }

    DefaultCartesianCS(Map<String, ?> map, CoordinateSystemAxis[] coordinateSystemAxisArray) {
        super(map, coordinateSystemAxisArray);
        this.ensurePerpendicularAxis();
    }

    private void ensurePerpendicularAxis() throws IllegalArgumentException {
        int n = this.getDimension();
        for (int i = 0; i < n; ++i) {
            AxisDirection axisDirection = this.getAxis(i).getDirection();
            int n2 = i;
            while (++n2 < n) {
                AxisDirection axisDirection2 = this.getAxis(n2).getDirection();
                double d = DefaultCoordinateSystemAxis.getAngle(axisDirection, axisDirection2);
                if (!(Math.abs(Math.abs(d) - 90.0) > 1.0E-10)) continue;
                throw new IllegalArgumentException(Errors.format((int)137, (Object)axisDirection.name(), (Object)axisDirection2.name()));
            }
        }
    }

    public static DefaultCartesianCS wrap(CartesianCS cartesianCS) {
        return cartesianCS == null || cartesianCS instanceof DefaultCartesianCS ? (DefaultCartesianCS)cartesianCS : new DefaultCartesianCS(cartesianCS);
    }

    @Override
    public Measure distance(double[] dArray, double[] dArray2) throws UnsupportedOperationException, MismatchedDimensionException {
        this.ensureDimensionMatch("coord1", dArray);
        this.ensureDimensionMatch("coord2", dArray2);
        Unit<?> unit = this.getDistanceUnit();
        UnitConverter[] unitConverterArray = this.converters;
        if (unitConverterArray == null) {
            unitConverterArray = new UnitConverter[this.getDimension()];
            for (int i = 0; i < unitConverterArray.length; ++i) {
                Unit unit2 = this.getAxis(i).getUnit();
                try {
                    unitConverterArray[i] = unit2.getConverterToAny(unit);
                    continue;
                }
                catch (ConversionException conversionException) {
                    throw new UnsupportedOperationException(Errors.format((int)92, (Object)unit2), conversionException);
                }
            }
            this.converters = unitConverterArray;
        }
        double d = 0.0;
        for (int i = 0; i < unitConverterArray.length; ++i) {
            UnitConverter unitConverter = unitConverterArray[i];
            double d2 = unitConverter.convert(dArray[i]) - unitConverter.convert(dArray2[i]);
            d += d2 * d2;
        }
        return new Measure(Math.sqrt(d), unit);
    }

    @Override
    public DefaultCartesianCS usingUnit(Unit<?> unit) throws IllegalArgumentException {
        CoordinateSystemAxis[] coordinateSystemAxisArray = this.axisUsingUnit(unit);
        if (coordinateSystemAxisArray == null) {
            return this;
        }
        return new DefaultCartesianCS(IdentifiedObjects.getProperties(this, null), coordinateSystemAxisArray);
    }
}

