/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.datum;

import java.util.Collections;
import java.util.Map;
import net.jcip.annotations.Immutable;
import org.geotoolkit.internal.referencing.NilReferencingObject;
import org.geotoolkit.internal.referencing.VerticalDatumTypes;
import org.geotoolkit.io.wkt.Formatter;
import org.geotoolkit.referencing.datum.AbstractDatum;
import org.geotoolkit.util.ArgumentChecks;
import org.geotoolkit.util.ComparisonMode;
import org.geotoolkit.util.Utilities;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.datum.VerticalDatum;
import org.opengis.referencing.datum.VerticalDatumType;

@Immutable
public class DefaultVerticalDatum
extends AbstractDatum
implements VerticalDatum {
    private static final long serialVersionUID = 380347456670516572L;
    private static final VerticalDatumType[] TYPES = VerticalDatumTypes.values();
    private static final short[] LEGACY_CODES = new short[TYPES.length];
    private final VerticalDatumType type;
    public static final DefaultVerticalDatum BAROMETRIC;
    public static final DefaultVerticalDatum GEOIDAL;
    public static final DefaultVerticalDatum ELLIPSOIDAL;
    public static final DefaultVerticalDatum OTHER_SURFACE;

    private DefaultVerticalDatum() {
        this(NilReferencingObject.INSTANCE);
    }

    public DefaultVerticalDatum(String string, VerticalDatumType verticalDatumType) {
        this(Collections.singletonMap("name", string), verticalDatumType);
    }

    public DefaultVerticalDatum(VerticalDatum verticalDatum) {
        super((Datum)verticalDatum);
        this.type = verticalDatum.getVerticalDatumType();
    }

    public DefaultVerticalDatum(Map<String, ?> map, VerticalDatumType verticalDatumType) {
        super(map);
        this.type = verticalDatumType;
        ArgumentChecks.ensureNonNull((String)"type", (Object)verticalDatumType);
    }

    public static DefaultVerticalDatum wrap(VerticalDatum verticalDatum) {
        return verticalDatum == null || verticalDatum instanceof DefaultVerticalDatum ? (DefaultVerticalDatum)verticalDatum : new DefaultVerticalDatum(verticalDatum);
    }

    public VerticalDatumType getVerticalDatumType() {
        return this.type;
    }

    @Override
    final int getLegacyDatumType() {
        int n = this.type.ordinal();
        if (n >= 0 && n < LEGACY_CODES.length) {
            assert (this.type.equals((Object)TYPES[n])) : this.type;
            return LEGACY_CODES[n];
        }
        return 0;
    }

    public static VerticalDatumType getVerticalDatumTypeFromLegacyCode(int n) {
        for (int i = 0; i < LEGACY_CODES.length; ++i) {
            if (LEGACY_CODES[i] != n) continue;
            return TYPES[i];
        }
        return null;
    }

    @Override
    public boolean equals(Object object, ComparisonMode comparisonMode) {
        if (object == this) {
            return true;
        }
        if (super.equals(object, comparisonMode)) {
            switch (comparisonMode) {
                case STRICT: {
                    DefaultVerticalDatum defaultVerticalDatum = (DefaultVerticalDatum)object;
                    return Utilities.equals((Object)this.type, (Object)defaultVerticalDatum.type);
                }
            }
            VerticalDatum verticalDatum = (VerticalDatum)object;
            return Utilities.equals((Object)this.getVerticalDatumType(), (Object)verticalDatum.getVerticalDatumType());
        }
        return false;
    }

    @Override
    protected int computeHashCode() {
        return Utilities.hash((Object)this.type, (int)super.computeHashCode());
    }

    @Override
    public String formatWKT(Formatter formatter) {
        super.formatWKT(formatter);
        return "VERT_DATUM";
    }

    static {
        DefaultVerticalDatum.LEGACY_CODES[VerticalDatumType.GEOIDAL.ordinal()] = 2005;
        DefaultVerticalDatum.LEGACY_CODES[VerticalDatumTypes.ELLIPSOIDAL.ordinal()] = 2002;
        DefaultVerticalDatum.LEGACY_CODES[VerticalDatumType.DEPTH.ordinal()] = 2006;
        DefaultVerticalDatum.LEGACY_CODES[VerticalDatumType.BAROMETRIC.ordinal()] = 2003;
        DefaultVerticalDatum.LEGACY_CODES[VerticalDatumTypes.ORTHOMETRIC.ordinal()] = 2001;
        DefaultVerticalDatum.LEGACY_CODES[VerticalDatumType.OTHER_SURFACE.ordinal()] = 2000;
        BAROMETRIC = new DefaultVerticalDatum(DefaultVerticalDatum.name(18), VerticalDatumType.BAROMETRIC);
        GEOIDAL = new DefaultVerticalDatum(DefaultVerticalDatum.name(126), VerticalDatumType.GEOIDAL);
        ELLIPSOIDAL = new DefaultVerticalDatum(DefaultVerticalDatum.name(91), VerticalDatumTypes.ELLIPSOIDAL);
        OTHER_SURFACE = new DefaultVerticalDatum(DefaultVerticalDatum.name(223), VerticalDatumType.OTHER_SURFACE);
    }
}

