/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.factory;

import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import org.geotoolkit.internal.DaemonThread;
import org.geotoolkit.internal.Threads;
import org.geotoolkit.math.XMath;
import org.geotoolkit.referencing.factory.ThreadedAuthorityFactory;
import org.geotoolkit.util.logging.Logging;

final class StoreDisposer
extends DaemonThread {
    static final StoreDisposer INSTANCE = new StoreDisposer();
    private final DelayQueue<Ref> queue = new DelayQueue();

    private StoreDisposer() {
        super(Threads.RESOURCE_DISPOSERS, "ReferencingStoreDisposer");
        this.setPriority(6);
    }

    public void run() {
        DelayQueue<Ref> delayQueue;
        Level level = Level.SEVERE;
        while ((delayQueue = this.queue) != null) {
            long l;
            Ref ref;
            if (this.isKillRequested()) {
                level = Level.INFO;
                break;
            }
            try {
                ref = (Ref)delayQueue.take();
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            ThreadedAuthorityFactory threadedAuthorityFactory = (ThreadedAuthorityFactory)((Object)ref.get());
            if (threadedAuthorityFactory == null || (l = threadedAuthorityFactory.disposeExpired()) == Long.MIN_VALUE) continue;
            delayQueue.add(new Ref(threadedAuthorityFactory, l));
        }
        Logging.getLogger(StoreDisposer.class).log(level, "Daemon stopped.");
    }

    final void schedule(ThreadedAuthorityFactory threadedAuthorityFactory, long l) {
        assert (Thread.holdsLock((Object)threadedAuthorityFactory));
        this.queue.add(new Ref(threadedAuthorityFactory, l));
    }

    final long getDelay() {
        Object object = this.queue.peek();
        if (object == null) {
            return 0L;
        }
        return object.getDelay(TimeUnit.MILLISECONDS);
    }

    final void cancel(ThreadedAuthorityFactory threadedAuthorityFactory) {
        assert (Thread.holdsLock((Object)threadedAuthorityFactory));
        Iterator<Ref> iterator = this.queue.iterator();
        while (iterator.hasNext()) {
            ThreadedAuthorityFactory threadedAuthorityFactory2 = (ThreadedAuthorityFactory)((Object)iterator.next().get());
            if (threadedAuthorityFactory2 != null && threadedAuthorityFactory2 != threadedAuthorityFactory) continue;
            iterator.remove();
        }
    }

    public String toString() {
        return "Next in " + this.getDelay() + " ms.";
    }

    static {
        INSTANCE.start();
    }

    private static final class Ref
    extends WeakReference<ThreadedAuthorityFactory>
    implements Delayed {
        private final long schedule;

        Ref(ThreadedAuthorityFactory threadedAuthorityFactory, long l) {
            super(threadedAuthorityFactory);
            this.schedule = l;
        }

        @Override
        public long getDelay(TimeUnit timeUnit) {
            return timeUnit.convert(this.schedule - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
        }

        @Override
        public int compareTo(Delayed delayed) {
            return XMath.sgn((long)(this.schedule - ((Ref)delayed).schedule));
        }
    }
}

