/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.factory;

import java.awt.RenderingHints;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.RejectedExecutionException;
import net.jcip.annotations.ThreadSafe;
import org.geotoolkit.factory.Hints;
import org.geotoolkit.internal.Threads;
import org.geotoolkit.referencing.factory.AbstractAuthorityFactory;
import org.geotoolkit.referencing.factory.CachingAuthorityFactory;
import org.geotoolkit.referencing.factory.NoSuchFactoryException;
import org.geotoolkit.referencing.factory.StoreDisposer;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.ArgumentChecks;
import org.geotoolkit.util.converter.Classes;
import org.geotoolkit.util.logging.Logging;
import org.opengis.util.FactoryException;

@ThreadSafe
public abstract class ThreadedAuthorityFactory
extends CachingAuthorityFactory {
    private final Deque<Store> stores;
    private int remainingBackingStores;
    private final ThreadLocal<Usage> current = new ThreadLocal<Usage>(){

        @Override
        protected Usage initialValue() {
            return new Usage();
        }
    };
    private long timeout = 86400000L;
    static final long TIMEOUT_RESOLUTION = 100L;
    private boolean isActive;
    private volatile boolean hintsInitialized;

    protected ThreadedAuthorityFactory(Hints hints) {
        this(hints, 100, 16);
    }

    protected ThreadedAuthorityFactory(Hints hints, int n, int n2) {
        super(hints, n);
        ThreadedAuthorityFactory.ensureNotSmaller("maxBackingStores", n2, 1);
        this.stores = new LinkedList<Store>();
        this.remainingBackingStores = n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<RenderingHints.Key, ?> getImplementationHints() {
        if (!this.hintsInitialized && !this.unavailable()) {
            AbstractAuthorityFactory abstractAuthorityFactory = null;
            try {
                abstractAuthorityFactory = this.getBackingStore();
                try {
                    Map map = abstractAuthorityFactory.getImplementationHints();
                    ThreadedAuthorityFactory threadedAuthorityFactory = this;
                    synchronized (threadedAuthorityFactory) {
                        if (!this.hintsInitialized) {
                            this.hintsInitialized = true;
                            this.hints.putAll(map);
                        }
                    }
                }
                finally {
                    this.release();
                }
            }
            catch (FactoryException factoryException) {
                ThreadedAuthorityFactory threadedAuthorityFactory = this;
                synchronized (threadedAuthorityFactory) {
                    this.unavailable(factoryException, abstractAuthorityFactory);
                    this.hintsInitialized = true;
                }
            }
        }
        return super.getImplementationHints();
    }

    final synchronized int remainingBackingStores() {
        return this.remainingBackingStores;
    }

    final synchronized int countBackingStores() {
        return this.stores.size();
    }

    protected abstract AbstractAuthorityFactory createBackingStore() throws NoSuchFactoryException, FactoryException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    final AbstractAuthorityFactory getBackingStore() throws FactoryException {
        Usage usage = this.current.get();
        AbstractAuthorityFactory abstractAuthorityFactory = usage.factory;
        if (abstractAuthorityFactory == null) {
            ThreadedAuthorityFactory threadedAuthorityFactory = this;
            synchronized (threadedAuthorityFactory) {
                while (this.remainingBackingStores == 0) {
                    try {
                        ((Object)((Object)this)).wait(2000L);
                    }
                    catch (InterruptedException interruptedException) {
                        throw new FactoryException(interruptedException.getLocalizedMessage(), (Throwable)interruptedException);
                    }
                }
                Store store = this.stores.pollLast();
                if (store != null) {
                    abstractAuthorityFactory = store.factory;
                }
                --this.remainingBackingStores;
            }
            try {
                assert (usage.count == 0);
                if (abstractAuthorityFactory == null && (abstractAuthorityFactory = this.createBackingStore()) == null) {
                    throw new NoSuchFactoryException(Errors.format((int)154));
                }
                usage.factory = abstractAuthorityFactory;
            }
            finally {
                if (abstractAuthorityFactory == null) {
                    threadedAuthorityFactory = this;
                    synchronized (threadedAuthorityFactory) {
                        ++this.remainingBackingStores;
                    }
                }
            }
        }
        ++usage.count;
        return abstractAuthorityFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    final void release() {
        Usage usage = this.current.get();
        if (--usage.count == 0) {
            ThreadedAuthorityFactory threadedAuthorityFactory = this;
            synchronized (threadedAuthorityFactory) {
                ++this.remainingBackingStores;
                AbstractAuthorityFactory abstractAuthorityFactory = usage.factory;
                usage.factory = null;
                Store store = new Store(abstractAuthorityFactory);
                if (!this.stores.offerLast(store)) {
                    this.dispose(abstractAuthorityFactory, false);
                } else {
                    if (!this.isActive) {
                        this.isActive = true;
                        StoreDisposer.INSTANCE.schedule(this, store.timestamp + this.timeout);
                    }
                    ((Object)((Object)this)).notify();
                }
            }
        }
        assert (usage.count >= 0 && usage.factory == null == (usage.count == 0)) : usage.count;
    }

    public synchronized boolean isActive() {
        return this.isActive;
    }

    public synchronized long getTimeout() {
        return this.timeout;
    }

    public synchronized void setTimeout(long l) {
        ArgumentChecks.ensureStrictlyPositive((String)"delay", (long)l);
        this.timeout = l;
    }

    protected boolean canDisposeBackingStore(AbstractAuthorityFactory abstractAuthorityFactory) {
        return true;
    }

    private void dispose(final AbstractAuthorityFactory abstractAuthorityFactory, final boolean bl) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (bl || ThreadedAuthorityFactory.this.canDisposeBackingStore(abstractAuthorityFactory)) {
                    abstractAuthorityFactory.dispose(bl);
                }
            }
        };
        try {
            Threads.executor((boolean)true).execute(runnable);
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            Logging.unexpectedException(ThreadedAuthorityFactory.class, (String)"dispose", (Throwable)rejectedExecutionException);
            runnable.run();
        }
    }

    @Override
    protected synchronized void dispose(boolean bl) {
        Store store;
        StoreDisposer.INSTANCE.cancel(this);
        while ((store = this.stores.pollFirst()) != null) {
            this.dispose(store.factory, bl);
        }
        this.isActive = false;
        this.remainingBackingStores = 0;
        super.dispose(bl);
    }

    final synchronized long disposeExpired() {
        long l = System.currentTimeMillis();
        Iterator<Store> iterator = this.stores.iterator();
        while (iterator.hasNext()) {
            Store store = iterator.next();
            long l2 = this.timeout - (l - store.timestamp);
            if (l2 > 100L) {
                return l + l2;
            }
            iterator.remove();
            this.dispose(store.factory, false);
        }
        this.isActive = false;
        return Long.MIN_VALUE;
    }

    private static final class Usage {
        AbstractAuthorityFactory factory;
        int count;

        private Usage() {
        }

        public String toString() {
            return "Usage[" + Classes.getShortClassName((Object)((Object)this.factory)) + ": " + this.count + ']';
        }
    }

    private static final class Store {
        final AbstractAuthorityFactory factory;
        final long timestamp;

        Store(AbstractAuthorityFactory abstractAuthorityFactory) {
            this.factory = abstractAuthorityFactory;
            this.timestamp = System.currentTimeMillis();
        }

        public String toString() {
            return String.format("Store[%s at %tT]", Classes.getShortClassName((Object)((Object)this.factory)), this.timestamp);
        }
    }
}

