/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.factory.epsg;

import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLNonTransientException;
import java.util.HashMap;
import java.util.Map;
import org.geotoolkit.internal.sql.DefaultDataSource;
import org.geotoolkit.internal.sql.HSQL;
import org.geotoolkit.referencing.factory.epsg.AnsiDialectEpsgFactory;
import org.geotoolkit.referencing.factory.epsg.EpsgInstaller;
import org.geotoolkit.referencing.factory.epsg.EpsgScriptRunner;

final class EmbeddedDataSource
extends DefaultDataSource {
    private static final Map<String, EmbeddedDataSource> SOURCES = new HashMap<String, EmbeddedDataSource>(4);
    private boolean tested;

    private EmbeddedDataSource(String string) {
        super(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static EmbeddedDataSource instance(String string) {
        Map<String, EmbeddedDataSource> map = SOURCES;
        synchronized (map) {
            EmbeddedDataSource embeddedDataSource = SOURCES.get(string);
            if (embeddedDataSource == null) {
                embeddedDataSource = new EmbeddedDataSource(string);
                SOURCES.put(string, embeddedDataSource);
            }
            return embeddedDataSource;
        }
    }

    public Connection getConnection() throws SQLException {
        Connection connection;
        while (!this.createIfEmpty(connection = super.getConnection())) {
        }
        return connection;
    }

    public Connection getConnection(String string, String string2) throws SQLException {
        Connection connection;
        while (!this.createIfEmpty(connection = super.getConnection(string, string2))) {
        }
        return connection;
    }

    private synchronized boolean createIfEmpty(Connection connection) throws SQLException {
        if (!this.tested) {
            this.tested = true;
            if (!AnsiDialectEpsgFactory.exists(connection.getMetaData(), null)) {
                EpsgInstaller epsgInstaller = new EpsgInstaller();
                try {
                    epsgInstaller.call(new EpsgScriptRunner(connection));
                    File file = HSQL.getFile((String)this.url);
                    if (file != null) {
                        HSQL.shutdown((Connection)connection);
                        connection.close();
                        HSQL.setReadOnly((File)file);
                        return false;
                    }
                }
                catch (IOException iOException) {
                    throw new SQLNonTransientException(iOException);
                }
            }
        }
        return true;
    }
}

