/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.factory.web;

import net.jcip.annotations.Immutable;
import org.geotoolkit.referencing.factory.web.Code;
import org.geotoolkit.referencing.factory.web.Factlet;
import org.opengis.parameter.ParameterValueGroup;

@Immutable
final class Auto42001
extends Factlet {
    public static final Auto42001 DEFAULT = new Auto42001();

    private Auto42001() {
    }

    @Override
    public int code() {
        return 42001;
    }

    @Override
    public String getName() {
        return "WGS 84 / Auto UTM";
    }

    @Override
    public String getClassification() {
        return "Transverse_Mercator";
    }

    @Override
    protected void setProjectionParameters(ParameterValueGroup parameterValueGroup, Code code) {
        double d = Math.min(Math.floor((code.longitude + 180.0) / 6.0) + 1.0, 60.0);
        double d2 = -183.0 + d * 6.0;
        double d3 = code.latitude >= 0.0 ? 0.0 : 1.0E7;
        parameterValueGroup.parameter("latitude_of_origin").setValue(0.0);
        parameterValueGroup.parameter("central_meridian").setValue(d2);
        parameterValueGroup.parameter("false_easting").setValue(500000.0);
        parameterValueGroup.parameter("false_northing").setValue(d3);
        parameterValueGroup.parameter("scale_factor").setValue(0.9996);
    }
}

