/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.factory.web;

import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import net.jcip.annotations.Immutable;
import org.geotoolkit.referencing.factory.AbstractAuthorityFactory;
import org.geotoolkit.referencing.factory.web.URN_AuthorityFactory;
import org.geotoolkit.referencing.factory.web.URN_Type;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.resources.Loggings;
import org.geotoolkit.util.Version;
import org.geotoolkit.util.converter.Classes;
import org.opengis.referencing.AuthorityFactory;
import org.opengis.referencing.NoSuchAuthorityCodeException;

@Immutable
final class URN_Parser {
    private static final String[] URN_BASES = new String[]{"urn:ogc:def:", "urn:x-ogc:def:"};
    private static final char SEPARATOR = ':';
    public final String urn;
    public final URN_Type type;
    public final String authority;
    public final Version version;
    public final String code;

    public URN_Parser(String string) throws NoSuchAuthorityCodeException {
        this.urn = string;
        String string2 = string.trim();
        String string3 = string;
        for (int i = 0; i < URN_BASES.length; ++i) {
            int n;
            URN_Type uRN_Type;
            int n2;
            String string4 = URN_BASES[i];
            int n3 = string4.length();
            if (!string2.regionMatches(true, 0, string4, 0, n3) || (n2 = string2.indexOf(58, n3)) < 0 || (uRN_Type = URN_Type.getInstance(string3 = string2.substring(n3, n2).trim())) == null || (n = string2.indexOf(58, n2 + 1)) < 0) continue;
            int n4 = string2.lastIndexOf(58);
            this.version = n4 <= n ? null : new Version(string2.substring(n + 1, n4));
            this.authority = string2.substring(n2 + 1, n).trim();
            this.code = string2.substring(n4 + 1).trim();
            this.type = uRN_Type;
            return;
        }
        throw new NoSuchAuthorityCodeException(Errors.format((int)82, (Object)string3), "urn:ogc:def", string3, string);
    }

    public String getAuthorityCode() {
        return this.authority + ':' + this.code;
    }

    final void logWarningIfTypeMismatch(Class<? extends AuthorityFactory> clazz) {
        if (!clazz.isAssignableFrom(this.type.factoryType)) {
            String string = "...:" + this.type + ':' + this.authority + ':' + this.code;
            LogRecord logRecord = Loggings.format((Level)Level.WARNING, (int)35, (Object)string);
            logRecord.setSourceClassName(URN_AuthorityFactory.class.getName());
            logRecord.setSourceMethodName("get" + Classes.getShortName(clazz));
            Logger logger = AbstractAuthorityFactory.LOGGER;
            logRecord.setLoggerName(logger.getName());
            logger.log(logRecord);
        }
    }

    public String toString() {
        return this.urn;
    }
}

