/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.operation;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import net.jcip.annotations.ThreadSafe;
import org.geotoolkit.factory.AuthorityFactoryFinder;
import org.geotoolkit.factory.Factory;
import org.geotoolkit.factory.FactoryRegistryException;
import org.geotoolkit.factory.Hints;
import org.geotoolkit.internal.referencing.Identifier3D;
import org.geotoolkit.internal.referencing.MatrixUtilities;
import org.geotoolkit.referencing.CRS;
import org.geotoolkit.referencing.IdentifiedObjects;
import org.geotoolkit.referencing.factory.OptionalFactoryOperationException;
import org.geotoolkit.referencing.operation.AbstractCoordinateOperation;
import org.geotoolkit.referencing.operation.DefaultCoordinateOperationFactory;
import org.geotoolkit.referencing.operation.DefaultOperationMethod;
import org.geotoolkit.referencing.operation.transform.ConcatenatedTransform;
import org.geotoolkit.referencing.operation.transform.EllipsoidalTransform;
import org.geotoolkit.resources.Descriptions;
import org.geotoolkit.resources.Loggings;
import org.geotoolkit.util.Utilities;
import org.geotoolkit.util.collection.BackingStoreException;
import org.geotoolkit.util.collection.XCollections;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.quality.ConformanceResult;
import org.opengis.referencing.AuthorityFactory;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.operation.ConcatenatedOperation;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.CoordinateOperationAuthorityFactory;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.referencing.operation.SingleOperation;
import org.opengis.referencing.operation.Transformation;
import org.opengis.util.FactoryException;

@ThreadSafe
public class AuthorityBackedFactory
extends DefaultCoordinateOperationFactory {
    private static final String DEFAULT_AUTHORITY = "EPSG";
    private volatile CoordinateOperationAuthorityFactory authorityFactory;
    private final ThreadLocal<Boolean> processing = new ThreadLocal();

    public AuthorityBackedFactory() {
        this(EMPTY_HINTS);
    }

    public AuthorityBackedFactory(Hints hints) {
        super(hints);
        if (hints == null) {
            hints = EMPTY_HINTS;
        }
        hints = hints.clone();
        hints.keySet().removeAll(this.hints.keySet());
        hints.remove((Object)Hints.FORCE_LONGITUDE_FIRST_AXIS_ORDER);
        hints.remove((Object)Hints.FORCE_STANDARD_AXIS_DIRECTIONS);
        hints.remove((Object)Hints.FORCE_STANDARD_AXIS_UNITS);
        if (!hints.isEmpty()) {
            AuthorityBackedFactory.noForce(hints);
            this.authorityFactory = AuthorityFactoryFinder.getCoordinateOperationAuthorityFactory((String)DEFAULT_AUTHORITY, (Hints)hints);
        }
    }

    private static void noForce(Hints hints) {
        hints.put((Object)Hints.FORCE_LONGITUDE_FIRST_AXIS_ORDER, (Object)Boolean.FALSE);
        hints.put((Object)Hints.FORCE_STANDARD_AXIS_DIRECTIONS, (Object)Boolean.FALSE);
        hints.put((Object)Hints.FORCE_STANDARD_AXIS_UNITS, (Object)Boolean.FALSE);
    }

    @Override
    protected void setOrdering(Factory.Organizer organizer) {
        super.setOrdering(organizer);
        organizer.before(DefaultCoordinateOperationFactory.class, false);
    }

    protected CoordinateOperationAuthorityFactory getAuthorityFactory() {
        CoordinateOperationAuthorityFactory coordinateOperationAuthorityFactory = this.authorityFactory;
        if (coordinateOperationAuthorityFactory == null) {
            Hints hints = EMPTY_HINTS.clone();
            AuthorityBackedFactory.noForce(hints);
            this.authorityFactory = coordinateOperationAuthorityFactory = AuthorityFactoryFinder.getCoordinateOperationAuthorityFactory((String)DEFAULT_AUTHORITY, (Hints)hints);
        }
        return coordinateOperationAuthorityFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MathTransform getMathTransform(CoordinateReferenceSystem coordinateReferenceSystem, CoordinateReferenceSystem coordinateReferenceSystem2) throws FactoryException {
        this.processing.set(Boolean.TRUE);
        try {
            MathTransform mathTransform = this.createOperation(coordinateReferenceSystem, coordinateReferenceSystem2).getMathTransform();
            return mathTransform;
        }
        finally {
            this.processing.set(Boolean.FALSE);
        }
    }

    @Override
    protected CoordinateOperation createFromDatabase(CoordinateReferenceSystem coordinateReferenceSystem, CoordinateReferenceSystem coordinateReferenceSystem2) {
        if (Boolean.TRUE.equals(this.processing.get())) {
            return null;
        }
        CoordinateOperationAuthorityFactory coordinateOperationAuthorityFactory = this.getAuthorityFactory();
        CoordinateOperation coordinateOperation = null;
        int n = 0;
        do {
            CoordinateReferenceSystem coordinateReferenceSystem3;
            CoordinateReferenceSystem coordinateReferenceSystem4 = (n & 2) == 0 ? coordinateReferenceSystem : AuthorityBackedFactory.getHorizontalCRS(coordinateReferenceSystem);
            Object object = coordinateReferenceSystem3 = (n & 1) == 0 ? coordinateReferenceSystem2 : AuthorityBackedFactory.getHorizontalCRS(coordinateReferenceSystem2);
            if (coordinateReferenceSystem4 == null || coordinateReferenceSystem3 == null) continue;
            try {
                coordinateOperation = this.createFromDatabase(coordinateReferenceSystem4, coordinateReferenceSystem3, coordinateOperationAuthorityFactory);
                if (coordinateOperation == null) continue;
                if (n == 0) break;
                coordinateOperation = this.propagateVertical(coordinateOperation, coordinateReferenceSystem4 != coordinateReferenceSystem, coordinateReferenceSystem3 != coordinateReferenceSystem2);
                coordinateOperation = this.complete(coordinateOperation, coordinateReferenceSystem, coordinateReferenceSystem2);
                break;
            }
            catch (FactoryException factoryException) {
                AuthorityBackedFactory.log(factoryException, (AuthorityFactory)coordinateOperationAuthorityFactory);
                return null;
            }
        } while (++n != 4);
        return coordinateOperation;
    }

    private CoordinateOperation createFromDatabase(CoordinateReferenceSystem coordinateReferenceSystem, CoordinateReferenceSystem coordinateReferenceSystem2, CoordinateOperationAuthorityFactory coordinateOperationAuthorityFactory) throws FactoryException {
        boolean bl;
        Set set;
        String string;
        Citation citation = coordinateOperationAuthorityFactory.getAuthority();
        ReferenceIdentifier referenceIdentifier = IdentifiedObjects.getIdentifier((IdentifiedObject)coordinateReferenceSystem, citation);
        if (referenceIdentifier == null) {
            return null;
        }
        ReferenceIdentifier referenceIdentifier2 = IdentifiedObjects.getIdentifier((IdentifiedObject)coordinateReferenceSystem2, citation);
        if (referenceIdentifier2 == null) {
            return null;
        }
        String string2 = referenceIdentifier.getCode().trim();
        if (string2.equals(string = referenceIdentifier2.getCode().trim())) {
            return null;
        }
        try {
            set = coordinateOperationAuthorityFactory.createFromCoordinateReferenceSystemCodes(string2, string);
            bl = XCollections.isNullOrEmpty((Collection)set);
            if (bl && (set = coordinateOperationAuthorityFactory.createFromCoordinateReferenceSystemCodes(string, string2)) == null) {
                return null;
            }
        }
        catch (NoSuchAuthorityCodeException noSuchAuthorityCodeException) {
            AuthorityBackedFactory.log(Level.FINE, noSuchAuthorityCodeException, (AuthorityFactory)coordinateOperationAuthorityFactory, true);
            return null;
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            CoordinateOperation coordinateOperation;
            block11: {
                try {
                    coordinateOperation = (CoordinateOperation)iterator.next();
                    if (coordinateOperation == null) continue;
                    if (!bl) break block11;
                    coordinateOperation = this.inverse(coordinateOperation);
                }
                catch (NoninvertibleTransformException noninvertibleTransformException) {
                    AuthorityBackedFactory.log(Level.FINE, noninvertibleTransformException, (AuthorityFactory)coordinateOperationAuthorityFactory, true);
                    continue;
                }
                catch (FactoryException factoryException) {
                    AuthorityBackedFactory.log(factoryException, (AuthorityFactory)coordinateOperationAuthorityFactory);
                    continue;
                }
                catch (BackingStoreException backingStoreException) {
                    Throwable throwable = backingStoreException.getCause();
                    AuthorityBackedFactory.log(throwable != null ? throwable : backingStoreException, (AuthorityFactory)coordinateOperationAuthorityFactory);
                    continue;
                }
            }
            if (!this.accept(coordinateOperation = this.complete(coordinateOperation, coordinateReferenceSystem, coordinateReferenceSystem2))) continue;
            return coordinateOperation;
        }
        return null;
    }

    private CoordinateOperation complete(CoordinateOperation coordinateOperation, CoordinateReferenceSystem coordinateReferenceSystem, CoordinateReferenceSystem coordinateReferenceSystem2) throws FactoryException {
        MathTransform mathTransform;
        MathTransform mathTransform2;
        CoordinateReferenceSystem coordinateReferenceSystem3 = coordinateOperation.getSourceCRS();
        CoordinateReferenceSystem coordinateReferenceSystem4 = coordinateOperation.getTargetCRS();
        if (!CRS.equalsApproximatively(coordinateReferenceSystem, coordinateReferenceSystem3)) {
            mathTransform2 = this.getMathTransform(coordinateReferenceSystem, coordinateReferenceSystem3);
            coordinateReferenceSystem3 = coordinateReferenceSystem;
        } else {
            mathTransform2 = null;
        }
        if (!CRS.equalsApproximatively(coordinateReferenceSystem4, coordinateReferenceSystem2)) {
            mathTransform = this.getMathTransform(coordinateReferenceSystem4, coordinateReferenceSystem2);
            coordinateReferenceSystem4 = coordinateReferenceSystem2;
        } else {
            mathTransform = null;
        }
        return this.transform(coordinateReferenceSystem3, mathTransform2, coordinateOperation, mathTransform, coordinateReferenceSystem4);
    }

    private CoordinateOperation transform(CoordinateReferenceSystem coordinateReferenceSystem, MathTransform mathTransform, CoordinateOperation coordinateOperation, MathTransform mathTransform2, CoordinateReferenceSystem coordinateReferenceSystem2) throws FactoryException {
        Object object;
        CoordinateOperation[] coordinateOperationArray;
        if ((mathTransform == null || mathTransform.isIdentity()) && (mathTransform2 == null || mathTransform2.isIdentity())) {
            return coordinateOperation;
        }
        Map<String, ?> map = IdentifiedObjects.getProperties((IdentifiedObject)coordinateOperation);
        if (coordinateOperation instanceof ConcatenatedOperation && (coordinateOperationArray = (object = ((ConcatenatedOperation)coordinateOperation).getOperations()).toArray(new CoordinateOperation[object.size()])).length != 0) {
            CoordinateOperation coordinateOperation2 = coordinateOperationArray[0];
            if (coordinateOperationArray.length == 1) {
                coordinateOperationArray[0] = this.transform(coordinateReferenceSystem, mathTransform, coordinateOperation2, mathTransform2, coordinateReferenceSystem2);
            } else {
                CoordinateOperation coordinateOperation3 = coordinateOperationArray[coordinateOperationArray.length - 1];
                coordinateOperationArray[0] = this.transform(coordinateReferenceSystem, mathTransform, coordinateOperation2, null, coordinateOperation2.getTargetCRS());
                coordinateOperationArray[coordinateOperationArray.length - 1] = this.transform(coordinateOperation3.getSourceCRS(), null, coordinateOperation3, mathTransform2, coordinateReferenceSystem2);
            }
            return this.createConcatenatedOperation(map, coordinateOperationArray);
        }
        object = coordinateOperation.getMathTransform();
        coordinateOperationArray = this.getMathTransformFactory();
        if (mathTransform != null) {
            object = coordinateOperationArray.createConcatenatedTransform(mathTransform, (MathTransform)object);
        }
        if (mathTransform2 != null) {
            object = coordinateOperationArray.createConcatenatedTransform((MathTransform)object, mathTransform2);
        }
        assert (!object.equals(coordinateOperation.getMathTransform())) : object;
        Class<? extends CoordinateOperation> clazz = AbstractCoordinateOperation.getType(coordinateOperation);
        OperationMethod operationMethod = null;
        if (coordinateOperation instanceof SingleOperation && (operationMethod = ((SingleOperation)coordinateOperation).getMethod()) != null) {
            Integer n = object.getSourceDimensions();
            Integer n2 = object.getTargetDimensions();
            if (!Utilities.equals((Object)n, (Object)operationMethod.getSourceDimensions()) || !Utilities.equals((Object)n2, (Object)operationMethod.getTargetDimensions())) {
                operationMethod = new DefaultOperationMethod(operationMethod, n, n2);
            }
        }
        return this.createFromMathTransform(map, coordinateReferenceSystem, coordinateReferenceSystem2, (MathTransform)object, operationMethod, clazz);
    }

    private CoordinateOperation propagateVertical(CoordinateOperation coordinateOperation, boolean bl, boolean bl2) throws FactoryException {
        Object object;
        Object object2;
        Object object3;
        MathTransform mathTransform;
        MathTransform[] mathTransformArray;
        Object object4;
        MathTransform mathTransform2 = coordinateOperation.getMathTransform();
        if (mathTransform2 instanceof ConcatenatedTransform) {
            object4 = ((ConcatenatedTransform)mathTransform2).getSteps();
            mathTransformArray = object4.toArray(new MathTransform[object4.size()]);
        } else {
            mathTransformArray = new MathTransform[]{mathTransform2};
        }
        object4 = null;
        EllipsoidalTransform ellipsoidalTransform = null;
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < mathTransformArray.length; ++i) {
            mathTransform = mathTransformArray[i];
            if (!(mathTransform instanceof EllipsoidalTransform)) continue;
            ellipsoidalTransform = (EllipsoidalTransform)mathTransform;
            n2 = i;
            if (object4 != null) continue;
            object4 = ellipsoidalTransform;
            n = i;
        }
        CoordinateReferenceSystem coordinateReferenceSystem = coordinateOperation.getSourceCRS();
        mathTransform = coordinateOperation.getTargetCRS();
        MathTransformFactory mathTransformFactory = this.getMathTransformFactory();
        boolean bl3 = false;
        if (object4 != null) {
            if (n == n2) {
                object2 = object3 = object4.forDimensions(bl, bl2);
            } else {
                object2 = object4.forDimensions(bl, true);
                object3 = ellipsoidalTransform.forDimensions(true, bl2);
            }
            boolean bl4 = false;
            do {
                CoordinateReferenceSystem coordinateReferenceSystem2;
                int n3;
                int n4;
                int n5;
                Object object5;
                if (!bl4) {
                    object5 = object4;
                    object = object2;
                    n5 = n;
                    n4 = n5 - 1;
                    n3 = n5;
                    coordinateReferenceSystem2 = coordinateReferenceSystem;
                } else {
                    object5 = ellipsoidalTransform;
                    object = object3;
                    n5 = n2;
                    n4 = n5 + 1;
                    n3 = mathTransformArray.length - n5 - 1;
                    coordinateReferenceSystem2 = mathTransform;
                }
                if (object5 == object) continue;
                MathTransform mathTransform3 = null;
                boolean bl5 = true;
                if (n3 != 0) {
                    Matrix matrix;
                    int n6;
                    int n7;
                    bl5 = n3 == 1;
                    mathTransform3 = mathTransformArray[n4];
                    if (!bl4) {
                        n7 = mathTransform3.getSourceDimensions();
                        n6 = object.getSourceDimensions();
                        if (bl5 &= n6 > n7) {
                            n7 = n6;
                        }
                    } else {
                        n7 = object.getTargetDimensions();
                        if (bl5 &= n7 > (n6 = mathTransform3.getTargetDimensions())) {
                            n6 = n7;
                        }
                    }
                    if ((matrix = MatrixUtilities.forDimensions(mathTransform3, n7, n6)) == null) continue;
                    mathTransform3 = mathTransformFactory.createAffineTransform(matrix);
                }
                if (bl5) {
                    if (!(coordinateReferenceSystem2 instanceof SingleCRS)) continue;
                    coordinateReferenceSystem2 = this.factories.toGeodetic3D((SingleCRS)coordinateReferenceSystem2);
                    if (!bl4) {
                        coordinateReferenceSystem = coordinateReferenceSystem2;
                    } else {
                        mathTransform = coordinateReferenceSystem2;
                    }
                }
                mathTransformArray[n5] = object;
                if (mathTransform3 != null) {
                    mathTransformArray[n4] = mathTransform3;
                }
                bl3 = true;
            } while (bl4 = !bl4);
            if (bl3) {
                mathTransform2 = mathTransformArray[0];
                for (int i = 1; i < mathTransformArray.length; ++i) {
                    mathTransform2 = mathTransformFactory.createConcatenatedTransform(mathTransform2, mathTransformArray[i]);
                }
            }
        } else if (bl && bl2 && mathTransform2.getSourceDimensions() == 2 && mathTransform2.getTargetDimensions() == 2 && coordinateReferenceSystem instanceof SingleCRS && mathTransform instanceof SingleCRS) {
            coordinateReferenceSystem = this.factories.toGeodetic3D((SingleCRS)coordinateReferenceSystem);
            mathTransform = this.factories.toGeodetic3D((SingleCRS)mathTransform);
            mathTransform2 = mathTransformFactory.createPassThroughTransform(0, mathTransform2, 1);
            bl3 = true;
        }
        if (bl3) {
            object2 = coordinateReferenceSystem.getCoordinateSystem().getDimension();
            object3 = mathTransform.getCoordinateSystem().getDimension();
            Class<? extends CoordinateOperation> clazz = AbstractCoordinateOperation.getType(coordinateOperation);
            OperationMethod operationMethod = null;
            if (coordinateOperation instanceof SingleOperation) {
                operationMethod = ((SingleOperation)coordinateOperation).getMethod();
                if (!Utilities.equals((Object)object2, (Object)operationMethod.getSourceDimensions()) || !Utilities.equals((Object)object3, (Object)operationMethod.getTargetDimensions())) {
                    operationMethod = new DefaultOperationMethod(operationMethod, (Integer)object2, (Integer)object3);
                }
            } else if (coordinateOperation instanceof ConcatenatedOperation) {
                clazz = SingleOperation.class;
                object = new StringBuilder();
                for (SingleOperation singleOperation : ((ConcatenatedOperation)coordinateOperation).getOperations()) {
                    String string = IdentifiedObjects.getIdentifier((IdentifiedObject)singleOperation);
                    if (string != null) {
                        if (((StringBuilder)object).length() != 0) {
                            ((StringBuilder)object).append(" + ");
                        }
                        ((StringBuilder)object).append(string);
                    }
                    if (singleOperation instanceof Transformation) {
                        clazz = Transformation.class;
                        continue;
                    }
                    if (!(singleOperation instanceof Conversion) || clazz == Transformation.class) continue;
                    clazz = Conversion.class;
                }
                operationMethod = new DefaultOperationMethod(Collections.singletonMap("name", Descriptions.format((int)15, (Object)object)), (Integer)object2, (Integer)object3, null);
            }
            coordinateOperation = this.createFromMathTransform(IdentifiedObjects.getProperties((IdentifiedObject)coordinateOperation), coordinateReferenceSystem, (CoordinateReferenceSystem)mathTransform, mathTransform2, operationMethod, clazz);
        }
        return coordinateOperation;
    }

    private static SingleCRS getHorizontalCRS(CoordinateReferenceSystem coordinateReferenceSystem) {
        ReferenceIdentifier referenceIdentifier = coordinateReferenceSystem.getName();
        if (referenceIdentifier instanceof Identifier3D) {
            return ((Identifier3D)referenceIdentifier).horizontalCRS;
        }
        return null;
    }

    private static void log(Throwable throwable, AuthorityFactory authorityFactory) {
        AuthorityBackedFactory.log(Level.WARNING, throwable, authorityFactory, throwable instanceof OptionalFactoryOperationException);
    }

    private static void log(Level level, Throwable throwable, AuthorityFactory authorityFactory, boolean bl) {
        if (LOGGER.isLoggable(level)) {
            LogRecord logRecord = Loggings.format((Level)level, (int)7, (Object)authorityFactory.getAuthority().getTitle());
            logRecord.setSourceClassName(AuthorityBackedFactory.class.getName());
            logRecord.setSourceMethodName("createFromDatabase");
            if (bl) {
                logRecord.setMessage(Loggings.format((LogRecord)logRecord) + ' ' + throwable.getLocalizedMessage());
            } else {
                logRecord.setThrown(throwable);
            }
            logRecord.setLoggerName(LOGGER.getName());
            LOGGER.log(logRecord);
        }
    }

    protected boolean accept(CoordinateOperation coordinateOperation) {
        return true;
    }

    public ConformanceResult availability() {
        try {
            CoordinateOperationAuthorityFactory coordinateOperationAuthorityFactory = this.getAuthorityFactory();
            if (coordinateOperationAuthorityFactory instanceof Factory) {
                return ((Factory)coordinateOperationAuthorityFactory).availability();
            }
        }
        catch (FactoryRegistryException factoryRegistryException) {
            return new Factory.Availability((Factory)this, (Throwable)factoryRegistryException);
        }
        return super.availability();
    }
}

