/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.operation;

import java.text.ParseException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Set;
import javax.measure.converter.ConversionException;
import javax.measure.unit.Unit;
import net.jcip.annotations.ThreadSafe;
import org.geotoolkit.factory.FactoryRegistry;
import org.geotoolkit.factory.Hints;
import org.geotoolkit.internal.referencing.CRSUtilities;
import org.geotoolkit.internal.referencing.MathTransformDecorator;
import org.geotoolkit.internal.referencing.ParameterizedAffine;
import org.geotoolkit.io.wkt.MathTransformParser;
import org.geotoolkit.io.wkt.Symbols;
import org.geotoolkit.metadata.iso.citation.Citations;
import org.geotoolkit.parameter.Parameters;
import org.geotoolkit.referencing.AbstractIdentifiedObject;
import org.geotoolkit.referencing.DefaultReferenceIdentifier;
import org.geotoolkit.referencing.cs.AbstractCS;
import org.geotoolkit.referencing.factory.ReferencingFactory;
import org.geotoolkit.referencing.operation.MathTransformProvider;
import org.geotoolkit.referencing.operation.OperationMethodSet;
import org.geotoolkit.referencing.operation.matrix.MatrixFactory;
import org.geotoolkit.referencing.operation.matrix.XMatrix;
import org.geotoolkit.referencing.operation.transform.ConcatenatedTransform;
import org.geotoolkit.referencing.operation.transform.PassThroughTransform;
import org.geotoolkit.referencing.operation.transform.ProjectiveTransform;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.XArrays;
import org.geotoolkit.util.collection.WeakHashSet;
import org.opengis.metadata.citation.Citation;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.referencing.operation.SingleOperation;
import org.opengis.util.FactoryException;
import org.opengis.util.GenericName;
import org.opengis.util.NoSuchIdentifierException;

@ThreadSafe
public class DefaultMathTransformFactory
extends ReferencingFactory
implements MathTransformFactory {
    private static final Hints HINTS = null;
    private final ThreadLocal<Variables> variables;
    private final WeakHashSet<MathTransform> pool;
    private final FactoryRegistry registry = new FactoryRegistry(MathTransformProvider.class);
    private volatile MathTransformProvider[] providers;

    public DefaultMathTransformFactory() {
        this.pool = WeakHashSet.newInstance(MathTransform.class);
        this.variables = new ThreadLocal();
    }

    @Override
    public Citation getVendor() {
        return Citations.GEOTOOLKIT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MathTransformProvider[] getAvailableMethods() {
        Object[] objectArray = this.providers;
        if (objectArray == null) {
            FactoryRegistry factoryRegistry = this.registry;
            synchronized (factoryRegistry) {
                objectArray = this.providers;
                if (objectArray == null) {
                    Iterator iterator = this.registry.getServiceProviders(MathTransformProvider.class, null, HINTS, null);
                    int n = 0;
                    objectArray = new MathTransformProvider[64];
                    while (iterator.hasNext()) {
                        if (n == objectArray.length) {
                            objectArray = (MathTransformProvider[])Arrays.copyOf(objectArray, n * 2);
                        }
                        objectArray[n++] = (MathTransformProvider)iterator.next();
                    }
                    objectArray = (MathTransformProvider[])XArrays.resize((Object[])objectArray, (int)n);
                    this.providers = objectArray;
                }
            }
        }
        return objectArray;
    }

    public Set<OperationMethod> getAvailableMethods(Class<? extends SingleOperation> clazz) {
        return new OperationMethodSet(this.getAvailableMethods(), clazz);
    }

    public OperationMethod getLastMethodUsed() {
        Variables variables = this.variables.get();
        return variables != null ? variables.lastMethod : null;
    }

    public OperationMethod getOperationMethod(String string) throws NoSuchIdentifierException {
        return this.getProvider(string);
    }

    private MathTransformProvider getProvider(String string) throws NoSuchIdentifierException {
        Object object;
        int n;
        Variables variables = this.variables.get();
        if (variables != null && string.equals(variables.lastCode)) {
            return variables.lastProvider;
        }
        MathTransformProvider mathTransformProvider = null;
        MathTransformProvider[] mathTransformProviderArray = this.getAvailableMethods();
        for (n = 0; n < mathTransformProviderArray.length; ++n) {
            object = mathTransformProviderArray[n];
            if (!((AbstractIdentifiedObject)object).nameMatches(string)) continue;
            mathTransformProvider = object;
            if (!DefaultMathTransformFactory.isDeprecated((OperationMethod)object, string)) break;
        }
        if (mathTransformProvider == null) {
            n = string.indexOf(58);
            while (n >= 0) {
                object = string.substring(0, n).trim();
                String string2 = string.substring(++n).trim();
                for (int i = 0; i < mathTransformProviderArray.length; ++i) {
                    MathTransformProvider mathTransformProvider2 = mathTransformProviderArray[i];
                    if (!mathTransformProvider2.identifierMatches((String)object, string2)) continue;
                    mathTransformProvider = mathTransformProvider2;
                    break;
                }
                n = string.indexOf(58, n);
            }
            if (mathTransformProvider == null) {
                throw new NoSuchIdentifierException(Errors.format((int)170, (Object)string), string);
            }
        }
        if (variables == null) {
            variables = new Variables();
            this.variables.set(variables);
        }
        variables.lastCode = string;
        variables.lastProvider = mathTransformProvider;
        return mathTransformProvider;
    }

    private Variables getLocalVariables() {
        Variables variables = this.variables.get();
        if (variables == null) {
            variables = new Variables();
            this.variables.set(variables);
        }
        return variables;
    }

    static boolean isDeprecated(OperationMethod operationMethod, String string) {
        for (GenericName genericName : operationMethod.getAlias()) {
            DefaultReferenceIdentifier defaultReferenceIdentifier;
            if (!(genericName instanceof DefaultReferenceIdentifier) || !string.equals((defaultReferenceIdentifier = (DefaultReferenceIdentifier)genericName).getCode())) continue;
            return defaultReferenceIdentifier.isDeprecated();
        }
        return false;
    }

    public ParameterValueGroup getDefaultParameters(String string) throws NoSuchIdentifierException {
        return this.getProvider(string).getParameters().createValue();
    }

    public MathTransform createBaseToDerived(CoordinateReferenceSystem coordinateReferenceSystem, ParameterValueGroup parameterValueGroup, CoordinateSystem coordinateSystem) throws NoSuchIdentifierException, FactoryException {
        Unit unit;
        Ellipsoid ellipsoid = CRSUtilities.getHeadGeoEllipsoid(coordinateReferenceSystem);
        if (ellipsoid != null) {
            unit = ellipsoid.getAxisUnit();
            Parameters.ensureSet(parameterValueGroup, "semi_major", ellipsoid.getSemiMajorAxis(), unit, false);
            Parameters.ensureSet(parameterValueGroup, "semi_minor", ellipsoid.getSemiMinorAxis(), unit, false);
        }
        unit = this.createParameterizedTransform(parameterValueGroup);
        Variables variables = this.getLocalVariables();
        OperationMethod operationMethod = variables.lastMethod;
        unit = this.createBaseToDerived(coordinateReferenceSystem, (MathTransform)unit, coordinateSystem);
        variables.lastMethod = operationMethod;
        return unit;
    }

    public MathTransform createBaseToDerived(CoordinateReferenceSystem coordinateReferenceSystem, MathTransform mathTransform, CoordinateSystem coordinateSystem) throws FactoryException {
        XMatrix xMatrix;
        int n;
        int n2;
        Matrix matrix;
        Matrix matrix2;
        CoordinateSystem coordinateSystem2 = coordinateReferenceSystem.getCoordinateSystem();
        try {
            matrix2 = AbstractCS.swapAndScaleAxis(coordinateSystem2, AbstractCS.standard(coordinateSystem2));
            matrix = AbstractCS.swapAndScaleAxis(AbstractCS.standard(coordinateSystem), coordinateSystem);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new FactoryException((Throwable)illegalArgumentException);
        }
        catch (ConversionException conversionException) {
            throw new FactoryException((Throwable)conversionException);
        }
        MathTransform mathTransform2 = this.createAffineTransform(matrix2);
        MathTransform mathTransform3 = this.createAffineTransform(matrix);
        MathTransform mathTransform4 = mathTransform;
        int n3 = mathTransform3.getSourceDimensions() - mathTransform4.getTargetDimensions();
        if (n3 > 0) {
            mathTransform4 = this.createPassThroughTransform(0, mathTransform4, n3);
        }
        if ((n2 = mathTransform2.getTargetDimensions()) > (n = mathTransform4.getSourceDimensions())) {
            xMatrix = MatrixFactory.create(n + 1, n2 + 1);
            xMatrix.setElement(n, n2, 1.0);
            mathTransform2 = this.createConcatenatedTransform(this.createAffineTransform(xMatrix), mathTransform2);
        }
        xMatrix = this.createConcatenatedTransform(this.createConcatenatedTransform(mathTransform2, mathTransform4), mathTransform3);
        if (mathTransform instanceof ParameterizedAffine) {
            xMatrix = ((ParameterizedAffine)mathTransform).wrap((MathTransform)xMatrix);
        }
        return xMatrix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MathTransform createParameterizedTransform(ParameterValueGroup parameterValueGroup) throws NoSuchIdentifierException, FactoryException {
        MathTransform mathTransform;
        MathTransformProvider mathTransformProvider = null;
        try {
            MathTransformProvider mathTransformProvider2;
            String string = parameterValueGroup.getDescriptor().getName().getCode();
            mathTransformProvider = mathTransformProvider2 = this.getProvider(string);
            try {
                parameterValueGroup = mathTransformProvider2.ensureValidValues(parameterValueGroup);
                mathTransform = mathTransformProvider2.createMathTransform(parameterValueGroup);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new FactoryException((Throwable)illegalArgumentException);
            }
            catch (IllegalStateException illegalStateException) {
                throw new FactoryException((Throwable)illegalStateException);
            }
            if (mathTransform instanceof MathTransformDecorator) {
                MathTransformDecorator mathTransformDecorator = (MathTransformDecorator)mathTransform;
                mathTransformProvider = mathTransformDecorator.method;
                mathTransform = mathTransformDecorator.transform;
            }
            mathTransform = (MathTransform)this.pool.unique((Object)mathTransform);
        }
        finally {
            this.getLocalVariables().lastMethod = mathTransformProvider;
        }
        return mathTransform;
    }

    public MathTransform createAffineTransform(Matrix matrix) throws FactoryException {
        Variables variables = this.variables.get();
        if (variables != null) {
            variables.lastMethod = null;
        }
        return (MathTransform)this.pool.unique((Object)ProjectiveTransform.create(matrix));
    }

    public MathTransform createConcatenatedTransform(MathTransform mathTransform, MathTransform mathTransform2) throws FactoryException {
        MathTransform mathTransform3;
        try {
            mathTransform3 = ConcatenatedTransform.create(mathTransform, mathTransform2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new FactoryException((Throwable)illegalArgumentException);
        }
        mathTransform3 = (MathTransform)this.pool.unique((Object)mathTransform3);
        return mathTransform3;
    }

    public MathTransform createPassThroughTransform(int n, MathTransform mathTransform, int n2) throws FactoryException {
        MathTransform mathTransform2;
        try {
            mathTransform2 = PassThroughTransform.create(n, mathTransform, n2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new FactoryException((Throwable)illegalArgumentException);
        }
        mathTransform2 = (MathTransform)this.pool.unique((Object)mathTransform2);
        return mathTransform2;
    }

    public MathTransform createFromXML(String string) throws FactoryException {
        throw new FactoryException("Not yet implemented.");
    }

    public MathTransform createFromWKT(String string) throws FactoryException {
        Variables variables = this.getLocalVariables();
        MathTransformParser mathTransformParser = variables.parser;
        if (mathTransformParser == null) {
            variables.parser = mathTransformParser = new MathTransformParser(Symbols.DEFAULT, this);
        }
        try {
            return mathTransformParser.parseMathTransform(string);
        }
        catch (ParseException parseException) {
            Throwable throwable = parseException.getCause();
            if (throwable instanceof FactoryException) {
                throw (FactoryException)throwable;
            }
            throw new FactoryException((Throwable)parseException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scanForPlugins() {
        FactoryRegistry factoryRegistry = this.registry;
        synchronized (factoryRegistry) {
            this.providers = null;
            this.registry.scanForPlugins();
        }
    }

    private static final class Variables {
        MathTransformParser parser;
        String lastCode;
        MathTransformProvider lastProvider;
        OperationMethod lastMethod;

        private Variables() {
        }
    }
}

