/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.operation.projection;

import java.awt.geom.AffineTransform;
import net.jcip.annotations.Immutable;
import org.geotoolkit.referencing.operation.projection.ProjectionException;
import org.geotoolkit.referencing.operation.projection.UnitaryProjection;

@Immutable
abstract class CassiniOrMercator
extends UnitaryProjection {
    private static final long serialVersionUID = -8816056150503228733L;
    static final double ASSERTION_DOMAIN = 0.08726646259971647;
    private final double en0;
    private final double en1;
    private final double en2;
    private final double en3;
    private final double en4;
    private static final double C00 = 1.0;
    private static final double C02 = 0.25;
    private static final double C04 = 0.046875;
    private static final double C06 = 0.01953125;
    private static final double C08 = 0.01068115234375;
    private static final double C22 = 0.75;
    private static final double C44 = 0.46875;
    private static final double C46 = 0.013020833333333334;
    private static final double C48 = 0.007120768229166667;
    private static final double C66 = 0.3645833333333333;
    private static final double C68 = 0.005696614583333333;
    private static final double C88 = 0.3076171875;

    CassiniOrMercator(UnitaryProjection.Parameters parameters) {
        super(parameters);
        double d = this.excentricitySquared;
        this.en0 = 1.0 - d * (0.25 + d * (0.046875 + d * (0.01953125 + d * 0.01068115234375)));
        this.en1 = d * (0.75 - d * (0.046875 + d * (0.01953125 + d * 0.01068115234375)));
        double d2 = d * d;
        this.en2 = d2 * (0.46875 - d * (0.013020833333333334 + d * 0.007120768229166667));
        this.en3 = (d2 *= d) * (0.3645833333333333 - d * 0.005696614583333333);
        this.en4 = d2 * d * 0.3076171875;
        double d3 = Math.toRadians(parameters.latitudeOfOrigin);
        double d4 = d != 0.0 ? this.mlfn(d3, Math.sin(d3), Math.cos(d3)) : d3;
        parameters.validate();
        AffineTransform affineTransform = parameters.normalize(false);
        affineTransform.translate(0.0, -d4);
        this.finish();
    }

    final double mlfn(double d, double d2, double d3) {
        d3 *= d2;
        d2 *= d2;
        return this.en0 * d - d3 * (this.en1 + d2 * (this.en2 + d2 * (this.en3 + d2 * this.en4)));
    }

    final double dmlfn_d\u03c6(double d, double d2) {
        return this.en0 - this.en1 * (d2 - d) - d * (this.en2 * (3.0 * d2 - d) - d * (this.en3 * (5.0 * d2 - d) - d * (this.en4 * (7.0 * d2 - d))));
    }

    final double inv_mlfn(double d) throws ProjectionException {
        double d2 = 1.0 / (1.0 - this.excentricitySquared);
        double d3 = d;
        int n = 15;
        do {
            double d4 = Math.sin(d3);
            double d5 = 1.0 - this.excentricitySquared * (d4 * d4);
            d5 = (this.mlfn(d3, d4, Math.cos(d3)) - d) * (d5 * Math.sqrt(d5)) * d2;
            d3 -= d5;
            if (!(Math.abs(d5) < 1.0000000000000001E-11)) continue;
            return d3;
        } while (--n >= 0);
        throw new ProjectionException(152);
    }
}

