/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.operation.projection;

import net.jcip.annotations.Immutable;
import org.geotoolkit.internal.InternalUtilities;
import org.geotoolkit.internal.referencing.Identifiers;
import org.geotoolkit.referencing.operation.projection.ProjectionException;
import org.geotoolkit.referencing.operation.projection.UnitaryProjection;
import org.geotoolkit.util.ComparisonMode;
import org.geotoolkit.util.Utilities;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.operation.MathTransform2D;

@Immutable
public class Krovak
extends UnitaryProjection {
    private static final long serialVersionUID = -8359105634355342212L;
    private static final double ITERATION_TOLERANCE = 1.0E-11;
    private final double sinAzim;
    private final double cosAzim;
    private final double n;
    private final double tanS2;
    private final double alfa;
    private final double hae;
    private final double k1;
    private final double ka;
    private final double ro0;
    private static final double s45 = 0.785398163397448;

    public static MathTransform2D create(ParameterDescriptorGroup parameterDescriptorGroup, ParameterValueGroup parameterValueGroup) {
        UnitaryProjection.Parameters parameters = new UnitaryProjection.Parameters(parameterDescriptorGroup, parameterValueGroup);
        Krovak krovak = new Krovak(parameters);
        return krovak.createConcatenatedTransform();
    }

    protected Krovak(UnitaryProjection.Parameters parameters) {
        super(parameters);
        double d;
        double d2 = parameters.latitudeOfOrigin;
        UnitaryProjection.Parameters.ensureLatitudeInRange(org.geotoolkit.referencing.operation.provider.Krovak.LATITUDE_OF_CENTRE, d2, false);
        d2 = Math.toRadians(d2);
        switch (parameters.standardParallels.length) {
            default: {
                throw Krovak.unknownParameter(Identifiers.STANDARD_PARALLEL_2);
            }
            case 0: {
                d = (Double)org.geotoolkit.referencing.operation.provider.Krovak.PSEUDO_STANDARD_PARALLEL.getDefaultValue();
                break;
            }
            case 1: {
                d = parameters.standardParallels[0];
            }
        }
        d = Math.toRadians(d);
        double d3 = Math.toRadians(parameters.azimuth);
        this.sinAzim = Math.sin(d3);
        this.cosAzim = Math.cos(d3);
        this.n = Math.sin(d);
        this.tanS2 = Math.tan(d / 2.0 + 0.785398163397448);
        double d4 = Math.sin(d2);
        double d5 = Math.cos(d2);
        double d6 = d5 * d5;
        this.alfa = Math.sqrt(1.0 + this.excentricitySquared * (d6 * d6) / (1.0 - this.excentricitySquared));
        this.hae = this.alfa * this.excentricity / 2.0;
        double d7 = Math.asin(d4 / this.alfa);
        double d8 = this.excentricity * d4;
        double d9 = Math.pow((1.0 - d8) / (1.0 + d8), this.alfa * this.excentricity / 2.0);
        this.k1 = Math.pow(Math.tan(d2 / 2.0 + 0.785398163397448), this.alfa) * d9 / Math.tan(d7 / 2.0 + 0.785398163397448);
        this.ka = Math.pow(1.0 / this.k1, -1.0 / this.alfa);
        this.ro0 = Math.pow(this.tanS2, -this.n);
        double d10 = Math.sqrt(1.0 - this.excentricitySquared) / (1.0 - this.excentricitySquared * (d4 * d4));
        double d11 = d10 / (this.ro0 * Math.tan(d));
        parameters.normalize(true).scale(-this.alfa, 1.0);
        parameters.validate();
        parameters.normalize(false).scale(-d11, -d11);
        this.finish();
    }

    @Override
    protected void transform(double[] dArray, int n, double[] dArray2, int n2) throws ProjectionException {
        double d = dArray[n];
        double d2 = dArray[n + 1];
        double d3 = this.excentricity * Math.sin(d2);
        double d4 = Math.pow((1.0 - d3) / (1.0 + d3), this.hae);
        double d5 = 2.0 * (Math.atan(Math.pow(Math.tan(d2 / 2.0 + 0.785398163397448), this.alfa) / this.k1 * d4) - 0.785398163397448);
        double d6 = Math.cos(d5);
        double d7 = Math.asin(this.cosAzim * Math.sin(d5) + this.sinAzim * d6 * Math.cos(d));
        double d8 = this.n * Math.asin(d6 * Math.sin(d) / Math.cos(d7));
        double d9 = 1.0 / Math.pow(Math.tan(d7 / 2.0 + 0.785398163397448), this.n);
        dArray2[n2] = d9 * Math.sin(d8);
        dArray2[n2 + 1] = d9 * Math.cos(d8);
    }

    @Override
    protected void inverseTransform(double[] dArray, int n, double[] dArray2, int n2) throws ProjectionException {
        double d;
        double d2;
        double d3 = dArray[n];
        double d4 = dArray[n + 1];
        double d5 = Math.hypot(d3, d4);
        double d6 = Math.atan2(d3, d4) / this.n;
        double d7 = 2.0 * (Math.atan(Math.pow(this.ro0 / d5, 1.0 / this.n) * this.tanS2) - 0.785398163397448);
        double d8 = Math.cos(d7);
        double d9 = Math.asin(this.cosAzim * Math.sin(d7) - this.sinAzim * d8 * Math.cos(d6));
        double d10 = this.ka * Math.pow(Math.tan(d9 / 2.0 + 0.785398163397448), 1.0 / this.alfa);
        double d11 = Math.asin(d8 * Math.sin(d6) / Math.cos(d9));
        double d12 = 0.0;
        int n3 = 15;
        while (!(Math.abs((d2 = d12) - (d12 = 2.0 * (Math.atan(d10 * Math.pow((1.0 + (d = this.excentricity * Math.sin(d2))) / (1.0 - d), this.excentricity / 2.0)) - 0.785398163397448))) <= 1.0E-11)) {
            if (--n3 >= 0) continue;
            throw new ProjectionException(152);
        }
        dArray2[n2] = d11;
        dArray2[n2 + 1] = d12;
    }

    @Override
    protected int computeHashCode() {
        return Utilities.hash((double)this.sinAzim, (int)Utilities.hash((double)this.n, (int)super.computeHashCode()));
    }

    @Override
    public boolean equals(Object object, ComparisonMode comparisonMode) {
        if (super.equals(object, comparisonMode)) {
            Krovak krovak = (Krovak)object;
            return InternalUtilities.epsilonEqual((double)this.sinAzim, (double)krovak.sinAzim, (ComparisonMode)comparisonMode) && InternalUtilities.epsilonEqual((double)this.cosAzim, (double)krovak.cosAzim, (ComparisonMode)comparisonMode) && InternalUtilities.epsilonEqual((double)this.n, (double)krovak.n, (ComparisonMode)comparisonMode) && InternalUtilities.epsilonEqual((double)this.tanS2, (double)krovak.tanS2, (ComparisonMode)comparisonMode) && InternalUtilities.epsilonEqual((double)this.alfa, (double)krovak.alfa, (ComparisonMode)comparisonMode) && InternalUtilities.epsilonEqual((double)this.hae, (double)krovak.hae, (ComparisonMode)comparisonMode) && InternalUtilities.epsilonEqual((double)this.k1, (double)krovak.k1, (ComparisonMode)comparisonMode) && InternalUtilities.epsilonEqual((double)this.ka, (double)krovak.ka, (ComparisonMode)comparisonMode) && InternalUtilities.epsilonEqual((double)this.ro0, (double)krovak.ro0, (ComparisonMode)comparisonMode);
        }
        return false;
    }
}

