/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.operation.projection;

import net.jcip.annotations.Immutable;
import org.geotoolkit.referencing.operation.projection.ProjectionException;
import org.geotoolkit.referencing.operation.projection.Stereographic;
import org.geotoolkit.referencing.operation.projection.UnitaryProjection;

@Immutable
public class ObliqueStereographic
extends Stereographic {
    private static final long serialVersionUID = -1454098847621943639L;
    private static final double ITERATION_TOLERANCE = 1.0E-14;
    private final double C;
    private final double K;
    private final double ratexp;
    private final double phic0;
    private final double cosc0;
    private final double sinc0;

    protected ObliqueStereographic(UnitaryProjection.Parameters parameters) {
        super(parameters, parameters.latitudeOfOrigin);
        double d = this.cos\u03c60 * this.cos\u03c60;
        double d2 = 2.0 * Math.sqrt(1.0 - this.excentricitySquared) / (1.0 - this.excentricitySquared * (this.sin\u03c60 * this.sin\u03c60));
        this.C = Math.sqrt(1.0 + this.excentricitySquared * (d * d) / (1.0 - this.excentricitySquared));
        this.phic0 = Math.asin(this.sin\u03c60 / this.C);
        this.sinc0 = Math.sin(this.phic0);
        this.cosc0 = Math.cos(this.phic0);
        this.ratexp = 0.5 * this.C * this.excentricity;
        this.K = Math.tan(0.5 * this.phic0 + 0.7853981633974483) / (Math.pow(Math.tan(0.5 * this.\u03c60 + 0.7853981633974483), this.C) * ObliqueStereographic.srat(this.excentricity * this.sin\u03c60, this.ratexp));
        parameters.normalize(true).scale(this.C, 1.0);
        parameters.validate();
        parameters.normalize(false).scale(d2, d2);
        this.finish();
    }

    @Override
    protected void transform(double[] dArray, int n, double[] dArray2, int n2) throws ProjectionException {
        double d = this.rollLongitude(dArray[n]);
        double d2 = dArray[n + 1];
        d2 = 2.0 * Math.atan(this.K * Math.pow(Math.tan(0.5 * d2 + 0.7853981633974483), this.C) * ObliqueStereographic.srat(this.excentricity * Math.sin(d2), this.ratexp)) - 1.5707963267948966;
        double d3 = Math.sin(d2);
        double d4 = Math.cos(d2);
        double d5 = Math.cos(d);
        double d6 = 1.0 + this.sinc0 * d3 + this.cosc0 * d4 * d5;
        dArray2[n2] = d4 * Math.sin(d) / d6;
        dArray2[n2 + 1] = (this.cosc0 * d3 - this.sinc0 * d4 * d5) / d6;
    }

    @Override
    protected void inverseTransform(double[] dArray, int n, double[] dArray2, int n2) throws ProjectionException {
        double d;
        double d2;
        double d3;
        double d4 = this.unrollLongitude(dArray[n]);
        double d5 = Math.hypot(d4, d3 = dArray[n + 1]);
        if (Math.abs(d5) < 1.0E-6) {
            d4 = 0.0;
            d3 = this.phic0;
        } else {
            d2 = 2.0 * Math.atan(d5);
            double d6 = Math.sin(d2);
            double d7 = Math.cos(d2);
            d4 = Math.atan2(d4 * d6, d5 * this.cosc0 * d7 - d3 * this.sinc0 * d6);
            d3 = Math.abs(d3 = d7 * this.sinc0 + d3 * d6 * this.cosc0 / d5) >= 1.0 ? Math.copySign(1.5707963267948966, d3) : Math.asin(d3);
        }
        d2 = Math.pow(Math.tan(0.5 * d3 + 0.7853981633974483) / this.K, 1.0 / this.C);
        int n3 = 15;
        while (!(Math.abs((d = 2.0 * Math.atan(d2 * ObliqueStereographic.srat(this.excentricity * Math.sin(d3), -0.5 * this.excentricity)) - 1.5707963267948966) - d3) < 1.0E-14)) {
            d3 = d;
            if (--n3 >= 0) continue;
            throw new ProjectionException(152);
        }
        dArray2[n2] = d4;
        dArray2[n2 + 1] = d3;
    }

    private static double srat(double d, double d2) {
        return Math.pow((1.0 - d) / (1.0 + d), d2);
    }
}

