/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.operation.projection;

import net.jcip.annotations.Immutable;
import org.geotoolkit.referencing.operation.projection.Assertions;
import org.geotoolkit.referencing.operation.projection.ProjectionException;
import org.geotoolkit.referencing.operation.projection.Stereographic;
import org.geotoolkit.referencing.operation.projection.UnitaryProjection;
import org.geotoolkit.referencing.operation.provider.PolarStereographic;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.operation.MathTransform2D;

@Immutable
public class PolarStereographic
extends Stereographic {
    private static final long serialVersionUID = -6635298308431138524L;

    public static MathTransform2D create(ParameterDescriptorGroup parameterDescriptorGroup, ParameterValueGroup parameterValueGroup) {
        UnitaryProjection.Parameters parameters = new UnitaryProjection.Parameters(parameterDescriptorGroup, parameterValueGroup);
        PolarStereographic polarStereographic = PolarStereographic.create(parameters);
        return polarStereographic.createConcatenatedTransform();
    }

    static PolarStereographic create(UnitaryProjection.Parameters parameters) {
        boolean bl = parameters.isSpherical();
        if (parameters.nameMatches(PolarStereographic.North.PARAMETERS)) {
            if (bl) {
                return new Spherical(parameters, false, Boolean.FALSE);
            }
            return new PolarStereographic(parameters, false, Boolean.FALSE);
        }
        if (parameters.nameMatches(PolarStereographic.South.PARAMETERS)) {
            if (bl) {
                return new Spherical(parameters, false, Boolean.TRUE);
            }
            return new PolarStereographic(parameters, false, Boolean.TRUE);
        }
        if (parameters.nameMatches(PolarStereographic.VariantB.PARAMETERS)) {
            if (bl) {
                return new Spherical(parameters, false, null);
            }
            return new Series(parameters, false, null);
        }
        if (bl) {
            return new Spherical(parameters, true, null);
        }
        return new Series(parameters, true, null);
    }

    protected PolarStereographic(UnitaryProjection.Parameters parameters) {
        this(parameters, parameters.nameMatches(org.geotoolkit.referencing.operation.provider.PolarStereographic.PARAMETERS), null);
    }

    private static double latitudeTrueScale(UnitaryProjection.Parameters parameters, boolean bl, Boolean bl2) {
        ParameterDescriptor<Double> parameterDescriptor;
        ParameterDescriptor<Double> parameterDescriptor2 = parameterDescriptor = Boolean.TRUE.equals(bl2) ? PolarStereographic.South.STANDARD_PARALLEL : PolarStereographic.North.STANDARD_PARALLEL;
        double d = bl ? Math.copySign(90.0, parameters.latitudeOfOrigin) : (parameters.standardParallels.length != 0 ? parameters.standardParallels[0] : (Double)parameterDescriptor.getDefaultValue());
        UnitaryProjection.Parameters.ensureLatitudeInRange(parameterDescriptor, d, true);
        return Math.toRadians(d);
    }

    private PolarStereographic(UnitaryProjection.Parameters parameters, boolean bl, Boolean bl2) {
        super(parameters, 90.0);
        double d;
        double d2;
        double d3 = PolarStereographic.latitudeTrueScale(parameters, bl, bl2);
        boolean bl3 = bl2 != null ? bl2 : d3 < 0.0;
        d3 = Math.abs(d3);
        if (Math.abs(d3 - 1.5707963267948966) >= 1.0E-6) {
            d2 = Math.sin(d3);
            d = this.excentricity != 0.0 ? this.msfn(d2, Math.cos(d3)) / this.tsfn(d3, d2) : 1.0 + d2;
        } else {
            d = this.excentricity != 0.0 ? 2.0 / Math.sqrt(Math.pow(1.0 + this.excentricity, 1.0 + this.excentricity) * Math.pow(1.0 - this.excentricity, 1.0 - this.excentricity)) : 2.0;
        }
        d2 = d;
        if (bl3) {
            parameters.normalize(true).scale(1.0, -1.0);
        } else {
            d2 = -d2;
        }
        parameters.validate();
        parameters.normalize(false).scale(d, d2);
        this.finish();
    }

    @Override
    protected void transform(double[] dArray, int n, double[] dArray2, int n2) throws ProjectionException {
        double d = this.rollLongitude(dArray[n]);
        double d2 = dArray[n + 1];
        double d3 = this.tsfn(d2, Math.sin(d2));
        dArray2[n2] = d3 * Math.sin(d);
        dArray2[n2 + 1] = d3 * Math.cos(d);
    }

    @Override
    protected void inverseTransform(double[] dArray, int n, double[] dArray2, int n2) throws ProjectionException {
        double d;
        double d2;
        double d3;
        block1: {
            d3 = dArray[n];
            d2 = dArray[n + 1];
            double d4 = Math.hypot(d3, d2);
            double d5 = 0.5 * this.excentricity;
            d = 0.0;
            int n3 = 15;
            do {
                double d6;
                double d7 = this.excentricity * Math.sin(d);
                double d8 = 1.5707963267948966 - 2.0 * Math.atan(d4 * Math.pow((1.0 - d7) / (1.0 + d7), d5));
                double d9 = d;
                d = d8;
                if (Math.abs(d9 - d6) < 1.0E-10) break block1;
            } while (--n3 >= 0);
            throw new ProjectionException(152);
        }
        dArray2[n2] = Math.atan2(d3, d2);
        dArray2[n2 + 1] = d;
    }

    @Immutable
    static final class Series
    extends PolarStereographic {
        private static final long serialVersionUID = 2795404156883313290L;
        private final double a;
        private final double b;
        private final double c;
        private final double d;

        Series(UnitaryProjection.Parameters parameters, boolean bl, Boolean bl2) {
            super(parameters, bl, bl2);
            double d = this.excentricitySquared * this.excentricitySquared;
            double d2 = d * this.excentricitySquared;
            double d3 = d * d;
            double d4 = 0.058333333333333334 * d2 + 0.07232142857142858 * d3;
            double d5 = 0.026531498015873015 * d3;
            this.a = this.excentricitySquared * 0.5 + 0.20833333333333334 * d + d2 / 12.0 + 0.03611111111111111 * d3 - d4;
            this.b = 2.0 * (0.14583333333333334 * d + 0.12083333333333333 * d2 + 0.07039930555555556 * d3) - 4.0 * d5;
            this.c = d4 * 4.0;
            this.d = d5 * 8.0;
        }

        @Override
        protected void inverseTransform(double[] dArray, int n, double[] dArray2, int n2) throws ProjectionException {
            double d = this.unrollLongitude(dArray[n]);
            double d2 = dArray[n + 1];
            double d3 = Math.hypot(d, d2);
            double d4 = 1.5707963267948966 - 2.0 * Math.atan(d3);
            d = Math.atan2(d, d2);
            double d5 = Math.sin(2.0 * d4);
            double d6 = Math.cos(2.0 * d4);
            d2 = d4 + d5 * (this.a + d6 * (this.b + d6 * (this.c + this.d * d6)));
            assert (this.checkInverseTransform(dArray, n, dArray2, n2, d, d2));
            dArray2[n2] = d;
            dArray2[n2 + 1] = d2;
        }

        private boolean checkInverseTransform(double[] dArray, int n, double[] dArray2, int n2, double d, double d2) throws ProjectionException {
            super.inverseTransform(dArray, n, dArray2, n2);
            return Assertions.checkInverseTransform(dArray2, n2, d, d2);
        }
    }

    @Immutable
    static final class Spherical
    extends PolarStereographic {
        private static final long serialVersionUID = 1655096575897215547L;

        Spherical(UnitaryProjection.Parameters parameters, boolean bl, Boolean bl2) {
            super(parameters, bl, bl2);
            parameters.ensureSpherical();
        }

        @Override
        final boolean isSpherical() {
            return true;
        }

        @Override
        protected void transform(double[] dArray, int n, double[] dArray2, int n2) throws ProjectionException {
            double d = this.rollLongitude(dArray[n]);
            double d2 = dArray[n + 1];
            double d3 = Math.cos(d2) / (1.0 + Math.sin(d2));
            d2 = d3 * Math.cos(d);
            d = d3 * Math.sin(d);
            assert (this.checkTransform(dArray, n, dArray2, n2, d, d2));
            dArray2[n2] = d;
            dArray2[n2 + 1] = d2;
        }

        private boolean checkTransform(double[] dArray, int n, double[] dArray2, int n2, double d, double d2) throws ProjectionException {
            super.transform(dArray, n, dArray2, n2);
            return Assertions.checkTransform(dArray2, n2, d, d2);
        }

        @Override
        protected void inverseTransform(double[] dArray, int n, double[] dArray2, int n2) throws ProjectionException {
            double d = this.unrollLongitude(dArray[n]);
            double d2 = dArray[n + 1];
            double d3 = Math.hypot(d, d2);
            d = Math.atan2(d, d2);
            d2 = 1.5707963267948966 - Math.abs(2.0 * Math.atan(d3));
            assert (this.checkInverseTransform(dArray, n, dArray2, n2, d, d2));
            dArray2[n2] = d;
            dArray2[n2 + 1] = d2;
        }

        private boolean checkInverseTransform(double[] dArray, int n, double[] dArray2, int n2, double d, double d2) throws ProjectionException {
            super.inverseTransform(dArray, n, dArray2, n2);
            return Assertions.checkInverseTransform(dArray2, n2, d, d2);
        }
    }
}

