/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.operation.projection;

import net.jcip.annotations.Immutable;
import org.geotoolkit.referencing.operation.projection.Assertions;
import org.geotoolkit.referencing.operation.projection.CassiniOrMercator;
import org.geotoolkit.referencing.operation.projection.ProjectionException;
import org.geotoolkit.referencing.operation.projection.UnitaryProjection;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.operation.MathTransform2D;

@Immutable
public class Polyconic
extends CassiniOrMercator {
    private static final long serialVersionUID = -4178027711158788385L;

    public static MathTransform2D create(ParameterDescriptorGroup parameterDescriptorGroup, ParameterValueGroup parameterValueGroup) {
        UnitaryProjection.Parameters parameters = new UnitaryProjection.Parameters(parameterDescriptorGroup, parameterValueGroup);
        Polyconic polyconic = parameters.isSpherical() ? new Spherical(parameters) : new Polyconic(parameters);
        return polyconic.createConcatenatedTransform();
    }

    protected Polyconic(UnitaryProjection.Parameters parameters) {
        super(parameters);
    }

    @Override
    protected void transform(double[] dArray, int n, double[] dArray2, int n2) throws ProjectionException {
        double d;
        double d2 = this.rollLongitude(dArray[n]);
        double d3 = dArray[n + 1];
        double d4 = Math.sin(d3);
        double d5 = this.msfn(d4, d = Math.cos(d3)) / d4;
        if (!Double.isInfinite(d5)) {
            d3 = this.mlfn(d3, d4, d) + d5 * (1.0 - Math.cos(d2 *= d4));
            d2 = d5 * Math.sin(d2);
        }
        dArray2[n2] = d2;
        dArray2[n2 + 1] = d3;
    }

    @Override
    protected void inverseTransform(double[] dArray, int n, double[] dArray2, int n2) throws ProjectionException {
        double d = this.unrollLongitude(dArray[n]);
        double d2 = dArray[n + 1];
        if (Math.abs(d2) <= 1.0E-7) {
            d2 = 0.0;
        } else {
            double d3;
            double d4;
            double d5 = d2 * d2 + d * d;
            double d6 = 2.0 * d2;
            int n3 = 15;
            do {
                if (--n3 < 0) {
                    throw new ProjectionException(152);
                }
                d3 = Math.cos(d2);
                if (Math.abs(d3) < 1.0E-10) break;
                double d7 = Math.sin(d2);
                double d8 = d7 * d3;
                double d9 = Math.sqrt(1.0 - this.excentricitySquared * (d7 * d7));
                double d10 = d7 * d9 / d3;
                double d11 = this.mlfn(d2, d7, d3);
                double d12 = d11 * d11 + d5;
                d9 = (1.0 - this.excentricitySquared) / (d9 * d9 * d9);
                d4 = (2.0 * d11 + d10 * d12 - d6 * (d10 * d11 + 1.0)) / (this.excentricitySquared * d8 * (d12 - d6 * d11) / d10 + (d6 - 2.0 * d11) * (d10 * d9 - 1.0 / d8) - 2.0 * d9);
                d2 += d4;
            } while (Math.abs(d4) > 1.0E-10);
            d3 = Math.sin(d2);
            d = Math.asin(d * Math.tan(d2) * Math.sqrt(1.0 - this.excentricitySquared * (d3 * d3))) / d3;
        }
        dArray2[n2] = d;
        dArray2[n2 + 1] = d2;
    }

    @Override
    double getErrorEstimate(double d, double d2) {
        return 0.0;
    }

    @Immutable
    static final class Spherical
    extends Polyconic {
        private static final long serialVersionUID = 8669570024272104893L;
        private final double phi0;

        Spherical(UnitaryProjection.Parameters parameters) {
            super(parameters);
            this.phi0 = Math.toRadians(parameters.latitudeOfOrigin);
        }

        @Override
        final boolean isSpherical() {
            return true;
        }

        @Override
        protected void transform(double[] dArray, int n, double[] dArray2, int n2) throws ProjectionException {
            double d = this.rollLongitude(dArray[n]);
            double d2 = dArray[n + 1];
            double d3 = d * Math.sin(d2);
            double d4 = 1.0 / Math.tan(d2);
            d = Math.sin(d3) * d4;
            d2 = d2 - this.phi0 + d4 * (1.0 - Math.cos(d3));
            assert (this.checkTransform(dArray, n, dArray2, n2, d, d2));
            dArray2[n2] = d;
            dArray2[n2 + 1] = d2;
        }

        private boolean checkTransform(double[] dArray, int n, double[] dArray2, int n2, double d, double d2) throws ProjectionException {
            super.transform(dArray, n, dArray2, n2);
            return Assertions.checkTransform(dArray2, n2, d, d2);
        }

        @Override
        protected void inverseTransform(double[] dArray, int n, double[] dArray2, int n2) throws ProjectionException {
            double d = this.unrollLongitude(dArray[n]);
            double d2 = dArray[n + 1];
            if (Math.abs(d2) <= 1.0E-7) {
                d2 = 0.0;
            } else {
                double d3;
                double d4 = d2;
                double d5 = d * d + d2 * d2;
                int n3 = 15;
                do {
                    if (--n3 < 0) {
                        throw new ProjectionException(152);
                    }
                    double d6 = Math.tan(d2);
                    d3 = (d4 * (d2 * d6 + 1.0) - d2 - 0.5 * (d2 * d2 + d5) * d6) / ((d2 - d4) / d6 - 1.0);
                    d2 -= d3;
                } while (Math.abs(d3) > 1.0E-10);
                d = Math.asin(d * Math.tan(d2)) / Math.sin(d2);
            }
            assert (this.checkInverseTransform(dArray, n, dArray2, n2, d, d2));
            dArray2[n2] = d;
            dArray2[n2 + 1] = d2;
        }

        private boolean checkInverseTransform(double[] dArray, int n, double[] dArray2, int n2, double d, double d2) throws ProjectionException {
            super.inverseTransform(dArray, n, dArray2, n2);
            return Assertions.checkInverseTransform(dArray2, n2, d, d2);
        }
    }
}

