/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.operation.provider;

import net.jcip.annotations.Immutable;
import org.geotoolkit.internal.referencing.Identifiers;
import org.geotoolkit.metadata.iso.citation.Citations;
import org.geotoolkit.referencing.NamedIdentifier;
import org.geotoolkit.referencing.operation.provider.IdentifierCode;
import org.geotoolkit.referencing.operation.provider.LambertConformal2SP;
import org.geotoolkit.referencing.operation.provider.MapProjection;
import org.geotoolkit.resources.Vocabulary;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.operation.ConicProjection;
import org.opengis.referencing.operation.MathTransform2D;

@Immutable
public class AlbersEqualArea
extends MapProjection {
    private static final long serialVersionUID = -7489679528438418778L;
    public static final ParameterDescriptor<Double> CENTRAL_MERIDIAN = Identifiers.CENTRAL_MERIDIAN.select("central_meridian", "Central_Meridian", "Longitude of false origin", "NatOriginLong");
    public static final ParameterDescriptor<Double> LATITUDE_OF_ORIGIN = Identifiers.LATITUDE_OF_ORIGIN.select("latitude_of_origin", "Latitude_Of_Origin", "Latitude of false origin", "NatOriginLat");
    public static final ParameterDescriptor<Double> STANDARD_PARALLEL_1 = LambertConformal2SP.STANDARD_PARALLEL_1;
    public static final ParameterDescriptor<Double> STANDARD_PARALLEL_2 = LambertConformal2SP.STANDARD_PARALLEL_2;
    public static final ParameterDescriptor<Double> FALSE_EASTING = Identifiers.FALSE_EASTING.select("Easting at false origin", "FalseEasting");
    public static final ParameterDescriptor<Double> FALSE_NORTHING = Identifiers.FALSE_NORTHING.select("Northing at false origin", "FalseNorthing");
    public static final ParameterDescriptorGroup PARAMETERS = Identifiers.createDescriptorGroup(new ReferenceIdentifier[]{new NamedIdentifier(Citations.OGC, "Albers_Conic_Equal_Area"), new NamedIdentifier(Citations.EPSG, "Albers Equal Area"), new IdentifierCode(Citations.EPSG, 9822), new NamedIdentifier(Citations.GEOTIFF, "CT_AlbersEqualArea"), new IdentifierCode(Citations.GEOTIFF, 11), new NamedIdentifier(Citations.ESRI, "Albers"), new NamedIdentifier(Citations.ESRI, "Albers_Equal_Area_Conic"), new NamedIdentifier(Citations.GEOTOOLKIT, Vocabulary.formatInternational((int)5))}, (GeneralParameterDescriptor[])new ParameterDescriptor[]{SEMI_MAJOR, SEMI_MINOR, ROLL_LONGITUDE, CENTRAL_MERIDIAN, LATITUDE_OF_ORIGIN, STANDARD_PARALLEL_1, STANDARD_PARALLEL_2, FALSE_EASTING, FALSE_NORTHING});

    public AlbersEqualArea() {
        super(PARAMETERS);
    }

    public Class<ConicProjection> getOperationType() {
        return ConicProjection.class;
    }

    @Override
    protected MathTransform2D createMathTransform(ParameterValueGroup parameterValueGroup) {
        return org.geotoolkit.referencing.operation.projection.AlbersEqualArea.create(this.getParameters(), parameterValueGroup);
    }
}

