/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.operation.provider;

import java.util.Collections;
import javax.measure.quantity.Length;
import javax.measure.unit.SI;
import javax.measure.unit.Unit;
import net.jcip.annotations.Immutable;
import org.geotoolkit.internal.referencing.Identifiers;
import org.geotoolkit.internal.referencing.MathTransformDecorator;
import org.geotoolkit.metadata.iso.citation.Citations;
import org.geotoolkit.parameter.DefaultParameterDescriptor;
import org.geotoolkit.parameter.Parameters;
import org.geotoolkit.referencing.NamedIdentifier;
import org.geotoolkit.referencing.operation.MathTransformProvider;
import org.geotoolkit.referencing.operation.provider.IdentifierCode;
import org.geotoolkit.referencing.operation.provider.MapProjection;
import org.geotoolkit.referencing.operation.transform.GeocentricTransform;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.resources.Vocabulary;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.InvalidParameterValueException;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.MathTransform;

@Immutable
public class EllipsoidToGeocentric
extends MathTransformProvider {
    private static final long serialVersionUID = -5690807111952562344L;
    public static final ParameterDescriptor<Double> SEMI_MAJOR = MapProjection.SEMI_MAJOR;
    public static final ParameterDescriptor<Double> SEMI_MINOR = MapProjection.SEMI_MINOR;
    public static final ParameterDescriptor<Integer> DIM = DefaultParameterDescriptor.create(Collections.singletonMap("name", new NamedIdentifier(Citations.GEOTOOLKIT, "dim")), 3, 2, 3, false);
    public static final ParameterDescriptorGroup PARAMETERS = EllipsoidToGeocentric.createDescriptorGroup("Ellipsoid_To_Geocentric");
    private final EllipsoidToGeocentric complement;

    static ParameterDescriptorGroup createDescriptorGroup(String string) {
        return Identifiers.createDescriptorGroup(new ReferenceIdentifier[]{new NamedIdentifier(Citations.OGC, string), new NamedIdentifier(Citations.EPSG, "Geographic/geocentric conversions"), new IdentifierCode(Citations.EPSG, 9602), new NamedIdentifier(Citations.GEOTOOLKIT, Vocabulary.formatInternational((int)117))}, (GeneralParameterDescriptor[])new ParameterDescriptor[]{SEMI_MAJOR, SEMI_MINOR, DIM});
    }

    public EllipsoidToGeocentric() {
        super(3, 3, PARAMETERS);
        this.complement = new EllipsoidToGeocentric(this);
    }

    private EllipsoidToGeocentric(EllipsoidToGeocentric ellipsoidToGeocentric) {
        super(2, 3, PARAMETERS);
        this.complement = ellipsoidToGeocentric;
    }

    public Class<Conversion> getOperationType() {
        return Conversion.class;
    }

    static int dimension(ParameterValueGroup parameterValueGroup) throws InvalidParameterValueException {
        Integer n = Parameters.integerValue(DIM, parameterValueGroup);
        if (n != null) {
            switch (n) {
                case 2: 
                case 3: {
                    return n;
                }
            }
            String string = DIM.getName().getCode();
            throw new InvalidParameterValueException(Errors.format((int)73, (Object)string, (Object)n), string, (Object)n);
        }
        return 3;
    }

    @Override
    protected MathTransform createMathTransform(ParameterValueGroup parameterValueGroup) throws ParameterNotFoundException {
        double d = Parameters.doubleValue(SEMI_MAJOR, parameterValueGroup);
        double d2 = Parameters.doubleValue(SEMI_MINOR, parameterValueGroup);
        int n = EllipsoidToGeocentric.dimension(parameterValueGroup);
        MathTransform mathTransform = GeocentricTransform.create(d, d2, (Unit<Length>)SI.METRE, n != 2);
        if (n != this.sourceDimension) {
            mathTransform = new MathTransformDecorator(mathTransform, this.complement);
        }
        return mathTransform;
    }
}

