/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.operation.provider;

import net.jcip.annotations.Immutable;
import org.geotoolkit.metadata.iso.citation.Citations;
import org.geotoolkit.referencing.DefaultReferenceIdentifier;
import org.geotoolkit.resources.Vocabulary;
import org.opengis.metadata.citation.Citation;
import org.opengis.util.InternationalString;

@Immutable
final class IdentifierCode
extends DefaultReferenceIdentifier {
    private static final long serialVersionUID = 357222258307746767L;
    final int supersededBy;

    IdentifierCode(Citation citation, int n) {
        this(citation, n, 0);
    }

    IdentifierCode(Citation citation, int n, int n2) {
        super(citation, IdentifierCode.codespace(citation), Integer.toString(n), null, IdentifierCode.remarks(n2));
        this.supersededBy = n2;
    }

    private static String codespace(Citation citation) {
        if (citation == Citations.EPSG) {
            return "EPSG";
        }
        if (citation == Citations.GEOTIFF) {
            return "GeoTIFF";
        }
        throw new IllegalArgumentException(citation.getTitle().toString());
    }

    private static InternationalString remarks(int n) {
        if (n == 0) {
            return null;
        }
        return Vocabulary.formatInternational((int)286, (Object)n);
    }

    public boolean isDeprecated() {
        return this.supersededBy != 0;
    }
}

