/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.operation.provider;

import net.jcip.annotations.Immutable;
import org.geotoolkit.internal.referencing.Identifiers;
import org.geotoolkit.metadata.iso.citation.Citations;
import org.geotoolkit.referencing.NamedIdentifier;
import org.geotoolkit.referencing.operation.projection.Mercator;
import org.geotoolkit.referencing.operation.provider.IdentifierCode;
import org.geotoolkit.referencing.operation.provider.MapProjection;
import org.geotoolkit.resources.Vocabulary;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.operation.CylindricalProjection;
import org.opengis.referencing.operation.MathTransform2D;

@Immutable
public class Mercator1SP
extends MapProjection {
    private static final long serialVersionUID = -5886510621481710072L;
    public static final ParameterDescriptor<Double> CENTRAL_MERIDIAN = Identifiers.CENTRAL_MERIDIAN.select("central_meridian", "Central_Meridian", "Longitude of natural origin", "NatOriginLong");
    public static final ParameterDescriptor<Double> LATITUDE_OF_ORIGIN = Identifiers.LATITUDE_OF_ORIGIN.select("latitude_of_origin", "Latitude of natural origin", "Standard_Parallel_1", "NatOriginLat");
    public static final ParameterDescriptor<Double> SCALE_FACTOR = Identifiers.SCALE_FACTOR.select("Scale factor at natural origin", "ScaleAtNatOrigin");
    public static final ParameterDescriptor<Double> FALSE_EASTING = Identifiers.FALSE_EASTING.select("False easting", "FalseEasting");
    public static final ParameterDescriptor<Double> FALSE_NORTHING = Identifiers.FALSE_NORTHING.select("False northing", "FalseNorthing");
    public static final ParameterDescriptorGroup PARAMETERS = Identifiers.createDescriptorGroup(new ReferenceIdentifier[]{new NamedIdentifier(Citations.OGC, "Mercator_1SP"), new NamedIdentifier(Citations.EPSG, "Mercator (variant A)"), new NamedIdentifier(Citations.EPSG, "Mercator (1SP)"), new NamedIdentifier(Citations.EPSG, "Mercator (Spherical)"), new NamedIdentifier(Citations.EPSG, "Mercator (1SP) (Spherical)"), new IdentifierCode(Citations.EPSG, 9804), new IdentifierCode(Citations.EPSG, 1026), new IdentifierCode(Citations.EPSG, 9841), new NamedIdentifier(Citations.GEOTIFF, "CT_Mercator"), new IdentifierCode(Citations.GEOTIFF, 7), new NamedIdentifier(Citations.GEOTOOLKIT, Vocabulary.formatInternational((int)52))}, (GeneralParameterDescriptor[])new ParameterDescriptor[]{SEMI_MAJOR, SEMI_MINOR, ROLL_LONGITUDE, LATITUDE_OF_ORIGIN, CENTRAL_MERIDIAN, SCALE_FACTOR, FALSE_EASTING, FALSE_NORTHING});

    public Mercator1SP() {
        super(PARAMETERS);
    }

    public Class<CylindricalProjection> getOperationType() {
        return CylindricalProjection.class;
    }

    @Override
    protected MathTransform2D createMathTransform(ParameterValueGroup parameterValueGroup) {
        return Mercator.create(this.getParameters(), parameterValueGroup);
    }
}

