/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.operation.provider;

import net.jcip.annotations.Immutable;
import org.geotoolkit.internal.referencing.Identifiers;
import org.geotoolkit.metadata.iso.citation.Citations;
import org.geotoolkit.referencing.NamedIdentifier;
import org.geotoolkit.referencing.operation.provider.IdentifierCode;
import org.geotoolkit.referencing.operation.provider.MapProjection;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.operation.ConicProjection;
import org.opengis.referencing.operation.MathTransform2D;

@Immutable
public class Polyconic
extends MapProjection {
    private static final long serialVersionUID = 1681887819214500096L;
    public static final ParameterDescriptor<Double> CENTRAL_MERIDIAN = Identifiers.CENTRAL_MERIDIAN.select("central_meridian", "Central_Meridian", "Longitude of natural origin", "NatOriginLong");
    public static final ParameterDescriptor<Double> LATITUDE_OF_ORIGIN = Identifiers.LATITUDE_OF_ORIGIN.select("latitude_of_origin", "Latitude of natural origin", "Standard_Parallel_1", "NatOriginLat");
    public static final ParameterDescriptor<Double> FALSE_EASTING = Identifiers.FALSE_EASTING.select("False easting", "FalseEasting");
    public static final ParameterDescriptor<Double> FALSE_NORTHING = Identifiers.FALSE_NORTHING.select("False northing", "FalseNorthing");
    public static final ParameterDescriptorGroup PARAMETERS = Identifiers.createDescriptorGroup(new ReferenceIdentifier[]{new NamedIdentifier(Citations.OGC, "Polyconic"), new NamedIdentifier(Citations.EPSG, "American Polyconic"), new IdentifierCode(Citations.EPSG, 9818), new NamedIdentifier(Citations.GEOTIFF, "CT_Polyconic"), new IdentifierCode(Citations.GEOTIFF, 22)}, (GeneralParameterDescriptor[])new ParameterDescriptor[]{SEMI_MAJOR, SEMI_MINOR, ROLL_LONGITUDE, LATITUDE_OF_ORIGIN, CENTRAL_MERIDIAN, FALSE_EASTING, FALSE_NORTHING});

    public Polyconic() {
        super(PARAMETERS);
    }

    public Class<ConicProjection> getOperationType() {
        return ConicProjection.class;
    }

    @Override
    protected MathTransform2D createMathTransform(ParameterValueGroup parameterValueGroup) {
        return org.geotoolkit.referencing.operation.projection.Polyconic.create(this.getParameters(), parameterValueGroup);
    }
}

